/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.rest.impl;

import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.karaf.licencemgr.metadata.jaxb.ErrorMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadataList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencemgr.metadata.jaxb.ReplyMessage;
import org.opennms.karaf.licencemgr.rest.LicencePublisherRest;
import org.opennms.karaf.licencemgr.rest.impl.ServiceLoader;
import org.opennms.karaf.licencepub.LicencePublisher;

@Path(value="/licence-pub")
public class LicencePublisherRestImpl
implements LicencePublisherRest {
    @Override
    @POST
    @Path(value="/addlicencespec")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response addLicenceSpec(LicenceSpecification licenceSpec) {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        try {
            if (licenceSpec == null) {
                throw new RuntimeException("licenceSpec cannot be null.");
            }
            licencePublisher.addLicenceSpec(licenceSpec);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to add licence specification", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Licence Specification successfully added");
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/removelicencespec")
    @Produces(value={"application/xml"})
    public Response removeLicenceSpec(@QueryParam(value="productId") String productId) {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        Boolean removed = null;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            removed = licencePublisher.removeLicenceSpec(productId);
            String devMessage = null;
            if (!removed.booleanValue()) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Licence Specification not found to remove for productId=" + productId, null, devMessage)).build();
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to remove licence specification", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Licence Specification successfully removed for productId=" + productId);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/getlicencespec")
    @Produces(value={"application/xml"})
    public Response getLicenceSpec(@QueryParam(value="productId") String productId) {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        LicenceSpecification licenceSpec = null;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            licenceSpec = licencePublisher.getLicenceSpec(productId);
            String devMessage = null;
            if (licenceSpec == null) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Licence Specification not found for productId=" + productId, null, devMessage)).build();
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to get licence specification", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Licence Specification found for productId=" + productId);
        reply.setLicenceSpecification(licenceSpec);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/getlicencemetadataspec")
    @Produces(value={"application/xml"})
    public Response getLicenceMetadata(@QueryParam(value="productId") String productId) {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        LicenceSpecification licenceSpec = null;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            licenceSpec = licencePublisher.getLicenceSpec(productId);
            String devMessage = null;
            if (licenceSpec == null) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Licence Metadata not found for productId=" + productId, null, devMessage)).build();
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to get Licence Metadata", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Licence Metadata Spec found for productId=" + productId);
        reply.setLicenceMetadataSpec(licenceSpec.getLicenceMetadataSpec());
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/listspecs")
    @Produces(value={"application/xml"})
    public Response getLicenceSpecList() {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        Map<String, LicenceSpecification> lcnceSpecMap = null;
        try {
            lcnceSpecMap = licencePublisher.getLicenceSpecMap();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to get licence specification map", null, exception)).build();
        }
        LicenceSpecList licenceSpecList = new LicenceSpecList();
        licenceSpecList.getLicenceSpecList().addAll(lcnceSpecMap.values());
        return Response.status((int)200).entity((Object)licenceSpecList).build();
    }

    @Override
    @GET
    @Path(value="/list")
    @Produces(value={"application/xml"})
    public Response getLicenceMetadataList() {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        Map<String, LicenceSpecification> lcnceSpecMap = null;
        try {
            lcnceSpecMap = licencePublisher.getLicenceSpecMap();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to get licence specification map", null, exception)).build();
        }
        LicenceMetadataList licenceMetadataList = new LicenceMetadataList();
        Collection<LicenceSpecification> licenceSpecs = lcnceSpecMap.values();
        for (LicenceSpecification lspec : licenceSpecs) {
            LicenceMetadata licenceMetadataSpec = lspec.getLicenceMetadataSpec();
            licenceMetadataList.getLicenceMetadataList().add(licenceMetadataSpec);
        }
        return Response.status((int)200).entity((Object)licenceMetadataList).build();
    }

    @Override
    @GET
    @Path(value="/clearlicencespecs")
    @Produces(value={"application/xml"})
    public Response deleteLicenceSpecifications(@QueryParam(value="confirm") String confirm) {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        try {
            if (!"true".equals(confirm)) {
                throw new IllegalArgumentException("Will only delete specs if paramater confirm=true");
            }
            licencePublisher.deleteLicenceSpecifications();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to delete licence specifications", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("All Licence Specifications removed");
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @POST
    @Path(value="/createlicence")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response createLicenceInstanceStr(LicenceMetadata licenceMetadata) {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        String licenceInstanceStr = null;
        try {
            if (licenceMetadata == null) {
                throw new RuntimeException("licenceMetadata cannot be null.");
            }
            licenceInstanceStr = licencePublisher.createLicenceInstanceStr(licenceMetadata);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to create licence instance", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Successfully created licence instance");
        reply.setLicence(licenceInstanceStr);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @POST
    @Path(value="/createmultilicence")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response createMultiLicenceInstance(LicenceMetadataList licenceMetadataList) {
        LicencePublisher licencePublisher = ServiceLoader.getLicencePublisher();
        if (licencePublisher == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        LicenceList licenceList = null;
        try {
            if (licenceMetadataList == null) {
                throw new RuntimeException("icenceMetadataList cannot be null.");
            }
            licenceList = licencePublisher.createMultiLicences(licenceMetadataList);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to create icenceMetadataList", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Successfully created licence instance");
        reply.setLicenceList(licenceList);
        return Response.status((int)200).entity((Object)reply).build();
    }
}

