/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.rest.client.jerseyimpl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import javax.ws.rs.core.MediaType;
import org.opennms.karaf.licencemgr.metadata.jaxb.ErrorMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadataList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencemgr.metadata.jaxb.ReplyMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.Util;
import org.opennms.karaf.licencemgr.rest.client.LicencePublisherClient;

public class LicencePublisherClientRestJerseyImpl
implements LicencePublisherClient {
    private String baseUrl = "http://localhost:8181";
    private String basePath = "/licencemgr/rest/v1-0/licence-pub";
    private String userName = null;
    private String password = "";

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new RuntimeException("password must not be set to null");
        }
        this.password = password;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private Client newClient() {
        Client client = Client.create();
        if (this.userName != null && !"".equals(this.userName)) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.userName, this.password));
        }
        return client;
    }

    @Override
    public void addLicenceSpec(LicenceSpecification licenceSpec) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (licenceSpec == null) {
            throw new RuntimeException("licenceSpec must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/addlicencespec");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/xml")).post(ClientResponse.class, (Object)licenceSpec);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public void removeLicenceSpec(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/removelicencespec?productId=" + productId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "removeProductSpec Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public LicenceSpecification getLicenceSpec(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/getlicencespec?productId=" + productId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getlicencespec Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        LicenceSpecification licenceSpecification = replyMessage.getLicenceSpecification();
        return licenceSpecification;
    }

    @Override
    public LicenceMetadata getLicenceMetadata(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/getlicencemetadataspec?productId=" + productId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getlicencespec Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        LicenceMetadata licenceMetadata = replyMessage.getLicenceMetadataSpec();
        return licenceMetadata;
    }

    @Override
    public LicenceSpecList getLicenceSpecList() throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        String getStr = this.baseUrl + this.basePath + "/listspecs";
        WebResource r = client.resource(getStr);
        String replyString = (String)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class);
        LicenceSpecList licenceSpecList = null;
        Object replyObject = Util.fromXml(replyString);
        if (!(replyObject instanceof LicenceSpecList)) {
            throw new RuntimeException("received unexpected reply object: " + replyObject.getClass().getCanonicalName());
        }
        licenceSpecList = (LicenceSpecList)replyObject;
        return licenceSpecList;
    }

    @Override
    public LicenceMetadataList getLicenceMetadataList() throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        String getStr = this.baseUrl + this.basePath + "/list";
        WebResource r = client.resource(getStr);
        String replyString = (String)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class);
        LicenceMetadataList licenceMetadataSpecList = null;
        Object replyObject = Util.fromXml(replyString);
        if (!(replyObject instanceof LicenceMetadataList)) {
            throw new RuntimeException("received unexpected reply object: " + replyObject.getClass().getCanonicalName());
        }
        licenceMetadataSpecList = (LicenceMetadataList)replyObject;
        return licenceMetadataSpecList;
    }

    @Override
    public void deleteLicenceSpecifications(Boolean confirm) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (confirm == null) {
            throw new RuntimeException("confirm must be set true of false");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/clearlicencespecs?confirm=" + (confirm != false ? "true" : "false"));
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "clearProductSpecs Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public String createLicenceInstanceStr(LicenceMetadata licenceMetadata) {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (licenceMetadata == null) {
            throw new RuntimeException("licenceMetadata must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/createlicence");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/xml")).post(ClientResponse.class, (Object)licenceMetadata);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        String licenceStr = replyMessage.getLicence();
        return licenceStr;
    }

    @Override
    public LicenceList createMultiLicenceInstance(LicenceMetadataList licenceMetadataList) {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (licenceMetadataList == null) {
            throw new RuntimeException("licenceMetadata must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/createmultilicence");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/xml")).post(ClientResponse.class, (Object)licenceMetadataList);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        LicenceList licenceList = replyMessage.getLicenceList();
        return licenceList;
    }
}

