/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.metadata;

import java.util.Calendar;
import java.util.Date;
import org.opennms.karaf.licencemgr.AesSymetricKeyCipher;
import org.opennms.karaf.licencemgr.ClientKeys;
import org.opennms.karaf.licencemgr.PublisherKeys;
import org.opennms.karaf.licencemgr.RsaAsymetricKeyCipher;
import org.opennms.karaf.licencemgr.StringCrc32Checksum;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;

public class Licence {
    private final LicenceMetadata licenceMetadata;
    private final String licenceStrPlusCrc;

    public LicenceMetadata getLicenceMetadata() {
        return this.licenceMetadata;
    }

    public String getLicenceStrPlusCrc() {
        return this.licenceStrPlusCrc;
    }

    public Licence(LicenceMetadata licenceMetadata, PublisherKeys publisherKeys) {
        this(licenceMetadata, publisherKeys.getPublicKeyStr(), publisherKeys.getAesSecretKeyStr());
    }

    public Licence(LicenceMetadata licenceMetadata, String publicKeyStr, String aesSecretKeyStr) {
        if (licenceMetadata == null) {
            throw new RuntimeException("licenceMetadata cannot be null");
        }
        if (publicKeyStr == null) {
            throw new RuntimeException("publicKeyStr cannot be null");
        }
        if (aesSecretKeyStr == null) {
            throw new RuntimeException("aesSecretKeyStr cannot be null");
        }
        try {
            this.licenceMetadata = licenceMetadata;
            String licenceMetadataHexStr = licenceMetadata.toHexString();
            String licenceMetadataHashStr = licenceMetadata.sha256Hash();
            RsaAsymetricKeyCipher rsaAsymetricKeyCipher = new RsaAsymetricKeyCipher();
            rsaAsymetricKeyCipher.setPublicKeyStr(publicKeyStr);
            String encryptedHashStr = rsaAsymetricKeyCipher.rsaEncryptString(licenceMetadataHashStr);
            String licenceStr = licenceMetadataHexStr + ":" + encryptedHashStr + ":" + aesSecretKeyStr;
            StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
            this.licenceStrPlusCrc = stringCrc32Checksum.addCRC(licenceStr);
        }
        catch (Exception e) {
            throw new RuntimeException("could not instantiate new licence with supplied paramaters:", e);
        }
    }

    public Licence(String licenceStrPlusCrc, ClientKeys clientKeys) {
        this(licenceStrPlusCrc, clientKeys.getPrivateKeyEnryptedStr());
    }

    public Licence(String licenceStrPlusCrc, String privateKeyEnryptedStr) {
        try {
            if (licenceStrPlusCrc == null) {
                throw new RuntimeException("licencewithCRC cannot be null");
            }
            if (privateKeyEnryptedStr == null) {
                throw new RuntimeException("privateKeyEnryptedStr cannot be null");
            }
            this.licenceStrPlusCrc = licenceStrPlusCrc;
            StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
            String licenceStr = stringCrc32Checksum.removeCRC(licenceStrPlusCrc);
            if (licenceStr == null) {
                throw new RuntimeException("licence checksum incorrect");
            }
            String[] components = licenceStr.split(":");
            if (components.length != 3) {
                throw new RuntimeException("incorrectly formatted licence string");
            }
            String receivedLicenceMetadataHexStr = components[0];
            String receivedEncryptedHashStr = components[1];
            String receivedAesSecretKeyStr = components[2];
            this.licenceMetadata = new LicenceMetadata();
            this.licenceMetadata.fromHexString(receivedLicenceMetadataHexStr);
            String sha256Hash = this.licenceMetadata.sha256Hash();
            AesSymetricKeyCipher aesCipher = new AesSymetricKeyCipher();
            aesCipher.setEncodedSecretKeyStr(receivedAesSecretKeyStr);
            String decryptedPrivateKeyStr = aesCipher.aesDecryptStr(privateKeyEnryptedStr);
            RsaAsymetricKeyCipher rsaAsymetricKeyCipher = new RsaAsymetricKeyCipher();
            rsaAsymetricKeyCipher.setPrivateKeyStr(decryptedPrivateKeyStr);
            String decriptedHashStr = rsaAsymetricKeyCipher.rsaDecryptString(receivedEncryptedHashStr);
            if (!sha256Hash.equals(decriptedHashStr)) {
                throw new RuntimeException("Invalid licence. MetadataHash keys do not match");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could not instantiate new licence from supplied licencewithCRC parameter:", e);
        }
    }

    public static LicenceMetadata getUnverifiedMetadata(String licenceStrPlusCrc) throws Exception {
        try {
            if (licenceStrPlusCrc == null) {
                throw new RuntimeException("licencewithCRC cannot be null");
            }
            StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
            String licenceStr = stringCrc32Checksum.removeCRC(licenceStrPlusCrc);
            if (licenceStr == null) {
                throw new RuntimeException("licence checksum incorrect");
            }
            String[] components = licenceStr.split(":");
            if (components.length != 3) {
                throw new RuntimeException("incorrectly formatted licence string");
            }
            String receivedLicenceMetadataHexStr = components[0];
            LicenceMetadata licenceMetadata = new LicenceMetadata();
            licenceMetadata.fromHexString(receivedLicenceMetadataHexStr);
            return licenceMetadata;
        }
        catch (Exception e) {
            throw new RuntimeException("could not instantiate LicenceMetadata from supplied licencewithCRC parameter:", e);
        }
    }

    public static Date calculateExpiryDate(String licenceStrPlusCrc) throws Exception {
        LicenceMetadata meta = Licence.getUnverifiedMetadata(licenceStrPlusCrc);
        Date expiryDate = meta.getExpiryDate();
        Date startDate = meta.getStartDate();
        String productId = meta.getProductId();
        Integer duration = null;
        String durationStr = meta.getDuration();
        if (durationStr != null && !durationStr.trim().isEmpty()) {
            try {
                duration = Integer.parseInt(durationStr);
            }
            catch (Exception ex) {
                throw new Exception("cannot parse duration " + durationStr + " from licence for productId=" + productId, ex);
            }
        }
        if (duration != null && duration == 0) {
            return null;
        }
        if (expiryDate != null) {
            return expiryDate;
        }
        if (duration == null || startDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.add(5, duration);
        expiryDate = cal.getTime();
        return expiryDate;
    }

    public static Long daysToExpiry(String licenceStrPlusCrc, Date currentDate) throws Exception {
        Long timeToExpiry = null;
        Date expiryDate = Licence.calculateExpiryDate(licenceStrPlusCrc);
        if (expiryDate == null) {
            return null;
        }
        timeToExpiry = (expiryDate.getTime() - currentDate.getTime()) / 86400000L;
        return timeToExpiry;
    }
}

