/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceManagerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="scheduleLicencesDownload", description="Lists or sets parameters for schedulling automatic licence download and licence re-validation interval. With no options existing paramaters are listed.")
public class SetScheduleLicencesDownloadCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SetScheduleLicencesDownloadCommand.class);
    private LicenceManagerController _licenceManagerController;
    @Option(name="-e", aliases={"--enableRemoteLicenceDownload"}, description="(true or false) If true, will try to download licences from remote urls", required=false, multiValued=false)
    String enableRemoteLicenceDownloadStr;
    @Option(name="-i", aliases={"--retryInterval"}, description="(integer ms) Interval before retrying unsuccessful download of licences ", required=false, multiValued=false)
    String retryIntervalStr;
    @Option(name="-r", aliases={"--retryNumber"}, description="(integer) unsuccessful number of retrys -1 = forever until successful", required=false, multiValued=false)
    String retryNumberStr;
    @Option(name="-u", aliases={"--updateInterval"}, description="(integer ms) long term update interval before attempting to reload licence. -1= only try on startup", required=false, multiValued=false)
    String updateIntervalStr;
    @Option(name="-c", aliases={"--checkLicenceInterval"}, description="(integer ms) interval between rechecking validity of licences . -1= only try on startup", required=false, multiValued=false)
    String checkLicenceIntervalStr;
    @Option(name="-m", aliases={"--useLicenceRequestMetadata"}, description="use request metadata when requesting licences", required=false, multiValued=false)
    String useLicenceRequestMetadataStr;

    public LicenceManagerController getLicenceManagerController() {
        return this._licenceManagerController;
    }

    public void setLicenceManagerController(LicenceManagerController licenceManagerController) {
        this._licenceManagerController = licenceManagerController;
    }

    protected Object doExecute() throws Exception {
        try {
            Boolean useRemotePluginManagers = this.enableRemoteLicenceDownloadStr == null || "".equals(this.enableRemoteLicenceDownloadStr) ? null : Boolean.valueOf(Boolean.parseBoolean(this.enableRemoteLicenceDownloadStr));
            Integer retryInterval = this.retryIntervalStr == null || "".equals(this.retryIntervalStr) ? null : Integer.valueOf(Integer.parseInt(this.retryIntervalStr));
            Integer retryNumber = this.retryNumberStr == null || "".equals(this.retryNumberStr) ? null : Integer.valueOf(Integer.parseInt(this.retryNumberStr));
            Integer updateInterval = this.updateIntervalStr == null || "".equals(this.updateIntervalStr) ? null : Integer.valueOf(Integer.parseInt(this.updateIntervalStr));
            Integer checkLicenceInterval = this.checkLicenceIntervalStr == null || "".equals(this.checkLicenceIntervalStr) ? null : Integer.valueOf(Integer.parseInt(this.checkLicenceIntervalStr));
            Boolean useLicenceRequestMetadata = this.useLicenceRequestMetadataStr == null || "".equals(this.useLicenceRequestMetadataStr) ? null : Boolean.valueOf(Boolean.parseBoolean(this.useLicenceRequestMetadataStr));
            String schedule = this.getLicenceManagerController().updateSchedule(useRemotePluginManagers, retryInterval, retryNumber, updateInterval, checkLicenceInterval, useLicenceRequestMetadata);
            String msg = "licences schedule command result: " + schedule;
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("error updating licences schedule. Exception=" + e);
            LOG.error("error updating licences schedule. Exception=", (Throwable)e);
        }
        return null;
    }
}

