/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceManagerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="setRemoteLicenceServers", description="sets the remote licence server urls, username and password.")
public class SetRemoteLicenceServersCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SetRemoteLicenceServersCommand.class);
    private LicenceManagerController _licenceManagerController;
    @Option(name="-u", aliases={"--urlList"}, description="comma separated list of licence manger urls to ask for licences", required=false, multiValued=false)
    String urlList = null;
    @Option(name="-n", aliases={"--remoteUsername"}, description="Remote Username to download licence", required=false, multiValued=false)
    String remoteUsername = null;
    @Option(name="-p", aliases={"--remotePassword"}, description="Remote Password to download licence", required=false, multiValued=false)
    String remotePassword = null;

    public LicenceManagerController getLicenceManagerController() {
        return this._licenceManagerController;
    }

    public void setLicenceManagerController(LicenceManagerController licenceManagerController) {
        this._licenceManagerController = licenceManagerController;
    }

    protected Object doExecute() throws Exception {
        try {
            this.getLicenceManagerController().updateRemoteLicenceManagersUrls(this.urlList, this.remoteUsername, this.remotePassword);
            String msg = "set remote plugin servers urls=" + this.urlList;
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("error setting remote licence servers. Exception=" + e);
            LOG.error("error setting remote licence servers. Exception=", (Throwable)e);
        }
        return null;
    }
}

