/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceManagerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="persistConfiguration", description="Persists current plugin manager configuration to be used on start up.")
public class PersistCfgConfigurationCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PersistCfgConfigurationCommand.class);
    private LicenceManagerController _licenceManagerController;

    public LicenceManagerController getLicenceManagerController() {
        return this._licenceManagerController;
    }

    public void setLicenceManagerController(LicenceManagerController licenceManagerController) {
        this._licenceManagerController = licenceManagerController;
    }

    protected Object doExecute() throws Exception {
        try {
            String result = this.getLicenceManagerController().persistConfiguration();
            String msg = "persisted configuration:" + result;
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("error persisting configuration. Exception=" + e);
            LOG.error("error persisting configuration. Exception=", (Throwable)e);
        }
        return null;
    }
}

