/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="listforsystemid", description="Lists installed licences which will authenticate for a given systemId")
public class ListLicencesForSystemIdCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ListLicencesForSystemIdCommand.class);
    private LicenceService _licenceService;
    @Argument(index=0, name="systemId", description="systemId for which to find licences", required=true, multiValued=false)
    String systemId = null;

    public LicenceService getLicenceService() {
        return this._licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this._licenceService = licenceService;
    }

    protected Object doExecute() throws Exception {
        try {
            System.out.println("List of licences which will authenticate systemId='" + this.systemId + "'");
            LOG.info("List of licences which will authenticate systemId='" + this.systemId + "'");
            Map<String, String> licenceMap = this.getLicenceService().getLicenceMapForSystemId(this.systemId);
            for (Map.Entry<String, String> entry : licenceMap.entrySet()) {
                System.out.println("   productId='" + entry.getKey() + "' licence='" + entry.getValue() + "'");
                LOG.info("   productId='" + entry.getKey() + "' licence='" + entry.getValue() + "'");
            }
        }
        catch (Exception e) {
            System.err.println("Error getting list of installed licences. Exception=" + e);
            LOG.error("Error getting list of installed licences. Exception=", (Throwable)e);
        }
        return null;
    }
}

