/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceManagerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="installLicenceFromUrl", description="Installs a new plugin licence from a licence manager at a given url.")
public class InstallNewLicenceFromUrlCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(InstallNewLicenceFromUrlCommand.class);
    private LicenceManagerController _licenceManagerController;
    @Option(name="-i", aliases={"--systemId"}, description="systemId for which to request licence. Will use default config if not set", required=false, multiValued=false)
    String systemIdStr = null;
    @Option(name="-m", aliases={"--useRequestMetadata"}, description="use request metadata.", required=false, multiValued=false)
    String useRequestMetadata = null;
    @Option(name="-u", aliases={"--url"}, description="url to download licence", required=true, multiValued=false)
    String urlStr = null;
    @Option(name="-n", aliases={"--remoteUsername"}, description="Remote Username to download licence (Optional. If not provided will use default config)", required=true, multiValued=false)
    String remoteUserName = null;
    @Option(name="-p", aliases={"--remotePassword"}, description="Remote Password to download licence (Optional. If not provided will use default config)", required=true, multiValued=false)
    String remotePassword = null;

    public LicenceManagerController getLicenceManagerController() {
        return this._licenceManagerController;
    }

    public void setLicenceManagerController(LicenceManagerController licenceManagerController) {
        this._licenceManagerController = licenceManagerController;
    }

    protected Object doExecute() throws Exception {
        try {
            String msg = "Trying to install licence from url=" + this.urlStr + ", remoteUserName=" + this.remoteUserName + ", systemId=" + this.systemIdStr;
            LOG.info(msg);
            System.out.println(msg);
            this.getLicenceManagerController().installRemoteLicencesFromSystemId(this.systemIdStr, this.urlStr, this.remoteUserName, this.remotePassword);
            msg = msg + "\nSuccess.";
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("Error installing new licence from url=" + this.urlStr + ", systemIdStr=" + this.systemIdStr + " Exception=" + e);
            LOG.error("Error installing new licence from url=" + this.urlStr + ", systemIdStr=" + this.systemIdStr, (Throwable)e);
        }
        return null;
    }
}

