/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTimer {
    private static final Logger LOG = LoggerFactory.getLogger(TaskTimer.class);
    private AtomicBoolean scheduleIsRunning = new AtomicBoolean(false);
    private ScheduledTask task = null;
    private Thread m_schedule = null;
    private Integer retryInterval = 0;
    private Integer retryNumber = 0;
    private Integer updateInterval = -1;

    public ScheduledTask getTask() {
        return this.task;
    }

    public void setTask(ScheduledTask task) {
        this.task = task;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Integer getRetryNumber() {
        return this.retryNumber;
    }

    public void setRetryNumber(Integer retryNumber) {
        this.retryNumber = retryNumber;
    }

    public Integer getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(Integer updateInterval) {
        this.updateInterval = updateInterval;
    }

    public synchronized void startSchedule() {
        if (this.m_schedule == null) {
            if (this.retryInterval == null) {
                throw new RuntimeException("retryInterval cannot be null");
            }
            if (this.retryNumber == null) {
                throw new RuntimeException("retryNumber cannot be null");
            }
            if (this.updateInterval == null) {
                throw new RuntimeException("updateInterval cannot be null");
            }
            this.m_schedule = new Thread(new TaskRunner(this.retryInterval, this.retryNumber, this.updateInterval, this.task));
            this.m_schedule.start();
            this.scheduleIsRunning.set(true);
            LOG.info("task schedule started: retryInterval=" + this.retryInterval + ", retryNumber=" + this.retryNumber + ", updateInterval=" + this.updateInterval);
        }
    }

    public synchronized void stopSchedule() {
        if (this.m_schedule != null) {
            this.m_schedule.interrupt();
            this.m_schedule = null;
            LOG.info("task schedule stopped");
        }
    }

    public boolean getScheduleIsRunning() {
        return this.scheduleIsRunning.get();
    }

    private class TaskRunner
    implements Runnable {
        private int retryInterval = 0;
        private int retryNumber = 0;
        private int updateInterval = 0;
        private ScheduledTask task = null;

        public TaskRunner(int retryInterval, int retryNumber, int updateInterval, ScheduledTask task) {
            if (task == null) {
                throw new RuntimeException("ScheduledTask task cannot be null");
            }
            this.retryInterval = retryInterval;
            this.retryNumber = retryNumber;
            this.updateInterval = updateInterval;
            this.task = task;
        }

        @Override
        public void run() {
            try {
                int retrys = 0;
                int sleeptime = 0;
                while (!Thread.currentThread().isInterrupted()) {
                    LOG.debug("trying to run task");
                    boolean success = false;
                    try {
                        success = this.task.runScheduledTask();
                    }
                    catch (Exception e) {
                        LOG.error("exception thrown when running scheduled task. Cancelling schedule", (Throwable)e);
                        throw new InterruptedException();
                    }
                    if (!success && this.retryNumber < 0) {
                        sleeptime = this.retryInterval;
                        LOG.debug("retryNumber set to " + this.retryNumber + " (continuous retrys until success) sleeping for retryInterval=" + sleeptime);
                    } else if (!success && retrys < this.retryNumber) {
                        sleeptime = this.retryInterval;
                        LOG.debug("failed retry " + retrys + " sleeping for retryInterval=" + sleeptime);
                        ++retrys;
                    } else {
                        if (this.updateInterval < 0) {
                            LOG.debug("updateInterval=" + this.updateInterval + " only running task once at startup");
                            throw new InterruptedException();
                        }
                        sleeptime = this.updateInterval;
                        retrys = 0;
                        LOG.debug("sleeping for updateInterval=" + sleeptime);
                    }
                    Thread.sleep(sleeptime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOG.debug("schedule interrupted");
            TaskTimer.this.scheduleIsRunning.set(false);
        }
    }

    public static interface ScheduledTask {
        public boolean runScheduledTask();
    }
}

