/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;

public class StringCrc32Checksum {
    public String addCRC(String valueString) {
        CRC32 crc = new CRC32();
        try {
            crc.update(valueString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported", e);
        }
        String hexcrc = Long.toHexString(crc.getValue());
        String stringPlusCrc = valueString + "-" + hexcrc;
        return stringPlusCrc;
    }

    public boolean checkCRC(String stringPlusCrc) {
        int lastdashindex = stringPlusCrc.lastIndexOf("-");
        if (lastdashindex == -1 || lastdashindex == 0 || lastdashindex == stringPlusCrc.length()) {
            return false;
        }
        String valueString = stringPlusCrc.substring(0, lastdashindex);
        String hexcrc = stringPlusCrc.substring(lastdashindex + 1);
        CRC32 crc = new CRC32();
        try {
            crc.update(valueString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported", e);
        }
        String checkHexCrc = Long.toHexString(crc.getValue());
        return checkHexCrc.equals(hexcrc);
    }

    public String removeCRC(String stringPlusCrc) {
        if (!this.checkCRC(stringPlusCrc)) {
            return null;
        }
        int lastdashindex = stringPlusCrc.lastIndexOf("-");
        return stringPlusCrc.substring(0, lastdashindex);
    }
}

