/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;
import org.opennms.karaf.licencemgr.StringCrc32Checksum;

public class RsaAsymetricKeyCipher {
    private static final int KEY_SIZE = 2048;
    private String publicKeyStr = null;
    private String privateKeyStr = null;

    public String getPublicKeyStr() {
        return this.publicKeyStr;
    }

    public void setPublicKeyStr(String publicKeyStr) {
        this.publicKeyStr = publicKeyStr;
    }

    public String getPrivateKeyStr() {
        return this.privateKeyStr;
    }

    public void setPrivateKeyStr(String privateKeyStr) {
        this.privateKeyStr = privateKeyStr;
    }

    public void generateKeys() {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            PublicKey publicKey = kp.getPublic();
            PrivateKey privateKey = kp.getPrivate();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rsaPublicKeySpec = keyFactory.getKeySpec(publicKey, RSAPublicKeySpec.class);
            RSAPrivateKeySpec rsaPrivateKeySpec = keyFactory.getKeySpec(privateKey, RSAPrivateKeySpec.class);
            BigInteger pubKeyMod = rsaPublicKeySpec.getModulus();
            BigInteger pubKeyExp = rsaPublicKeySpec.getPublicExponent();
            this.publicKeyStr = pubKeyMod.toString(16) + "-" + pubKeyExp.toString(16);
            BigInteger privateKeyMod = rsaPrivateKeySpec.getModulus();
            BigInteger privateKeyExp = rsaPrivateKeySpec.getPrivateExponent();
            this.privateKeyStr = privateKeyMod.toString(16) + "-" + privateKeyExp.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("problem generating keys", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("problem generating keys", e);
        }
    }

    private PrivateKey readPrivateKeyFromString(String privateKeyStr) {
        try {
            String[] parts = privateKeyStr.split("-");
            if (parts.length != 2) {
                throw new RuntimeException("incorrectly formatted keystring");
            }
            String privateKeyModStr = parts[0];
            String privateKeyExpStr = parts[1];
            BigInteger modulus = new BigInteger(privateKeyModStr, 16);
            BigInteger exponent = new BigInteger(privateKeyExpStr, 16);
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(modulus, exponent);
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = rsaKeyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new RuntimeException("Spurious serialisation error", e);
        }
    }

    private PublicKey readPublicKeyFromString(String publicKeyStr) {
        try {
            String[] parts = publicKeyStr.split("-");
            if (parts.length != 2) {
                throw new RuntimeException("incorrectly formatted keystring");
            }
            String publicKeyModStr = parts[0];
            String publicKeyExpStr = parts[1];
            BigInteger modulus = new BigInteger(publicKeyModStr, 16);
            BigInteger exponent = new BigInteger(publicKeyExpStr, 16);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PublicKey pubKey = fact.generatePublic(keySpec);
            return pubKey;
        }
        catch (Exception e) {
            throw new RuntimeException("Spurious serialisation error", e);
        }
    }

    public String rsaEncryptStringAddChecksum(String sourceStr) {
        String encryptedStr = this.rsaEncryptString(sourceStr);
        StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
        return stringCrc32Checksum.addCRC(encryptedStr);
    }

    public String rsaEncryptString(String sourceStr) {
        byte[] src;
        try {
            src = sourceStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported");
        }
        byte[] encrypted = this.rsaEncrypt(src);
        return DatatypeConverter.printHexBinary((byte[])encrypted);
    }

    public byte[] rsaEncrypt(byte[] src) {
        byte[] cipherData = null;
        try {
            PublicKey pubKey = this.readPublicKeyFromString(this.publicKeyStr);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            cipherData = cipher.doFinal(src);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("problem encrypting data", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("problem encrypting data", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("problem encrypting data", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("problem encrypting data", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("problem encrypting data", e);
        }
        return cipherData;
    }

    public String rsaDecryptStringRemoveChecksum(String encryptedStrAndCRC) {
        StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
        String encryptedStr = stringCrc32Checksum.removeCRC(encryptedStrAndCRC);
        if (encryptedStr == null) {
            return null;
        }
        return this.rsaDecryptString(encryptedStr);
    }

    public String rsaDecryptString(String encryptedStr) {
        String decriptedStr = null;
        try {
            byte[] encrypted = DatatypeConverter.parseHexBinary((String)encryptedStr);
            byte[] decrypt = this.rsaDecrypt(encrypted);
            decriptedStr = new String(decrypt, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported", e);
        }
        return decriptedStr;
    }

    public byte[] rsaDecrypt(byte[] cipherData) {
        byte[] deCipherData = null;
        try {
            PrivateKey privateKey = this.readPrivateKeyFromString(this.privateKeyStr);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            deCipherData = cipher.doFinal(cipherData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("problem decrypting data", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("problem decrypting data", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("problem decrypting data", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("problem decrypting data", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("problem decrypting data", e);
        }
        return deCipherData;
    }
}

