/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.TaskTimer;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadataList;
import org.opennms.karaf.licencemgr.rest.client.jerseyimpl.LicenceManagerClientRestJerseyImpl;
import org.opennms.karaf.licencemgr.rest.client.jerseyimpl.LicencePublisherClientRestJerseyImpl;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenceManagerController {
    private static final Logger LOG = LoggerFactory.getLogger(LicenceManagerController.class);
    public static final String PERSISTANT_ID = "org.opennms.features.licencemgr.config";
    public static final String USE_REMOTE_LICENCE_MANAGERS_KEY = "org.opennms.karaf.licencemanager.use-remote-licence-managers";
    public static final String REMOTE_LICENCE_MANAGERS_URLS_KEY = "org.opennms.karaf.licencemanager.remote-licence-managers-urls";
    public static final String REMOTE_LICENCE_MANAGERS_USERNAME_KEY = "org.opennms.karaf.licencemanager.remote-licence-managers-username";
    public static final String REMOTE_LICENCE_MANAGERS_PASSWORD_KEY = "org.opennms.karaf.licencemanager.remote-licence-managers-password";
    public static final String RETRY_INTERVAL_KEY = "org.opennms.karaf.licencemanager.retryInterval";
    public static final String RETRY_NUMBER_KEY = "org.opennms.karaf.licencemanager.retryNumber";
    public static final String UPDATE_INTERVAL_KEY = "org.opennms.karaf.licencemanager.updateInterval";
    public static final String CHECK_LICENCE_INTERVAL_KEY = "org.opennms.karaf.licencemanager.checkLicenceInterval";
    public static final String USE_LICENCE_REQUEST_METADATA_KEY = "org.opennms.karaf.licencemanager.useLicenceRequestMetadata";
    private Integer m_retryInterval = null;
    private Integer m_retryNumber = null;
    private Integer m_updateInterval = null;
    private Integer m_checkLicenceInterval = null;
    private boolean m_useLicenceRequestMetadata = false;
    private String m_licenceRequestMetadataFile = null;
    private TaskTimer m_timer = new TaskTimer();
    private LicenceService m_licenceService = null;
    private Boolean m_useRemoteLicenceManagers = false;
    private Set<String> m_remoteLicenceMgrs = new LinkedHashSet<String>();
    private String m_remoteLicenceManagerUserName;
    private String m_remoteLicenceManagerPassword;
    private ConfigurationAdmin m_configurationAdmin = null;

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.m_configurationAdmin = configurationAdmin;
    }

    public LicenceService getLicenceService() {
        return this.m_licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this.m_licenceService = licenceService;
    }

    public void setRemoteLicenceManagerUserName(String remoteLicenceManagerUserName) {
        this.m_remoteLicenceManagerUserName = remoteLicenceManagerUserName;
    }

    public void setRemoteLicenceManagerPassword(String remoteLicenceManagerPassword) {
        this.m_remoteLicenceManagerPassword = remoteLicenceManagerPassword;
    }

    public synchronized void setUseRemoteLicenceManagers(String useRemoteLicenceManagersStr) {
        if (useRemoteLicenceManagersStr == null || !useRemoteLicenceManagersStr.equals("true") && !useRemoteLicenceManagersStr.equals("false")) {
            throw new RuntimeException("m_useRemoteLicenceManagers set to (" + useRemoteLicenceManagersStr + ") but must be set to boolean true or false");
        }
        this.m_useRemoteLicenceManagers = Boolean.valueOf(useRemoteLicenceManagersStr);
    }

    public synchronized void setRemoteLicenceManagersUrls(String urlList) {
        if (urlList == null) {
            throw new RuntimeException("urlList should not be set to null.");
        }
        if (!"".equals(urlList)) {
            String[] urls = urlList.split(",");
            LinkedHashSet<String> licenceMgrs = new LinkedHashSet<String>();
            for (String urlstr : urls) {
                urlstr.trim();
                if ("".equals(urlstr)) continue;
                try {
                    URL url = new URL(urlstr);
                    URI uri = url.toURI();
                    licenceMgrs.add(urlstr);
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new RuntimeException("unparsable URL in remote Licence Managers configuration ", e);
                }
            }
            this.m_remoteLicenceMgrs = licenceMgrs;
            String msg = "Remote licence managers set to:";
            for (String lmUrl : this.m_remoteLicenceMgrs) {
                msg = msg + "'" + lmUrl + "' ";
            }
            LOG.info(msg);
        }
    }

    public synchronized void updateRemoteLicenceManagersUrls(String urlList, String remoteUsername, String remotePassword) {
        this.setRemoteLicenceManagersUrls(urlList);
        this.setRemoteLicenceManagerPassword(remotePassword);
        this.setRemoteLicenceManagerUserName(remoteUsername);
        String msg = "Licence manager remoteUsername set to:" + remoteUsername + " remotePassword(obfuscated):";
        String msg2 = remotePassword == null || "".equals(remotePassword) ? remotePassword : "xxxxxx";
        LOG.info(msg + msg2);
        System.out.println(msg);
    }

    public void setRetryInterval(Integer retryInterval) {
        this.m_retryInterval = retryInterval;
    }

    public void setRetryNumber(Integer retryNumber) {
        this.m_retryNumber = retryNumber;
    }

    public void setUpdateInterval(Integer updateInterval) {
        this.m_updateInterval = updateInterval;
    }

    public void setCheckLicenceInterval(Integer checkLicenceInterval) {
        this.m_checkLicenceInterval = checkLicenceInterval;
    }

    public void setUseLicenceRequestMetadata(String useLicenceRequestMetadataStr) {
        if (useLicenceRequestMetadataStr == null || !useLicenceRequestMetadataStr.equals("true") && !useLicenceRequestMetadataStr.equals("false")) {
            throw new RuntimeException("useLicenceRequestMetadataStr set to (" + useLicenceRequestMetadataStr + ") but must be set to boolean true or false");
        }
        this.m_useLicenceRequestMetadata = Boolean.valueOf(useLicenceRequestMetadataStr);
    }

    public void setLicenceRequestMetadataFile(String licenceRequestMetadataFile) {
        this.m_licenceRequestMetadataFile = licenceRequestMetadataFile;
    }

    public synchronized String installRemoteLicencesFromUrlList(String systemIdStr) {
        String successRemoteLicenceManagerUrl = null;
        for (String remoteLicenceManagerUrl : this.m_remoteLicenceMgrs) {
            try {
                successRemoteLicenceManagerUrl = this.installRemoteLicencesFromSystemId(remoteLicenceManagerUrl, systemIdStr, this.m_remoteLicenceManagerUserName, this.m_remoteLicenceManagerPassword);
            }
            catch (Exception e) {
                System.err.println("   Licence Manager could not load licences from from licence manager at " + remoteLicenceManagerUrl + " for systemIdStr='" + systemIdStr + "' Exception:" + e);
                LOG.error("   Licence Manager could not load licences from from licence manager at " + remoteLicenceManagerUrl + " for systemIdStr='" + systemIdStr + "' Exception:", (Throwable)e);
            }
            if (null == successRemoteLicenceManagerUrl) continue;
            System.out.println("Licence Manager succeeded in loading licences from licence manager at " + successRemoteLicenceManagerUrl);
            LOG.info("Licence Manager succeeded in loading licences from licence manager at " + successRemoteLicenceManagerUrl);
            break;
        }
        if (null == successRemoteLicenceManagerUrl) {
            System.err.println("Licence Manager Could not load licences from any remote licence manager.");
            LOG.error("Licence Manager Could not load licences from any remote licence manager.");
        }
        return successRemoteLicenceManagerUrl;
    }

    public synchronized String installRemoteLicencesFromSystemId(String remoteLicenceManagerUrl, String systemIdStr, String remoteLicenceManagerUserName, String remoteLicenceManagerPassword) {
        if (this.m_licenceService == null) {
            throw new RuntimeException("m_licenceService must not be null");
        }
        if (remoteLicenceManagerUrl == null) {
            throw new RuntimeException("Licence Manager remoteLicenceManagerUrl must not be null");
        }
        if (systemIdStr == null) {
            throw new RuntimeException("Licence Manager systemIdStr must not be null");
        }
        String remoteUserName = remoteLicenceManagerUserName != null ? remoteLicenceManagerUserName : this.m_remoteLicenceManagerUserName;
        String remotePassword = remoteLicenceManagerPassword != null ? remoteLicenceManagerPassword : this.m_remoteLicenceManagerPassword;
        try {
            LicenceManagerClientRestJerseyImpl licenceManagerClient = new LicenceManagerClientRestJerseyImpl();
            String basePath = "/licencemgr/rest/v1-0/licence-mgr";
            licenceManagerClient.setBasePath(basePath);
            licenceManagerClient.setBaseUrl(remoteLicenceManagerUrl);
            licenceManagerClient.setUserName(remoteUserName);
            licenceManagerClient.setPassword(remotePassword);
            LicenceList licenceList = licenceManagerClient.getLicenceMapForSystemId(systemIdStr);
            this.m_licenceService.installLicenceList(licenceList);
            return remoteLicenceManagerUrl;
        }
        catch (Exception e) {
            throw new RuntimeException("    Licence Manager Cannot get remote licences from remoteLicenceManagerUrl=" + remoteLicenceManagerUrl, e);
        }
    }

    public synchronized String installRemoteLicencesFromLicenceMetadata(String remoteLicenceManagerUrl, LicenceMetadataList licenceMetadataList, String remoteLicenceManagerUserName, String remoteLicenceManagerPassword) {
        if (this.m_licenceService == null) {
            throw new RuntimeException("m_licenceService must not be null");
        }
        if (remoteLicenceManagerUrl == null) {
            throw new RuntimeException("Licence Manager remoteLicenceManagerUrl must not be null");
        }
        if (licenceMetadataList == null) {
            throw new RuntimeException("Licence Manager licenceMetadataList must not be null");
        }
        String remoteUserName = remoteLicenceManagerUserName != null ? remoteLicenceManagerUserName : this.m_remoteLicenceManagerUserName;
        String remotePassword = remoteLicenceManagerPassword != null ? remoteLicenceManagerPassword : this.m_remoteLicenceManagerPassword;
        try {
            LicencePublisherClientRestJerseyImpl licencePublisherClient = new LicencePublisherClientRestJerseyImpl();
            String basePath = "/licencemgr/rest/v1-0/licence-pub";
            licencePublisherClient.setBasePath(basePath);
            licencePublisherClient.setBaseUrl(remoteLicenceManagerUrl);
            licencePublisherClient.setUserName(remoteUserName);
            licencePublisherClient.setPassword(remotePassword);
            LicenceList licenceList = licencePublisherClient.createMultiLicenceInstance(licenceMetadataList);
            this.m_licenceService.installLicenceList(licenceList);
            return remoteLicenceManagerUrl;
        }
        catch (Exception e) {
            throw new RuntimeException("    Licence Manager Cannot get remote licences from remoteLicenceManagerUrl=" + remoteLicenceManagerUrl, e);
        }
    }

    public synchronized String installRemoteLicencesUsingMetadataFromUrlList(String systemIdStr) {
        LicenceMetadataList licenceMetadataList;
        try {
            licenceMetadataList = this.loadLicenceMetadataListFile();
            for (LicenceMetadata licenceMetadata : licenceMetadataList.getLicenceMetadataList()) {
                licenceMetadata.getSystemIds().add(systemIdStr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("problem loading licenceMetadataListFile", e);
        }
        String successRemoteLicenceManagerUrl = null;
        for (String remoteLicenceManagerUrl : this.m_remoteLicenceMgrs) {
            try {
                successRemoteLicenceManagerUrl = this.installRemoteLicencesFromLicenceMetadata(remoteLicenceManagerUrl, licenceMetadataList, this.m_remoteLicenceManagerUserName, this.m_remoteLicenceManagerPassword);
            }
            catch (Exception e) {
                System.err.println("   Licence Manager could not load licences from from licence manager at " + remoteLicenceManagerUrl + " for systemIdStr='" + systemIdStr + "' Exception:" + e);
                LOG.error("   Licence Manager could not load licences from from licence manager at " + remoteLicenceManagerUrl + " for systemIdStr='" + systemIdStr + "' Exception:", (Throwable)e);
            }
            if (null == successRemoteLicenceManagerUrl) continue;
            System.out.println("Licence Manager succeeded in loading licences from licence manager at " + successRemoteLicenceManagerUrl);
            LOG.info("Licence Manager succeeded in loading licences from licence manager at " + successRemoteLicenceManagerUrl);
            break;
        }
        if (null == successRemoteLicenceManagerUrl) {
            System.err.println("Licence Manager Could not load licences from any remote licence manager.");
            LOG.error("Licence Manager Could not load licences from any remote licence manager.");
        }
        return successRemoteLicenceManagerUrl;
    }

    public synchronized void close() {
        System.out.println("Licence Manager Shutting Down ");
        LOG.info("Licence Manager Shutting Down ");
    }

    public synchronized void init() {
        System.out.println("Licence Manager Starting");
        LOG.info("Licence Manager Starting");
        if (this.m_useRemoteLicenceManagers != null && this.m_useRemoteLicenceManagers.booleanValue()) {
            System.out.println("Licence Manager system schedulling load of remote licences");
            try {
                this.restartSchedule();
            }
            catch (Exception ex) {
                LOG.error("PluginFeatureManager problem starting licence download schedule", (Throwable)ex);
            }
        } else {
            System.out.println("Licence Manager system set to not load remote licences");
            LOG.info("Licence Manager system set to not load remote licences");
        }
        System.out.println("Licence Manager Started");
        LOG.info("Licence Manager Started");
    }

    public synchronized void restartSchedule() {
        if (this.m_retryInterval == null) {
            throw new RuntimeException("retryInterval cannot be null when starting schedule");
        }
        if (this.m_retryNumber == null) {
            throw new RuntimeException("retryNumber cannot be null when starting schedule");
        }
        if (this.m_updateInterval == null) {
            throw new RuntimeException("updateInterval cannot be null when starting schedule");
        }
        this.m_timer.stopSchedule();
        if (this.m_useRemoteLicenceManagers.booleanValue()) {
            this.m_timer.setRetryInterval(this.m_retryInterval);
            this.m_timer.setRetryNumber(this.m_retryNumber);
            this.m_timer.setUpdateInterval(this.m_updateInterval);
            LicenceManagerController licenceManagerController = this;
            ScheduledLicenceUpdate task = new ScheduledLicenceUpdate(licenceManagerController);
            this.m_timer.setTask(task);
            this.m_timer.startSchedule();
        }
    }

    public synchronized void stopSchedule() {
        if (this.m_timer != null) {
            this.m_timer.stopSchedule();
        }
    }

    public synchronized String updateSchedule(Boolean useRemoteLicenceManagers, Integer retryInterval, Integer retryNumber, Integer updateInterval, Integer checkLicenceInterval, Boolean useLicenceRequestMetadata) {
        boolean justlist = true;
        String msg = "";
        if (retryInterval != null) {
            justlist = false;
            this.m_retryInterval = retryInterval;
        }
        if (retryNumber != null) {
            justlist = false;
            this.m_retryNumber = retryNumber;
        }
        if (updateInterval != null) {
            justlist = false;
            this.m_updateInterval = updateInterval;
        }
        if (useRemoteLicenceManagers != null) {
            justlist = false;
            this.m_useRemoteLicenceManagers = useRemoteLicenceManagers;
        }
        if (checkLicenceInterval != null) {
            justlist = false;
            this.m_checkLicenceInterval = checkLicenceInterval;
        }
        if (useLicenceRequestMetadata != null) {
            justlist = false;
            this.m_useLicenceRequestMetadata = useLicenceRequestMetadata;
        }
        if (!justlist) {
            msg = "Restarting schedule with new configuration.\n";
            this.restartSchedule();
        }
        msg = this.m_timer.getScheduleIsRunning() ? msg + "Schedule Running\n" : msg + "Schedule Stopped\n";
        msg = msg + "Schedule configuration = useRemoteLicenceManagers=" + this.m_useRemoteLicenceManagers + ", useLicenceRequestMetadata=" + this.m_useLicenceRequestMetadata + ", retryInterval=" + this.m_retryInterval + ", retryNumber=" + this.m_retryNumber + ", updateInterval=" + this.m_updateInterval;
        return msg;
    }

    public synchronized String persistConfiguration() {
        if (this.m_configurationAdmin == null) {
            throw new RuntimeException("m_configurationAdmin cannot be null");
        }
        try {
            Configuration config = this.m_configurationAdmin.getConfiguration(PERSISTANT_ID);
            Hashtable<String, String> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, String>();
            }
            ((Dictionary)props).put(USE_REMOTE_LICENCE_MANAGERS_KEY, Boolean.toString(this.m_useRemoteLicenceManagers));
            ((Dictionary)props).put(REMOTE_LICENCE_MANAGERS_URLS_KEY, this.listToStringCsvProperty(this.m_remoteLicenceMgrs));
            ((Dictionary)props).put(REMOTE_LICENCE_MANAGERS_USERNAME_KEY, this.m_remoteLicenceManagerUserName == null ? "" : this.m_remoteLicenceManagerUserName);
            ((Dictionary)props).put(REMOTE_LICENCE_MANAGERS_PASSWORD_KEY, this.m_remoteLicenceManagerPassword == null ? "" : this.m_remoteLicenceManagerPassword);
            ((Dictionary)props).put(RETRY_INTERVAL_KEY, Integer.toString(this.m_retryInterval));
            ((Dictionary)props).put(RETRY_NUMBER_KEY, Integer.toString(this.m_retryNumber));
            ((Dictionary)props).put(UPDATE_INTERVAL_KEY, Integer.toString(this.m_updateInterval));
            ((Dictionary)props).put(CHECK_LICENCE_INTERVAL_KEY, Integer.toString(this.m_checkLicenceInterval));
            ((Dictionary)props).put(USE_LICENCE_REQUEST_METADATA_KEY, Boolean.toString(this.m_useLicenceRequestMetadata));
            StringBuffer msg = new StringBuffer("Persisted configuration:\n");
            Enumeration e = ((Dictionary)props).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)((Dictionary)props).get(key);
                msg.append("    " + key + "=" + value + "\n");
            }
            config.update(props);
            LOG.info(msg.toString());
            return msg.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("problem updating configuration in org.opennms.features.licencemgr.config.cfg", e);
        }
    }

    private Set<String> stringCsvPropertyToList(String setStringStr) {
        LinkedHashSet<String> setString = new LinkedHashSet<String>();
        if (setStringStr != null & !"".equals(setStringStr)) {
            String[] stringArray;
            for (String str : stringArray = setStringStr.split(",")) {
                str.trim();
                if ("".equals(str)) continue;
                setString.add(str);
            }
        }
        return setString;
    }

    private String listToStringCsvProperty(Set<String> setString) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> itr = setString.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            if (!itr.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public synchronized LicenceMetadataList loadLicenceMetadataListFile() {
        if (this.m_licenceRequestMetadataFile == null) {
            throw new RuntimeException("fileUri must be set for readLicenceMetadataFile");
        }
        LicenceMetadataList licenceMetadata = null;
        try {
            File licenceMetadataFile = new File(this.m_licenceRequestMetadataFile);
            LOG.debug("reading licenceMetadataFile:" + licenceMetadataFile.getAbsolutePath());
            if (licenceMetadataFile.exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LicenceMetadataList.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                licenceMetadata = (LicenceMetadataList)jaxbUnmarshaller.unmarshal(licenceMetadataFile);
                System.out.println("Licence Manager successfully loaded request licence metadata from file=" + licenceMetadataFile.getAbsolutePath());
                LOG.info("Licence Manager successfully loaded request licence metadata from file=" + licenceMetadataFile.getAbsolutePath());
            } else {
                System.out.println("Licence Manager licence file=" + licenceMetadataFile.getAbsolutePath() + " does not exist.");
                LOG.info("Licence Manager licence file=" + licenceMetadataFile.getAbsolutePath() + " does not exist.");
            }
            return licenceMetadata;
        }
        catch (JAXBException e) {
            LOG.error("Licence Manager Problem loading licence metadata: " + e.getMessage());
            throw new RuntimeException("Problem loading licence metadata", e);
        }
    }

    public synchronized void saveLicenceMetadataListFile(LicenceMetadataList licenceMetadataList) {
        if (this.m_licenceRequestMetadataFile == null) {
            throw new RuntimeException("m_licenceRequestMetadataFile must be set ");
        }
        if (licenceMetadataList == null) {
            throw new RuntimeException("licenceMetadataList must be set");
        }
        try {
            File licenceMetadataFile = new File(this.m_licenceRequestMetadataFile);
            LOG.debug("writing licenceMetadataFile:" + licenceMetadataFile.getAbsolutePath());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LicenceMetadataList.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)licenceMetadataList, licenceMetadataFile);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Problem persisting Licence Metadata Data", e);
        }
    }

    private class ScheduledLicenceUpdate
    implements TaskTimer.ScheduledTask {
        private LicenceManagerController s_licenceManagerController;
        private AtomicInteger s_count = new AtomicInteger(0);
        private boolean s_useLicenceRequestMetadata = false;
        private String s_systemId;

        ScheduledLicenceUpdate(LicenceManagerController licenceManagerController2) {
            this.s_licenceManagerController = Objects.requireNonNull(licenceManagerController2);
            this.s_useLicenceRequestMetadata = licenceManagerController2.m_useLicenceRequestMetadata;
            this.s_systemId = licenceManagerController2.m_licenceService.getSystemId();
        }

        @Override
        public boolean runScheduledTask() {
            int c = this.s_count.incrementAndGet();
            boolean success = false;
            LOG.info("Running scheduled licence update. Times this schedule has run: " + c);
            try {
                if (this.s_useLicenceRequestMetadata) {
                    LOG.info("trying to installed remote licences using metadata and systemId");
                    String installedUrl = this.s_licenceManagerController.installRemoteLicencesUsingMetadataFromUrlList(this.s_systemId);
                    if (installedUrl != null) {
                        success = true;
                        LOG.info("installed remote licences using metadata for systemId=" + this.s_systemId + "from url=" + installedUrl);
                    }
                } else {
                    LOG.info("trying to installed remote licences using systemId");
                    String installedUrl = this.s_licenceManagerController.installRemoteLicencesFromUrlList(this.s_systemId);
                    if (installedUrl != null) {
                        success = true;
                        LOG.info("installed remote licences for systemId=" + this.s_systemId + "from url=" + installedUrl);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("problem running schedule updating licence from plugin managers", (Throwable)e);
            }
            return success;
        }
    }
}

