/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.metadata.Licence;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;

@Command(scope="licence-mgr", name="addlicence", description="adds licence for productId")
public class AddLicenceCommand
extends OsgiCommandSupport {
    private LicenceService _licenceService;
    @Argument(index=0, name="licence", description="encoded licence string including productId", required=true, multiValued=false)
    String licence = null;

    public LicenceService getLicenceService() {
        return this._licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this._licenceService = licenceService;
    }

    protected Object doExecute() throws Exception {
        try {
            String productId = Licence.getUnverifiedMetadata(this.licence).getProductId();
            LicenceMetadata licenceMetadata = this.getLicenceService().addLicence(this.licence);
            String metadatastr = licenceMetadata == null ? "null" : licenceMetadata.toXml();
            System.out.println("Added licence ProductId='" + productId + "'");
            System.out.println("              licence=  '" + this.licence + "'");
            System.out.println("              licenceMetadata='" + metadatastr + "'\n");
        }
        catch (Exception e) {
            System.out.println("Error Adding licence. Exception=" + e);
        }
        return null;
    }
}

