/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.StringCrc32Checksum;
import org.opennms.karaf.licencemgr.metadata.Licence;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceEntry;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.rest.client.jerseyimpl.LicenceManagerClientRestJerseyImpl;

@XmlRootElement(name="LicenceServiceData")
@XmlAccessorType(value=XmlAccessType.NONE)
public class LicenceServiceImpl
implements LicenceService {
    private String fileUri = null;
    private Boolean useRemoteLicenceManagers = false;
    private List<String> remoteLicenceMgrs = new ArrayList<String>();
    private Set<String> authenticatedLicences = new HashSet<String>();
    @XmlElementWrapper(name="licenceMap")
    private SortedMap<String, String> licenceMap = new TreeMap<String, String>();
    @XmlElement
    private String systemId = "NOT_SET";
    private String remoteLicenceManagerUserName;
    private String remoteLicenceManagerPassword;

    public void setFileUri(String fileUri) {
        this.fileUri = fileUri;
    }

    public void setRemoteLicenceManagerUserName(String remoteLicenceManagerUserName) {
        this.remoteLicenceManagerUserName = remoteLicenceManagerUserName;
    }

    public void setRemoteLicenceManagerPassword(String remoteLicenceManagerPassword) {
        this.remoteLicenceManagerPassword = remoteLicenceManagerPassword;
    }

    public synchronized void setUseRemoteLicenceManagers(String useRemoteLicenceManagersStr) {
        if (useRemoteLicenceManagersStr == null || !useRemoteLicenceManagersStr.equals("true") && !useRemoteLicenceManagersStr.equals("false")) {
            throw new RuntimeException("useRemoteLicenceManagers set to (" + useRemoteLicenceManagersStr + ") but must be set to boolean true or false");
        }
        this.useRemoteLicenceManagers = Boolean.valueOf(useRemoteLicenceManagersStr);
    }

    public synchronized void setRemoteLicenceMgrs(String remoteLicenceMgrsStr) {
        if (remoteLicenceMgrsStr == null) {
            throw new RuntimeException("remoteLicenceMgrsStr should not be set to null.");
        }
        if (!"".equals(remoteLicenceMgrsStr)) {
            String[] urls = remoteLicenceMgrsStr.split(",");
            ArrayList<String> licenceMgrs = new ArrayList<String>();
            for (String urlstr : urls) {
                urlstr.trim();
                if ("".equals(urlstr)) continue;
                try {
                    URL url = new URL(urlstr);
                    URI uri = url.toURI();
                    licenceMgrs.add(urlstr);
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new RuntimeException("unparsable URL in remote Licence Managers configuration ", e);
                }
            }
            this.remoteLicenceMgrs = licenceMgrs;
            System.out.println("Licence manager remote licence managers set to:");
            for (String lmUrl : this.remoteLicenceMgrs) {
                System.out.println("'" + lmUrl + "' ");
            }
        }
    }

    @Override
    public synchronized void addAuthenticatedProductId(String productId) {
        if (productId == null) {
            throw new RuntimeException("productId cannot be null");
        }
        if (!this.licenceMap.containsKey(productId)) {
            throw new RuntimeException("there is no licence installed for productId=" + productId);
        }
        this.authenticatedLicences.add(productId);
    }

    @Override
    public synchronized void removeAuthenticatedProductId(String productId) {
        if (productId == null) {
            throw new RuntimeException("productId cannot be null");
        }
        this.authenticatedLicences.remove(productId);
    }

    @Override
    public synchronized boolean isAuthenticatedProductId(String productId) {
        if (productId == null) {
            throw new RuntimeException("productId cannot be null");
        }
        return this.authenticatedLicences.contains(productId);
    }

    private synchronized LicenceMetadata localAddLicence(String licenceStrPlusCrc) {
        LicenceMetadata unverifiedMetadata;
        if (licenceStrPlusCrc == null) {
            throw new RuntimeException("licenceStrPlusCrc cannot be null");
        }
        try {
            unverifiedMetadata = Licence.getUnverifiedMetadata(licenceStrPlusCrc);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot decode licence string", e);
        }
        String productId = unverifiedMetadata.getProductId();
        this.licenceMap.put(productId, licenceStrPlusCrc);
        return unverifiedMetadata;
    }

    @Override
    public synchronized LicenceMetadata addLicence(String licenceStrPlusCrc) {
        LicenceMetadata unverifiedMetadata = this.localAddLicence(licenceStrPlusCrc);
        this.persist();
        return unverifiedMetadata;
    }

    @Override
    public synchronized boolean removeLicence(String productId) {
        if (productId == null) {
            throw new RuntimeException("productID cannot be null");
        }
        if (!this.licenceMap.containsKey(productId)) {
            return false;
        }
        this.licenceMap.remove(productId);
        this.persist();
        return true;
    }

    @Override
    public synchronized String getLicence(String productId) {
        if (productId == null) {
            throw new RuntimeException("productID cannot be null");
        }
        return (String)this.licenceMap.get(productId);
    }

    @Override
    public synchronized Map<String, String> getLicenceMap() {
        TreeMap<String, String> map = new TreeMap<String, String>(this.licenceMap);
        return map;
    }

    @Override
    public synchronized Map<String, String> getLicenceMapForSystemId(String systemId) {
        TreeMap<String, String> returnMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> licenceEntry : this.licenceMap.entrySet()) {
            String licenceStrPlusCrc = licenceEntry.getValue();
            LicenceMetadata licenceMetadata = null;
            try {
                licenceMetadata = Licence.getUnverifiedMetadata(licenceStrPlusCrc);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot decode licenceMetadata for internal licence map entry " + licenceEntry.getKey());
            }
            Integer maxSizeSystemIds = null;
            try {
                maxSizeSystemIds = Integer.parseInt(licenceMetadata.getMaxSizeSystemIds());
            }
            catch (Exception e) {
                throw new RuntimeException("the maxSizeSystemIds '" + licenceMetadata.getMaxSizeSystemIds() + "' cannot be parsed as int in licence for productId='" + licenceMetadata.getProductId() + "'", e);
            }
            if (maxSizeSystemIds != 0 && !licenceMetadata.getSystemIds().contains(systemId)) continue;
            returnMap.put(licenceEntry.getKey(), licenceEntry.getValue());
        }
        return returnMap;
    }

    @Override
    public synchronized String getSystemId() {
        return this.systemId;
    }

    @Override
    public synchronized void setSystemId(String systemId) {
        StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
        if (!stringCrc32Checksum.checkCRC(systemId)) {
            throw new RuntimeException("Incorrect checksum or format for systemId=" + systemId);
        }
        this.systemId = systemId;
        this.persist();
    }

    @Override
    public synchronized String makeSystemInstance() {
        Random randomgen = new Random();
        long systemIdValue = randomgen.nextLong();
        String hexSystemIdString = Long.toHexString(systemIdValue);
        StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
        String systemId = stringCrc32Checksum.addCRC(hexSystemIdString);
        this.setSystemId(systemId);
        return systemId;
    }

    @Override
    public String checksumForString(String valueString) {
        if (valueString == null) {
            throw new RuntimeException("valueString cannot be null");
        }
        StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
        return stringCrc32Checksum.addCRC(valueString);
    }

    @Override
    public synchronized void deleteLicences() {
        this.licenceMap.clear();
    }

    public synchronized String installRemoteLicencesFromUrlList(String systemIdStr) {
        String successRemoteLicenceManagerUrl = null;
        for (String remoteLicenceManagerUrl : this.remoteLicenceMgrs) {
            try {
                successRemoteLicenceManagerUrl = this.installRemoteLicences(remoteLicenceManagerUrl, systemIdStr);
            }
            catch (Exception e) {
                System.out.println("   Licence Manager could not load licences from from licence manager at " + remoteLicenceManagerUrl + " for systemIdStr='" + systemIdStr + "' Exception:" + e);
            }
            if (null == successRemoteLicenceManagerUrl) continue;
            System.out.println("Licence Manager succeeded in loading licences from licence manager at " + successRemoteLicenceManagerUrl);
            break;
        }
        if (null == successRemoteLicenceManagerUrl) {
            System.out.println("Licence Manager Could not load licences from any remote licence manager.");
        }
        return successRemoteLicenceManagerUrl;
    }

    public synchronized String installRemoteLicences(String remoteLicenceManagerUrl, String systemIdStr) {
        if (remoteLicenceManagerUrl == null) {
            throw new RuntimeException("Licence Manager remoteLicenceManagerUrl must not be null");
        }
        if (systemIdStr == null) {
            throw new RuntimeException("Licence Manager systemIdStr must not be null");
        }
        try {
            LicenceManagerClientRestJerseyImpl licenceManagerClient = new LicenceManagerClientRestJerseyImpl();
            String basePath = "/licencemgr/rest/licence-mgr";
            licenceManagerClient.setBasePath(basePath);
            licenceManagerClient.setBaseUrl(remoteLicenceManagerUrl);
            licenceManagerClient.setUserName(this.remoteLicenceManagerUserName);
            licenceManagerClient.setPassword(this.remoteLicenceManagerPassword);
            LicenceList licenceList = licenceManagerClient.getLicenceMapForSystemId(systemIdStr);
            List<LicenceEntry> remoteLicenceEntries = licenceList.getLicenceList();
            for (LicenceEntry le : remoteLicenceEntries) {
                String licenceStrPlusCrc = le.getLicenceStr();
                this.localAddLicence(licenceStrPlusCrc);
                System.out.println("    Licence Manager Added remote licence from " + remoteLicenceManagerUrl + " for productId=" + le.getProductId());
            }
            this.persist();
            return remoteLicenceManagerUrl;
        }
        catch (Exception e) {
            throw new RuntimeException("    Licence Manager Cannot get remote licences from remoteLicenceManagerUrl=" + remoteLicenceManagerUrl, e);
        }
    }

    public synchronized void persist() {
        if (this.fileUri == null) {
            throw new RuntimeException("fileUri must be set for licence manager");
        }
        try {
            File licenceManagerFile = new File(this.fileUri);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LicenceServiceImpl.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)this, licenceManagerFile);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Problem persisting Licence Manager Data", e);
        }
    }

    public synchronized void load() {
        if (this.fileUri == null) {
            throw new RuntimeException("fileUri must be set for licence manager");
        }
        try {
            File licenceManagerFile = new File(this.fileUri);
            if (licenceManagerFile.exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LicenceServiceImpl.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                LicenceServiceImpl licenceServiceImpl = (LicenceServiceImpl)jaxbUnmarshaller.unmarshal(licenceManagerFile);
                this.licenceMap.clear();
                this.licenceMap.putAll(licenceServiceImpl.getLicenceMap());
                this.systemId = licenceServiceImpl.getSystemId();
                System.out.println("Licence Manager successfully loaded licences from file=" + licenceManagerFile.getAbsolutePath());
            } else {
                System.out.println("Licence Manager licence file=" + licenceManagerFile.getAbsolutePath() + " does not exist. A new one will be created.");
            }
        }
        catch (JAXBException e) {
            System.out.println("Licence Manager Problem Starting: " + e.getMessage());
            throw new RuntimeException("Problem loading Licence Manager Data", e);
        }
    }

    public synchronized void close() {
        System.out.println("Licence Manager Shutting Down ");
    }

    public synchronized void init() {
        System.out.println("Licence Manager Starting");
        this.load();
        String installedFromLicenceMgr = null;
        if (this.useRemoteLicenceManagers != null && this.useRemoteLicenceManagers.booleanValue()) {
            System.out.println("Licence Manager system attempting to load remote licences");
            if (this.remoteLicenceMgrs != null && !this.remoteLicenceMgrs.isEmpty()) {
                installedFromLicenceMgr = this.installRemoteLicencesFromUrlList(this.systemId);
            } else {
                System.out.println("WARNING: list of remote licence managers is empty");
            }
            if (installedFromLicenceMgr != null) {
                System.out.println("Licence Manager loaded remote licences from url=" + installedFromLicenceMgr);
            } else {
                System.out.println("WARNING Licence Manager unabled to load remote licences from any supplied url");
            }
        } else {
            System.out.println("Licence Manager system set to not load remote licences");
        }
        System.out.println("Licence Manager Started");
    }
}

