/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productreg.cmd;

import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.productpub.ProductRegister;

@Command(scope="product-reg", name="list", description="lists product specifications installed in product registry")
public class ListRegProductSpecsCommand
extends OsgiCommandSupport {
    private ProductRegister productRegister;

    public ProductRegister getProductRegister() {
        return this.productRegister;
    }

    public void setProductRegister(ProductRegister productRegister) {
        this.productRegister = productRegister;
    }

    protected Object doExecute() throws Exception {
        try {
            System.out.println("list of product specifications");
            Map<String, ProductMetadata> productSpecMap = this.getProductRegister().getProductDescriptionMap();
            for (Map.Entry<String, ProductMetadata> entry : productSpecMap.entrySet()) {
                ProductMetadata productSpecification = entry.getValue();
                System.out.println("***********\n  productId='" + entry.getKey() + "'\n" + "  productMetadata='" + productSpecification.toXml() + "'\n");
            }
            System.out.println("***********\n");
        }
        catch (Exception e) {
            System.out.println("Error getting list of installed licence specifications. Exception=" + e);
        }
        return null;
    }
}

