/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productpub.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.productpub.ProductPublisher;

@Command(scope="product-pub", name="getproductspec", description="gets product spec from product publisher for productId")
public class GetProductSpecCommand
extends OsgiCommandSupport {
    private ProductPublisher productPublisher = null;
    @Argument(index=0, name="productId", description="Product Id for which to get product spec", required=true, multiValued=false)
    String productId = null;

    public ProductPublisher getProductPublisher() {
        return this.productPublisher;
    }

    public void setProductPublisher(ProductPublisher productPublisher) {
        this.productPublisher = productPublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            if (this.productPublisher == null) {
                throw new RuntimeException("productPublisher cannot be null");
            }
            ProductMetadata pmeta = this.productPublisher.getProductDescription(this.productId);
            if (pmeta == null) {
                System.out.println("No product metadata installed for productId='" + this.productId + "'");
            } else {
                System.out.println("productId='" + this.productId + "' Product metadata XML='" + pmeta.toXml() + "'");
            }
        }
        catch (Exception e) {
            System.out.println("Error getting product info. Exception=" + e);
        }
        return null;
    }
}

