/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productpub;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.productpub.ProductPublisher;
import org.opennms.karaf.productpub.ProductRegister;

public class ProductPublisherImpl
implements ProductPublisher,
ProductRegister {
    private SortedMap<String, ProductMetadata> productSpecMap = new TreeMap<String, ProductMetadata>();

    @Override
    public void addProductDescription(ProductMetadata productMetadata) {
        if (productMetadata == null) {
            throw new IllegalArgumentException("productMetadata cannot be null");
        }
        this.productSpecMap.put(productMetadata.getProductId(), productMetadata);
    }

    @Override
    public boolean removeProductDescription(String productId) {
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        if (!this.productSpecMap.containsKey(productId)) {
            return false;
        }
        this.productSpecMap.remove(productId);
        return true;
    }

    @Override
    public ProductMetadata getProductDescription(String productId) {
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        return (ProductMetadata)this.productSpecMap.get(productId);
    }

    @Override
    public Map<String, ProductMetadata> getProductDescriptionMap() {
        return new TreeMap<String, ProductMetadata>(this.productSpecMap);
    }

    @Override
    public void deleteProductDescriptions() {
        this.productSpecMap.clear();
    }
}

