/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productpub;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.productpub.BundleProductSpec;
import org.opennms.karaf.productpub.ProductPublisher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleProductSpecImpl
implements BundleProductSpec {
    private BundleContext bundleContext;
    private ProductMetadata productMetadata = null;
    private ProductPublisher productPublisher = null;
    private String productMetadataUri = null;

    private String readFile(InputStream is) throws IOException {
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    @Override
    public void registerSpec() {
        if (this.productPublisher == null) {
            throw new RuntimeException("productPublisher cannot be null");
        }
        if (this.bundleContext == null) {
            throw new RuntimeException("bundleContext cannot be null");
        }
        if (this.productMetadata == null) {
            if (this.productMetadataUri == null) {
                throw new RuntimeException("productMetadataUri cannot be null if no productMetadata defined");
            }
            InputStream is = null;
            try {
                Bundle bundle = this.bundleContext.getBundle();
                is = bundle.getEntry(this.productMetadataUri).openStream();
                String productMetadataXml = this.readFile(is);
                this.productMetadata = new ProductMetadata();
                this.productMetadata.fromXml(productMetadataXml);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot load productMetadata file from bundle productMetadataUri=" + this.productMetadataUri + "  " + e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                is = null;
            }
        }
        this.productPublisher.addProductDescription(this.productMetadata);
        System.out.println("Registered Product Specification for productId=" + this.productMetadata.getProductId());
    }

    @Override
    public void unregisterSpec() {
        if (this.productPublisher != null) {
            try {
                this.productPublisher.removeProductDescription(this.productMetadata.getProductId());
                System.out.println("Unregistered Product Specification for productId=" + this.productMetadata.getProductId());
            }
            catch (Exception e) {
                System.out.println("Problem Unregistering Product Specification for productId=" + this.productMetadata.getProductId() + "  " + e);
            }
            finally {
                this.productPublisher = null;
            }
        }
    }

    @Override
    public ProductMetadata getProductMetadata() {
        return this.productMetadata;
    }

    @Override
    public void setProductMetadata(ProductMetadata productMetadata) {
        if (productMetadata == null) {
            throw new IllegalArgumentException("productMetadata cannot be null");
        }
        this.productMetadata = productMetadata;
    }

    @Override
    public ProductPublisher getProductPublisher() {
        return this.productPublisher;
    }

    @Override
    public void setProductPublisher(ProductPublisher productPublisher) {
        if (productPublisher == null) {
            throw new IllegalArgumentException("productPublisher cannot be null");
        }
        this.productPublisher = productPublisher;
    }

    @Override
    public String getProductMetadataUri() {
        return this.productMetadataUri;
    }

    @Override
    public void setProductMetadataUri(String productMetadataUri) {
        if (productMetadataUri == null) {
            throw new IllegalArgumentException("productMetadataUri cannot be null");
        }
        this.productMetadataUri = productMetadataUri;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.bundleContext = bundleContext;
    }
}

