/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.rest.client.jerseyimpl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import org.opennms.karaf.licencemgr.metadata.jaxb.ErrorMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.ReplyMessage;
import org.opennms.karaf.licencemgr.rest.client.LicenceManagerClient;

public class LicenceManagerClientRestJerseyImpl
implements LicenceManagerClient {
    private String baseUrl = "http://localhost:8181";
    private String basePath = "/licencemgr/rest/licence-mgr";
    private String userName = null;
    private String password = "";

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new RuntimeException("password must not be set to null");
        }
        this.password = password;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private Client newClient() {
        Client client = Client.create();
        if (this.userName != null) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.userName, this.password));
        }
        return client;
    }

    @Override
    public LicenceMetadata addLicence(String licence) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (licence == null) {
            throw new RuntimeException("licence must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/addlicence?licence=" + licence);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getlicencespec Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        LicenceMetadata licenceMetadata = replyMessage.getLicenceMetadata();
        return licenceMetadata;
    }

    @Override
    public void removeLicence(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/removelicence?productId=" + productId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "removeLicence Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public String getLicence(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/getlicence?productId=" + productId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getLicence Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        String licence = replyMessage.getLicence();
        return licence;
    }

    @Override
    public Boolean isAuthenticated(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/isauthenticated?productId=" + productId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getLicence Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        Boolean isAuthenticated = replyMessage.getIsAuthenticated();
        return isAuthenticated;
    }

    @Override
    public LicenceList getLicenceMap() throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/list");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getLicenceMap Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        LicenceList licenceListResponse = (LicenceList)response.getEntity(LicenceList.class);
        return licenceListResponse;
    }

    @Override
    public LicenceList getLicenceMapForSystemId(String systemId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (systemId == null) {
            throw new RuntimeException("systemId must not be null");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/listforsystemid?systemId=" + systemId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getLicenceMapForSystemId Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        LicenceList licenceListResponse = (LicenceList)response.getEntity(LicenceList.class);
        return licenceListResponse;
    }

    @Override
    public void deleteLicences(Boolean confirm) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (confirm == null) {
            throw new RuntimeException("confirm must be set true of false");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/clearlicences?confirm=" + (confirm != false ? "true" : "false"));
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "removeLicence Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public String getSystemId() throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/getsystemid");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "getLicence Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        String systemid = replyMessage.getSystemId();
        return systemid;
    }

    @Override
    public void setSystemId(String systemId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (systemId == null) {
            throw new RuntimeException("systemId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/setsystemid?systemId=" + systemId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "setSystemId Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public String makeSystemInstance() throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/makesystemid");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "makeSystemInstance Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        String systemid = replyMessage.getSystemId();
        return systemid;
    }

    @Override
    public String checksumForString(String string) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (string == null) {
            throw new RuntimeException("string must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/checksumforstring?string=" + string);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "checksumForString Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
        ReplyMessage replyMessage = (ReplyMessage)response.getEntity(ReplyMessage.class);
        String checksum = replyMessage.getChecksum();
        return checksum;
    }
}

