/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.metadata.Licence;

@Command(scope="licence-mgr", name="getlicence", description="returns licence string installed for productId")
public class GetProductLicenceCommand
extends OsgiCommandSupport {
    private LicenceService _licenceService;
    @Argument(index=0, name="productId", description="Product Id to which licence-mgr applies", required=true, multiValued=false)
    String productId = null;

    public LicenceService getLicenceService() {
        return this._licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this._licenceService = licenceService;
    }

    protected Object doExecute() throws Exception {
        try {
            String licence = this.getLicenceService().getLicence(this.productId);
            if (licence == null) {
                System.out.println("no licence installed for productId='" + this.productId + "'");
            } else {
                String metadatastr = Licence.getUnverifiedMetadata(licence).toXml();
                System.out.println("Found licence ProductId='" + this.productId + "'");
                System.out.println("              licence=  '" + licence + "'");
                System.out.println("              licenceMetadata='" + metadatastr + "'");
            }
        }
        catch (Exception e) {
            System.out.println("Error getting licence for productId. Exception=" + e);
        }
        return null;
    }
}

