/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productreg.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.productpub.ProductRegister;

@Command(scope="product-reg", name="getproductspec", description="gets product spec from  product registry for productId")
public class GetRegProductSpecCommand
extends OsgiCommandSupport {
    private ProductRegister productRegister;
    @Argument(index=0, name="productId", description="Product Id for which to get product spec", required=true, multiValued=false)
    String productId = null;

    public ProductRegister getProductRegister() {
        return this.productRegister;
    }

    public void setProductRegister(ProductRegister productRegister) {
        this.productRegister = productRegister;
    }

    protected Object doExecute() throws Exception {
        try {
            if (this.productRegister == null) {
                throw new RuntimeException("productPublisher cannot be null");
            }
            ProductMetadata pmeta = this.productRegister.getProductDescription(this.productId);
            if (pmeta == null) {
                System.out.println("No product metadata installed for productId='" + this.productId + "'");
            } else {
                System.out.println("productId='" + this.productId + "' Product metadata XML='" + pmeta.toXml() + "'");
            }
        }
        catch (Exception e) {
            System.out.println("Error getting product info. Exception=" + e);
        }
        return null;
    }
}

