/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencepub.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencepub.LicencePublisher;

@Command(scope="licence-pub", name="getlicencespec", description="Gets the licence specification for a given product id")
public class GetLicenceSpecCommand
extends OsgiCommandSupport {
    private LicencePublisher _licencePublisher;
    @Argument(index=0, name="productId", description="productId for which to find specification", required=true, multiValued=false)
    String productId = null;

    public LicencePublisher getLicencePublisher() {
        return this._licencePublisher;
    }

    public void setLicencePublisher(LicencePublisher _licencePublisher) {
        this._licencePublisher = _licencePublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            LicenceSpecification licenceSpecification = this.getLicencePublisher().getLicenceSpec(this.productId);
            if (licenceSpecification == null) {
                System.out.println("licence specification not installed for productId='" + this.productId + "'");
            } else {
                LicenceMetadata licenceMetadata = licenceSpecification.getLicenceMetadataSpec();
                String metadatastr = licenceMetadata == null ? "null" : licenceMetadata.toXml();
                System.out.println("  productId='" + this.productId + "'\n" + "      licenceMetadataSpec='" + metadatastr + "'\n" + "      licenceSpecification secret key String='" + licenceSpecification.getAesSecretKeyStr() + "'\n" + "      licenceSpecification public key String='" + licenceSpecification.getPublicKeyStr() + "'\n");
            }
        }
        catch (Exception e) {
            System.out.println("Error getting licence specification. Exception=" + e);
        }
        return null;
    }
}

