/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class AesSymetricKeyCipher {
    private int passwordLength = 16;
    private int saltLength = 16;
    private int initializationVectorSeedLength = 16;
    private int hashIterations = 10000;
    private int keyLength = 128;
    private SecretKey secretKey = null;

    public String getEncodedSecretKeyStr() {
        return DatatypeConverter.printHexBinary((byte[])this.secretKey.getEncoded());
    }

    public void setEncodedSecretKeyStr(String secretKeyStr) {
        this.secretKey = new SecretKeySpec(DatatypeConverter.parseHexBinary((String)secretKeyStr), "AES");
    }

    public void generateKey() {
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecureRandom secureRandom = new SecureRandom();
            PBEKeySpec keySpec = new PBEKeySpec(this.getRandomPassword(), secureRandom.generateSeed(this.saltLength), this.hashIterations, this.keyLength);
            this.secretKey = new SecretKeySpec(secretKeyFactory.generateSecret(keySpec).getEncoded(), "AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("cannot generate AesSymmetricKey:", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("cannot generate AesSymmetricKey:", e);
        }
    }

    public String aesEncryptStr(String src) {
        String aesEncryptStr = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecureRandom secureRandom = new SecureRandom();
            byte[] seed = secureRandom.generateSeed(this.initializationVectorSeedLength);
            IvParameterSpec algorithmParameterSpec = new IvParameterSpec(seed);
            cipher.init(1, (Key)this.secretKey, algorithmParameterSpec);
            byte[] encryptedMessageBytes = cipher.doFinal(src.getBytes("UTF-8"));
            byte[] bytesToEncode = new byte[seed.length + encryptedMessageBytes.length];
            System.arraycopy(seed, 0, bytesToEncode, 0, seed.length);
            System.arraycopy(encryptedMessageBytes, 0, bytesToEncode, seed.length, encryptedMessageBytes.length);
            aesEncryptStr = DatatypeConverter.printHexBinary((byte[])bytesToEncode);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("problem encrypting AesSymetricKey", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("problem encrypting AesSymetricKey", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("problem encrypting AesSymetricKey", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("problem encrypting AesSymetricKey", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("problem encrypting AesSymetricKey", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("problem encrypting AesSymetricKey", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("problem encrypting AesSymetricKey", e);
        }
        return aesEncryptStr;
    }

    public String aesDecryptStr(String encryptedStr) {
        byte[] bytesToDecode = DatatypeConverter.parseHexBinary((String)encryptedStr);
        byte[] emptySeed = new byte[this.initializationVectorSeedLength];
        System.arraycopy(bytesToDecode, 0, emptySeed, 0, this.initializationVectorSeedLength);
        String aesDecryptStr = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)this.secretKey, new IvParameterSpec(emptySeed));
            int messageDecryptedBytesLength = bytesToDecode.length - this.initializationVectorSeedLength;
            byte[] messageDecryptedBytes = new byte[messageDecryptedBytesLength];
            System.arraycopy(bytesToDecode, this.initializationVectorSeedLength, messageDecryptedBytes, 0, messageDecryptedBytesLength);
            byte[] decodedBytes = cipher.doFinal(messageDecryptedBytes);
            aesDecryptStr = new String(decodedBytes, "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("problem decrypting AesSymetricKey", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("problem decrypting AesSymetricKey", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("problem decrypting AesSymetricKey", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("problem decrypting AesSymetricKey", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("problem decrypting AesSymetricKey", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("problem decrypting AesSymetricKey", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("problem decrypting AesSymetricKey", e);
        }
        return aesDecryptStr;
    }

    private char[] getRandomPassword() {
        char[] randomPassword = new char[this.passwordLength];
        Random random = new Random();
        for (int i = 0; i < this.passwordLength; ++i) {
            randomPassword[i] = (char)(random.nextInt(94) + 33);
        }
        return randomPassword;
    }
}

