/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="plugin-feature-mgr", name="setKarafInstance", description="sets the karaf instance name to use when requesting manifest.")
public class SetKarafInstanceCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SetKarafInstanceCommand.class);
    private PluginFeatureManagerService _pluginFeatureManagerService;
    @Argument(index=0, name="karafInstance", description="karaf instance name to use when requesting manifest", required=true, multiValued=false)
    String karafInstance = null;

    public PluginFeatureManagerService getPluginFeatureManagerService() {
        return this._pluginFeatureManagerService;
    }

    public void setPluginFeatureManagerService(PluginFeatureManagerService pluginFeatureManager) {
        this._pluginFeatureManagerService = pluginFeatureManager;
    }

    protected Object doExecute() throws Exception {
        try {
            this.getPluginFeatureManagerService().updateKarafInstance(this.karafInstance);
            String msg = "set remote karafInstance=" + this.karafInstance;
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("error setting karaf instance. Exception=" + e);
            LOG.error("error setting karaf instance. Exception=", (Throwable)e);
        }
        return null;
    }
}

