/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.cmd;

import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="plugin-feature-mgr", name="persistConfiguration", description="Persists current plugin manager configuration to be used on start up.")
public class PersistConfigurationCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PersistConfigurationCommand.class);
    private PluginFeatureManagerService _pluginFeatureManagerService;

    public PluginFeatureManagerService getPluginFeatureManagerService() {
        return this._pluginFeatureManagerService;
    }

    public void setPluginFeatureManagerService(PluginFeatureManagerService pluginFeatureManager) {
        this._pluginFeatureManagerService = pluginFeatureManager;
    }

    protected Object doExecute() throws Exception {
        try {
            String result = this.getPluginFeatureManagerService().persistConfiguration();
            String msg = "persisted configuration:" + result;
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("error persisting configuration. Exception=" + e);
            LOG.error("error persisting configuration. Exception=", (Throwable)e);
        }
        return null;
    }
}

