/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="plugin-feature-mgr", name="installNewManifest", description="Installs a new plugin manifest. Installs all features in manifest.")
public class InstallNewManifestCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(InstallNewManifestCommand.class);
    private PluginFeatureManagerService _pluginFeatureManagerService;
    @Argument(index=0, name="manifest", description="XML manifest feature definition. See documentation.", required=true, multiValued=false)
    String newManifestStr = null;

    public PluginFeatureManagerService getPluginFeatureManagerService() {
        return this._pluginFeatureManagerService;
    }

    public void setPluginFeatureManagerService(PluginFeatureManagerService pluginFeatureManager) {
        this._pluginFeatureManagerService = pluginFeatureManager;
    }

    protected Object doExecute() throws Exception {
        try {
            String msg = "Trying to install new manifest=" + this.newManifestStr;
            LOG.info(msg);
            System.out.println(msg);
            String result = this.getPluginFeatureManagerService().installNewManifest(this.newManifestStr);
            String installedManifest = this.getPluginFeatureManagerService().getInstalledManifest();
            msg = "Result of operation:" + result;
            msg = msg + "\nCurrently Installed Manifest='" + installedManifest + "'";
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("Error installing new manifest. Exception=" + e);
            LOG.error("Error installing new manifest. Exception=", (Throwable)e);
        }
        return null;
    }
}

