/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.cmd;

import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="plugin-feature-mgr", name="uninstallManifest", description="Uninstalls current manifest .")
public class UninstallManifestCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(UninstallManifestCommand.class);
    private PluginFeatureManagerService _pluginFeatureManagerService;

    public PluginFeatureManagerService getPluginFeatureManagerService() {
        return this._pluginFeatureManagerService;
    }

    public void setPluginFeatureManagerService(PluginFeatureManagerService pluginFeatureManager) {
        this._pluginFeatureManagerService = pluginFeatureManager;
    }

    protected Object doExecute() throws Exception {
        try {
            String msg = "Uninstalling manifest";
            LOG.info(msg);
            System.out.println(msg);
            String result = this.getPluginFeatureManagerService().uninstallManifest();
            String installedManifest = this.getPluginFeatureManagerService().getInstalledManifest();
            msg = "Result of operation:" + result;
            msg = msg + "\nCurrently Installed Manifest='" + installedManifest + "'";
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("Error uninstalling manifest. Exception=" + e);
            LOG.error("Error uninstalling manifest. Exception=", (Throwable)e);
        }
        return null;
    }
}

