/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.cmd;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="plugin-feature-mgr", name="scheduleManifestDownload", description="Lists or sets parameters for schedulling automatic manifest download. With no options existing paramaters are listed.")
public class SetScheduleManifestDownloadCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SetScheduleManifestDownloadCommand.class);
    private PluginFeatureManagerService _pluginFeatureManagerService;
    @Option(name="-e", aliases={"--enableRemotePluginManagers"}, description="(true or false) If true, will try to download manifest feature list from remote urls", required=false, multiValued=false)
    String useRemotePluginManagersStr;
    @Option(name="-i", aliases={"--retryInterval"}, description="(integer ms) Interval before retrying unsuccessful download of manifests ", required=false, multiValued=false)
    String retryIntervalStr;
    @Option(name="-r", aliases={"--retryNumber"}, description="(integer) unsuccessful number of retrys -1 = forever until successful", required=false, multiValued=false)
    String retryNumberStr;
    @Option(name="-u", aliases={"--updateInterval"}, description="(integer ms) long term update interval before attempting to reload config. -1= only try on startup", required=false, multiValued=false)
    String updateIntervalStr;

    public PluginFeatureManagerService getPluginFeatureManagerService() {
        return this._pluginFeatureManagerService;
    }

    public void setPluginFeatureManagerService(PluginFeatureManagerService pluginFeatureManager) {
        this._pluginFeatureManagerService = pluginFeatureManager;
    }

    protected Object doExecute() throws Exception {
        try {
            Boolean useRemotePluginManagers = this.useRemotePluginManagersStr == null || "".equals(this.useRemotePluginManagersStr) ? null : Boolean.valueOf(Boolean.parseBoolean(this.useRemotePluginManagersStr));
            Integer retryInterval = this.retryIntervalStr == null || "".equals(this.retryIntervalStr) ? null : Integer.valueOf(Integer.parseInt(this.retryIntervalStr));
            Integer retryNumber = this.retryNumberStr == null || "".equals(this.retryNumberStr) ? null : Integer.valueOf(Integer.parseInt(this.retryNumberStr));
            Integer updateInterval = this.updateIntervalStr == null || "".equals(this.updateIntervalStr) ? null : Integer.valueOf(Integer.parseInt(this.updateIntervalStr));
            String schedule = this.getPluginFeatureManagerService().updateSchedule(useRemotePluginManagers, retryInterval, retryNumber, updateInterval);
            String msg = "manifest schedule command result: " + schedule;
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("error updating manifest schedule. Exception=" + e);
            LOG.error("error updating manifest schedule. Exception=", (Throwable)e);
        }
        return null;
    }
}

