/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr;

import java.io.File;
import java.net.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.features.FeaturesService;
import org.opennms.karaf.featuremgr.FeaturesUtils;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.opennms.karaf.featuremgr.TaskTimer;
import org.opennms.karaf.featuremgr.jaxb.karaf.feature.Features;
import org.opennms.karaf.featuremgr.manifest.client.jerseyimpl.ManifestServiceClientRestJerseyImpl;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginFeatureManagerImpl
implements PluginFeatureManagerService {
    private static final Logger LOG = LoggerFactory.getLogger(PluginFeatureManagerImpl.class);
    private static final String PERSISTANT_ID = "org.opennms.features.featuremgr.config";
    private static final String USE_REMOTE_PLUGIN_MANAGER_KEY = "org.opennms.karaf.featuremgr.useRemotePluginManagers";
    private static final String REMOTE_PLUGIN_MANAGER_URLS_KEY = "org.opennms.karaf.featuremgr.remotePluginManagersUrls";
    private static final String REMOTE_PLUGIN_MANAGER_USERNAME_KEY = "org.opennms.karaf.featuremgr.remoteUsername";
    private static final String REMOTE_PLUGIN_MANAGER_PASSWORD_KEY = "org.opennms.karaf.featuremgr.remotePassword";
    private static final String KARAF_INSTANCE_KEY = "org.opennms.karaf.featuremgr.karafInstance";
    private static final String RETRY_INTERVAL_KEY = "org.opennms.karaf.featuremgr.retryInterval";
    private static final String RETRY_NUMBER_KEY = "org.opennms.karaf.featuremgr.retryNumber";
    private static final String UPDATE_INTERVAL_KEY = "org.opennms.karaf.featuremgr.updateInterval";
    private FeaturesService m_featuresService = null;
    private ConfigurationAdmin m_configurationAdmin = null;
    private TaskTimer m_timer = new TaskTimer();
    private boolean m_useLocalManifestAtStartup = true;
    private boolean m_useRemotePluginManagers = false;
    private Set<String> m_remotePluginManagersUrls = new LinkedHashSet<String>();
    private String m_remoteUsername = null;
    private String m_remotePassword = null;
    private String m_installedManifestUri = null;
    private String m_karafInstance = null;
    private Integer m_retryInterval = null;
    private Integer m_retryNumber = null;
    private Integer m_updateInterval = null;

    public void setFeaturesService(FeaturesService featuresService) {
        this.m_featuresService = featuresService;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.m_configurationAdmin = configurationAdmin;
    }

    public void setUseLocalManifestAtStartup(String useLocalManifestAtStartup) {
        this.m_useLocalManifestAtStartup = Boolean.parseBoolean(useLocalManifestAtStartup);
    }

    public void setUseRemotePluginManagers(String useRemotePluginManagers) {
        this.m_useRemotePluginManagers = Boolean.parseBoolean(useRemotePluginManagers);
    }

    public void setRemotePluginManagersUrls(String remotePluginManagersUrls) {
        this.m_remotePluginManagersUrls = this.stringCsvPropertyToList(remotePluginManagersUrls);
    }

    public void setRemoteUsername(String remoteUsername) {
        this.m_remoteUsername = remoteUsername;
    }

    public void setRemotePassword(String remotePassword) {
        this.m_remotePassword = remotePassword;
    }

    public void setInstalledManifestUri(String installedManifestUri) {
        this.m_installedManifestUri = installedManifestUri;
    }

    public String getKarafInstance() {
        return this.m_karafInstance;
    }

    public void setKarafInstance(String karafInstance) {
        this.m_karafInstance = karafInstance;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.m_retryInterval = retryInterval;
    }

    public void setRetryNumber(Integer retryNumber) {
        this.m_retryNumber = retryNumber;
    }

    public void setUpdateInterval(Integer updateInterval) {
        this.m_updateInterval = updateInterval;
    }

    public synchronized void init() {
        System.out.println("PluginFeatureManager starting up. Use local manifest at startup=" + this.m_useLocalManifestAtStartup + " Use remote plugin managers=" + this.m_useRemotePluginManagers);
        LOG.info("PluginFeatureManager starting up Use local manifest at startup=" + this.m_useLocalManifestAtStartup + " Use remote plugin managers=" + this.m_useRemotePluginManagers);
        Thread manifestStartup = new Thread(new Runnable(){

            @Override
            public void run() {
                if (PluginFeatureManagerImpl.this.m_useLocalManifestAtStartup) {
                    LOG.info("PluginFeatureManager trying to startup using local manifest (useLocalManifestAtStartup=true)");
                    try {
                        String manifest = PluginFeatureManagerImpl.this.getInstalledManifest();
                        if (manifest == null) {
                            LOG.info("PluginFeatureManager trying to startup using local manifest but no local manifest file present.");
                        } else {
                            LOG.info("PluginFeatureManager trying to install local manifest=" + manifest);
                            PluginFeatureManagerImpl.this.installNewManifest(manifest);
                            LOG.info("PluginFeatureManager installed local manifest");
                        }
                    }
                    catch (Exception ex) {
                        LOG.error("PluginFeatureManager problem installing local manifest", (Throwable)ex);
                    }
                }
                LOG.info("PluginFeatureManager starting up without using local manifest (useLocalManifestAtStartup=false)");
                if (PluginFeatureManagerImpl.this.m_useRemotePluginManagers) {
                    LOG.info("PluginFeatureManager schedulling download of manifests from remote plugin manager (useRemotePluginManagers=true)");
                    try {
                        PluginFeatureManagerImpl.this.restartSchedule();
                    }
                    catch (Exception ex) {
                        LOG.error("PluginFeatureManager problem starting manifest download schedule", (Throwable)ex);
                    }
                } else {
                    LOG.info("PluginFeatureManager scheduled download of manifests from remote plugin manager not enabled. (useRemotePluginManagers=false)");
                }
            }
        });
        manifestStartup.start();
        LOG.info("PluginFeatureManager started");
        System.out.println("PluginFeatureManager started");
    }

    public synchronized void destroy() {
        LOG.info("PluginFeatureManager shutting down");
        System.out.println("PluginFeatureManager shutting down");
        try {
            if (this.m_timer != null) {
                this.m_timer.stopSchedule();
            }
        }
        catch (Exception ex) {
            LOG.error("problem stopping schedule when shutting down", (Throwable)ex);
        }
        finally {
            this.m_timer = null;
        }
    }

    @Override
    public synchronized String installNewManifest(String newManifestStr) {
        FeaturesUtils.installManifestFeatures(newManifestStr, this.m_installedManifestUri, this.m_featuresService);
        return "installed manifest";
    }

    @Override
    public synchronized String uninstallManifest() {
        FeaturesUtils.uninstallManifestFeatures(this.m_installedManifestUri, this.m_featuresService);
        return "uninstalled manifest";
    }

    @Override
    public synchronized void installNewManifestFromPluginManagerUrl(String karafInstance, String url, String userName, String password) {
        ManifestServiceClientRestJerseyImpl manifestServiceClient = new ManifestServiceClientRestJerseyImpl();
        manifestServiceClient.setBaseUrl(url);
        manifestServiceClient.setBasePath("");
        manifestServiceClient.setUserName(userName);
        manifestServiceClient.setPassword(password);
        String manifest = null;
        try {
            manifest = manifestServiceClient.getFeatureManifest(karafInstance);
        }
        catch (Exception e) {
            throw new RuntimeException("problem fetching manifest from remote pluging manager", e);
        }
        try {
            FeaturesUtils.installManifestFeatures(manifest, this.m_installedManifestUri, this.m_featuresService);
        }
        catch (Exception e) {
            throw new RuntimeException("problem installing manifest=" + manifest, e);
        }
    }

    @Override
    public synchronized boolean updateManifestFromPluginManagers() {
        boolean success = false;
        for (String url : this.m_remotePluginManagersUrls) {
            try {
                this.installNewManifestFromPluginManagerUrl(this.m_karafInstance, url, this.m_remoteUsername, this.m_remotePassword);
                success = true;
                LOG.info(" successfully updated manifest from url=" + url);
                break;
            }
            catch (Exception ex) {
                LOG.error(" failed to update manifest from url=" + url, (Throwable)ex);
            }
        }
        return success;
    }

    @Override
    public synchronized String getInstalledManifest() {
        if (this.m_installedManifestUri == null) {
            throw new RuntimeException("ServiceLoader.getInstalledManifestUri() cannot be null.");
        }
        try {
            URI uri = new URI(this.m_installedManifestUri);
            File installedManifestFile = new File(uri.getPath());
            if (!installedManifestFile.exists()) {
                return null;
            }
            Features features = FeaturesUtils.loadFeaturesFile(installedManifestFile);
            return FeaturesUtils.featuresToString(features);
        }
        catch (Exception ex) {
            throw new RuntimeException("problem loading installed manifest from installedManifestUri=" + this.m_installedManifestUri, ex);
        }
    }

    @Override
    public synchronized void updateKarafInstance(String karafInstance) {
        this.m_karafInstance = karafInstance;
    }

    @Override
    public synchronized void updateRemotePluginServers(String remotePluginManagersUrls, String remoteUserName, String remotePassword) {
        this.m_remotePluginManagersUrls = this.stringCsvPropertyToList(remotePluginManagersUrls);
        this.m_remoteUsername = remoteUserName;
        this.m_remotePassword = remotePassword;
    }

    public synchronized void restartSchedule() {
        if (this.m_retryInterval == null) {
            throw new RuntimeException("retryInterval cannot be null when starting schedule");
        }
        if (this.m_retryNumber == null) {
            throw new RuntimeException("retryNumber cannot be null when starting schedule");
        }
        if (this.m_updateInterval == null) {
            throw new RuntimeException("updateInterval cannot be null when starting schedule");
        }
        this.m_timer.stopSchedule();
        if (this.m_useRemotePluginManagers) {
            this.m_timer.setRetryInterval(this.m_retryInterval);
            this.m_timer.setRetryNumber(this.m_retryNumber);
            this.m_timer.setUpdateInterval(this.m_updateInterval);
            PluginFeatureManagerImpl pluginFeatureManager = this;
            ScheduledManifestUpdate task = new ScheduledManifestUpdate(pluginFeatureManager);
            this.m_timer.setTask(task);
            this.m_timer.startSchedule();
        }
    }

    public synchronized void stopSchedule() {
        if (this.m_timer != null) {
            this.m_timer.stopSchedule();
        }
    }

    @Override
    public synchronized String updateSchedule(Boolean useRemotePluginManagers, Integer retryInterval, Integer retryNumber, Integer updateInterval) {
        boolean justlist = true;
        String msg = "";
        if (retryInterval != null) {
            justlist = false;
            this.m_retryInterval = retryInterval;
        }
        if (retryNumber != null) {
            justlist = false;
            this.m_retryNumber = retryNumber;
        }
        if (updateInterval != null) {
            justlist = false;
            this.m_updateInterval = updateInterval;
        }
        if (useRemotePluginManagers != null) {
            justlist = false;
            this.m_useRemotePluginManagers = useRemotePluginManagers;
        }
        if (!justlist) {
            msg = "Restarting schedule with new configuration.\n";
            this.restartSchedule();
        }
        msg = this.m_timer.getScheduleIsRunning() ? msg + "Schedule Running\n" : msg + "Schedule Stopped\n";
        msg = msg + "Schedule configuration = useRemotePluginManagers=" + this.m_useRemotePluginManagers + ", retryInterval=" + this.m_retryInterval + ", retryNumber=" + this.m_retryNumber + ", updateInterval=" + this.m_updateInterval;
        return msg;
    }

    @Override
    public synchronized String persistConfiguration() {
        try {
            Configuration config = this.m_configurationAdmin.getConfiguration(PERSISTANT_ID);
            Hashtable<String, String> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, String>();
            }
            ((Dictionary)props).put(USE_REMOTE_PLUGIN_MANAGER_KEY, Boolean.toString(this.m_useRemotePluginManagers));
            ((Dictionary)props).put(REMOTE_PLUGIN_MANAGER_URLS_KEY, this.listToStringCsvProperty(this.m_remotePluginManagersUrls));
            ((Dictionary)props).put(REMOTE_PLUGIN_MANAGER_USERNAME_KEY, this.m_remoteUsername);
            ((Dictionary)props).put(REMOTE_PLUGIN_MANAGER_PASSWORD_KEY, this.m_remotePassword);
            ((Dictionary)props).put(KARAF_INSTANCE_KEY, this.m_karafInstance);
            ((Dictionary)props).put(RETRY_INTERVAL_KEY, Integer.toString(this.m_retryInterval));
            ((Dictionary)props).put(RETRY_NUMBER_KEY, Integer.toString(this.m_retryNumber));
            ((Dictionary)props).put(UPDATE_INTERVAL_KEY, Integer.toString(this.m_updateInterval));
            StringBuffer msg = new StringBuffer("Persisted configuration:\n");
            Enumeration e = ((Dictionary)props).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)((Dictionary)props).get(key);
                msg.append("    " + key + "=" + value + "\n");
            }
            config.update(props);
            LOG.info(msg.toString());
            return msg.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("problem updating configuration in org.opennms.features.featuremgr.config.cfg", e);
        }
    }

    private Set<String> stringCsvPropertyToList(String setStringStr) {
        LinkedHashSet<String> setString = new LinkedHashSet<String>();
        if (setStringStr != null & !"".equals(setStringStr)) {
            String[] stringArray;
            for (String str : stringArray = setStringStr.split(",")) {
                str.trim();
                if ("".equals(str)) continue;
                setString.add(str);
            }
        }
        return setString;
    }

    private String listToStringCsvProperty(Set<String> setString) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> itr = setString.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            if (!itr.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private class ScheduledManifestUpdate
    implements TaskTimer.ScheduledTask {
        private PluginFeatureManagerImpl pluginFeatureManager;
        private AtomicInteger count = new AtomicInteger(0);

        ScheduledManifestUpdate(PluginFeatureManagerImpl pluginFeatureManager) {
            this.pluginFeatureManager = Objects.requireNonNull(pluginFeatureManager);
        }

        @Override
        public boolean runScheduledTask() {
            int c = this.count.incrementAndGet();
            boolean success = false;
            LOG.info("Running scheduled manifest update. Times this schedule has run: " + c);
            try {
                success = this.pluginFeatureManager.updateManifestFromPluginManagers();
            }
            catch (Exception e) {
                LOG.error("problem running schedule updating manifest from plugin managers", (Throwable)e);
            }
            return success;
        }
    }
}

