/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.manifest.client.jerseyimpl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import javax.ws.rs.core.MediaType;

public class ManifestServiceClientRestJerseyImpl {
    private String baseUrl = "http://localhost:8181";
    private String basePath = "/pluginmgr";
    private String userName = null;
    private String password = "";

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new RuntimeException("password must not be set to null");
        }
        this.password = password;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private Client newClient() {
        Client client = Client.create();
        if (this.userName != null) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.userName, this.password));
        }
        return client;
    }

    public String getFeatureManifest(String karafInstance) throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(this.baseUrl + this.basePath + "/rest/v1-0/manifest-feature-list?karafInstance=" + karafInstance);
        String manifest = (String)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class);
        return manifest;
    }
}

