/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="plugin-feature-mgr", name="setRemotePluginServers", description="sets the remote plugin server urls, username and password.")
public class SetRemotePluginServersCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SetRemotePluginServersCommand.class);
    private PluginFeatureManagerService _pluginFeatureManagerService;
    @Argument(index=0, name="urlList", description="comma separated list of plugin manger urls to ask for manifest", required=true, multiValued=false)
    String urls = null;
    @Argument(index=0, name="RemoteUsername", description="Remote Username to download manifest", required=false, multiValued=false)
    String remoteUsername = null;
    @Argument(index=0, name="RemotePassword", description="Remote Password to download manifest", required=false, multiValued=false)
    String remotePassword = null;

    public PluginFeatureManagerService getPluginFeatureManagerService() {
        return this._pluginFeatureManagerService;
    }

    public void setPluginFeatureManagerService(PluginFeatureManagerService pluginFeatureManager) {
        this._pluginFeatureManagerService = pluginFeatureManager;
    }

    protected Object doExecute() throws Exception {
        try {
            this.getPluginFeatureManagerService().updateRemotePluginServers(this.urls, this.remoteUsername, this.remotePassword);
            String msg = "set remote plugin servers urls=" + this.urls;
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("error setting remote plugin servers. Exception=" + e);
            LOG.error("error setting remote plugin servers. Exception=", (Throwable)e);
        }
        return null;
    }
}

