/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.featuremgr.PluginFeatureManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="plugin-feature-mgr", name="installManifestFromUrl", description="Installs a new plugin manifest from a given url.")
public class InstallNewManifestFromUrlCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(InstallNewManifestFromUrlCommand.class);
    private PluginFeatureManagerService _pluginFeatureManagerService;
    @Argument(index=0, name="karafInstance", description="karaf instance for which to request manifest", required=true, multiValued=false)
    String karafInstance = null;
    @Argument(index=1, name="url", description="url to download manifest", required=true, multiValued=false)
    String urlStr = null;
    @Argument(index=2, name="RemoteUsername", description="Remote Username to download manifest (optional)", required=false, multiValued=false)
    String remoteUserName = null;
    @Argument(index=3, name="RemotePassword", description="Remote Password to download manifest (optional)", required=false, multiValued=false)
    String remotePassword = null;

    public PluginFeatureManagerService getPluginFeatureManagerService() {
        return this._pluginFeatureManagerService;
    }

    public void setPluginFeatureManagerService(PluginFeatureManagerService pluginFeatureManager) {
        this._pluginFeatureManagerService = pluginFeatureManager;
    }

    protected Object doExecute() throws Exception {
        try {
            Object newManifestStr = null;
            String msg = "Trying to install manifest from url=" + this.urlStr + ", karafInstance=" + this.karafInstance;
            LOG.info(msg);
            System.out.println(msg);
            this.getPluginFeatureManagerService().installNewManifestFromPluginManagerUrl(this.karafInstance, this.urlStr, this.remoteUserName, this.remotePassword);
            String installedManifest = this.getPluginFeatureManagerService().getInstalledManifest();
            msg = msg + "\nSuccess. Currently Installed Manifest='" + installedManifest + "'";
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("Error installing new manifest from url=" + this.urlStr + ", karafInstance=" + this.karafInstance + " Exception=" + e);
            LOG.error("Error installing new manifest from url=" + this.urlStr + ", karafInstance=" + this.karafInstance, (Throwable)e);
        }
        return null;
    }
}

