/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.karaf.features.FeaturesService;
import org.opennms.karaf.featuremgr.jaxb.karaf.feature.Dependency;
import org.opennms.karaf.featuremgr.jaxb.karaf.feature.Feature;
import org.opennms.karaf.featuremgr.jaxb.karaf.feature.Features;
import org.opennms.karaf.featuremgr.jaxb.karaf.feature.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FeaturesUtils.class);
    private static final String MANIFEST_FEATURES_REPOSITORY_NAME = "manifest-features";
    private static final String MANIFEST_FEATURE_NAME = "manifest";
    private static final String MANIFEST_FEATURE_VERSION = "1.0-SNAPSHOT";
    private static final String EMPTY_MANIFEST_FEATURES = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><features name=\"manifest-features\" xmlns=\"http://karaf.apache.org/xmlns/features/v1.2.0\">  <feature name=\"manifest\" version=\"1.0-SNAPSHOT\" description=\"Plugin manifest to be installed at startup\">  </feature></features>";

    public static synchronized String synchronizeManifestFeaturesFiles(String manifestFeaturesUri, String installedManifestFeaturesUri, FeaturesService featuresService) {
        Features installedManifestFeatures;
        File manifestFeaturesFile = new File(manifestFeaturesUri);
        if (!manifestFeaturesFile.exists()) {
            throw new RuntimeException("cannot synchronize manifestFeaturesFile does not exist " + manifestFeaturesFile.getAbsolutePath());
        }
        Features manifestFeatures = FeaturesUtils.loadFeaturesFile(manifestFeaturesFile);
        File installedManifestFeaturesFile = new File(installedManifestFeaturesUri);
        if (!installedManifestFeaturesFile.exists()) {
            installedManifestFeatures = new Features();
            installedManifestFeatures.setName(MANIFEST_FEATURES_REPOSITORY_NAME);
            Feature manifestFeature = new Feature();
            manifestFeature.setName(MANIFEST_FEATURE_NAME);
            manifestFeature.setVersion(MANIFEST_FEATURE_VERSION);
            installedManifestFeatures.getRepositoryOrFeature().add(manifestFeature);
            FeaturesUtils.persistFeaturesFile(installedManifestFeatures, installedManifestFeaturesFile);
        }
        installedManifestFeatures = FeaturesUtils.loadFeaturesFile(installedManifestFeaturesFile);
        String msg = FeaturesUtils.synchronizeManifestFeatures(manifestFeatures, installedManifestFeatures, featuresService);
        FeaturesUtils.persistFeaturesFile(installedManifestFeatures, installedManifestFeaturesFile);
        return msg;
    }

    public static synchronized String synchronizeManifestFeatures(Features manifestFeatures, Features installedManifestFeatures, FeaturesService featuresService) {
        StringBuffer msg = new StringBuffer();
        ArrayList<String> repoList = new ArrayList<String>();
        LinkedHashMap<String, Feature> featureMap = new LinkedHashMap<String, Feature>();
        ArrayList<Dependency> manifestFeatureDependencyList = new ArrayList<Dependency>();
        ArrayList<String> installedRepoList = new ArrayList<String>();
        LinkedHashMap<String, Feature> installedFeatureMap = new LinkedHashMap<String, Feature>();
        ArrayList<Dependency> installedManifestFeatureDependencyList = new ArrayList<Dependency>();
        List<Object> reposOrfeatures = manifestFeatures.getRepositoryOrFeature();
        if (reposOrfeatures != null) {
            for (Object object : reposOrfeatures) {
                if (object instanceof Feature) {
                    Feature feature = (Feature)object;
                    featureMap.put(feature.getName(), feature);
                    continue;
                }
                if (object instanceof String) {
                    repoList.add((String)object);
                    continue;
                }
                throw new RuntimeException("unknown object type " + object.getClass().getCanonicalName() + " in feature definition");
            }
        }
        if (!featureMap.containsKey(MANIFEST_FEATURE_NAME)) {
            throw new RuntimeException("new manifest features definition does not contain featuremanifest");
        }
        Feature manifestFeature = (Feature)featureMap.get(MANIFEST_FEATURE_NAME);
        for (Object object : manifestFeature.getDetailsOrConfigOrConfigfile()) {
            if (!(object instanceof Dependency)) continue;
            manifestFeatureDependencyList.add((Dependency)object);
        }
        List<Object> list = installedManifestFeatures.getRepositoryOrFeature();
        if (list != null) {
            for (Object object : list) {
                if (object instanceof Feature) {
                    Feature feature = (Feature)object;
                    installedFeatureMap.put(feature.getName(), feature);
                    continue;
                }
                if (object instanceof String) {
                    installedRepoList.add((String)object);
                    continue;
                }
                throw new RuntimeException("unknown object type " + object.getClass().getCanonicalName() + " in feature definition");
            }
        }
        if (!installedFeatureMap.containsKey(MANIFEST_FEATURE_NAME)) {
            throw new RuntimeException("installed manifest features definition does not contain featuremanifest");
        }
        Feature feature = (Feature)installedFeatureMap.get(MANIFEST_FEATURE_NAME);
        for (Object content : feature.getDetailsOrConfigOrConfigfile()) {
            if (!(content instanceof Dependency)) continue;
            installedManifestFeatureDependencyList.add((Dependency)content);
        }
        Iterator iterator = installedManifestFeatureDependencyList.iterator();
        while (iterator.hasNext()) {
            Dependency f = (Dependency)iterator.next();
            String fname = f.getValue();
            boolean remove = true;
            for (Dependency dependency : manifestFeatureDependencyList) {
                if (!dependency.getValue().equals(fname)) continue;
                remove = false;
            }
            if (!remove) continue;
            try {
                EnumSet<FeaturesService.Option> options = EnumSet.of(FeaturesService.Option.NoFailOnFeatureNotFound);
                featuresService.uninstallFeature(fname, options);
                iterator.remove();
                msg.append("removed installed manifest feature:" + fname + "\n");
            }
            catch (Exception e) {
                LOG.error("cannot remove installed manifest feature:" + fname, (Throwable)e);
            }
        }
        for (String repo : repoList) {
            try {
                LOG.debug("refreshing manifest repository: " + repo);
                URI uri = new URI(repo);
                boolean uninstall = false;
                featuresService.removeRepository(uri, uninstall);
                boolean install = false;
                featuresService.addRepository(uri, install);
                msg.append("refreshed manifest repository uri:" + repo + "\n");
            }
            catch (Exception e) {
                LOG.error("cannot refresh manifest repository uri:" + repo, (Throwable)e);
            }
        }
        for (Dependency dependency : manifestFeatureDependencyList) {
            try {
                LOG.debug("installing manifest feature: " + dependency.getValue());
                featuresService.installFeature(dependency.getValue());
                msg.append("installed manifest feature:" + dependency.getValue() + "\n");
            }
            catch (Exception e) {
                LOG.error("cannot install manifest feature:" + dependency.getValue(), (Throwable)e);
                msg.append("cannot install manifest feature:" + dependency.getValue() + "\n");
            }
        }
        installedManifestFeatures.getRepositoryOrFeature().clear();
        installedManifestFeatures.getRepositoryOrFeature().addAll(manifestFeatures.getRepositoryOrFeature());
        return msg.toString();
    }

    public static synchronized void installManifestFeatures(String manifest, String installedManifestFeaturesUri, FeaturesService featuresService) {
        try {
            Features features = FeaturesUtils.parseFeatures(manifest);
            URI uri = new URI(installedManifestFeaturesUri);
            File installedManifestFile = new File(uri.getPath());
            FeaturesUtils.persistFeaturesFile(features, installedManifestFile);
            featuresService.addRepository(uri);
            org.apache.karaf.features.Feature mfeature = featuresService.getFeature(MANIFEST_FEATURE_NAME);
            if (mfeature != null && featuresService.isInstalled(mfeature)) {
                featuresService.uninstallFeature(MANIFEST_FEATURE_NAME);
            }
            featuresService.installFeature(MANIFEST_FEATURE_NAME);
        }
        catch (Exception ex) {
            throw new RuntimeException("problem installing manifest features", ex);
        }
    }

    public static synchronized void uninstallManifestFeatures(String installedManifestFeaturesUri, FeaturesService featuresService) {
        try {
            FeaturesUtils.installManifestFeatures(EMPTY_MANIFEST_FEATURES, installedManifestFeaturesUri, featuresService);
        }
        catch (Exception ex) {
            throw new RuntimeException("problem uninstalling manifest features", ex);
        }
    }

    public static Features parseFeatures(String featuresStr) {
        Features features = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Features.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(featuresStr);
            JAXBElement jbe = (JAXBElement)jaxbUnmarshaller.unmarshal((Reader)reader);
            features = (Features)jbe.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Problem parsing features string", e);
        }
        return features;
    }

    public static String featuresToString(Features features) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Features.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            ObjectFactory of = new ObjectFactory();
            JAXBElement<Features> jbeFeature = of.createFeatures(features);
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal(jbeFeature, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Problem persisting feature file", e);
        }
    }

    public static boolean compareManifestFeatures(Features manifest1, Features manifest2) {
        if (manifest1 == null) {
            throw new RuntimeException("parameter manifest1 cannot be null");
        }
        if (manifest2 == null) {
            throw new RuntimeException("parameter manifest2 cannot be null");
        }
        return FeaturesUtils.featuresToString(manifest1).equals(FeaturesUtils.featuresToString(manifest2));
    }

    public static synchronized void persistFeaturesFile(Features features, File featuresFile) {
        try {
            featuresFile.getParentFile().mkdirs();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Features.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            ObjectFactory of = new ObjectFactory();
            JAXBElement<Features> jbeFeature = of.createFeatures(features);
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal(jbeFeature, featuresFile);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Problem persisting feature file", e);
        }
    }

    public static synchronized Features loadFeaturesFile(File featuresFile) {
        Features features = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Features.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement jbe = (JAXBElement)jaxbUnmarshaller.unmarshal(featuresFile);
            features = (Features)jbe.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Problem loading features file", e);
        }
        return features;
    }
}

