/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.rest.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.opennms.karaf.featuremgr.jaxb.ErrorMessage;
import org.opennms.karaf.featuremgr.jaxb.FeatureList;
import org.opennms.karaf.featuremgr.jaxb.FeatureWrapperJaxb;
import org.opennms.karaf.featuremgr.jaxb.ReplyMessage;
import org.opennms.karaf.featuremgr.jaxb.RepositoryList;
import org.opennms.karaf.featuremgr.jaxb.RepositoryWrapperJaxb;
import org.opennms.karaf.featuremgr.rest.impl.ServiceLoader;

@Path(value="/")
public class FeaturesServiceRestImpl {
    @GET
    @Path(value="/features-list")
    @Produces(value={"application/xml"})
    public Response getFeaturesList() throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        FeatureList featuresList = new FeatureList();
        Feature[] features = featuresService.listFeatures();
        for (int i = 0; i < features.length; ++i) {
            Boolean isInstalled = featuresService.isInstalled(features[i]);
            FeatureWrapperJaxb wrapper = new FeatureWrapperJaxb(features[i].getName(), features[i].getVersion(), features[i].getDescription(), features[i].getDetails(), isInstalled);
            featuresList.getFeatureList().add(wrapper);
        }
        return Response.status((int)200).entity((Object)featuresList).build();
    }

    @GET
    @Path(value="/features-info")
    @Produces(value={"application/xml"})
    public Response getFeaturesInfo(@QueryParam(value="name") String name, @QueryParam(value="version") String version) throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        Feature feature = null;
        Boolean isInstalled = null;
        try {
            if (name == null) {
                throw new RuntimeException("feature name cannot be null.");
            }
            feature = version != null ? featuresService.getFeature(name, version) : featuresService.getFeature(name);
            if (feature == null) {
                throw new RuntimeException("feature not found.");
            }
            isInstalled = featuresService.isInstalled(feature);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "unable to get feature name=" + name + " version=" + version, null, exception)).build();
        }
        FeatureWrapperJaxb featurewrapper = new FeatureWrapperJaxb(feature.getName(), feature.getVersion(), feature.getDescription(), feature.getDetails(), isInstalled);
        return Response.status((int)200).entity((Object)featurewrapper).build();
    }

    @GET
    @Path(value="/features-install")
    @Produces(value={"application/xml"})
    public Response featuresInstall(@QueryParam(value="name") String name, @QueryParam(value="version") String version) throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        try {
            if (name == null) {
                throw new RuntimeException("feature name cannot be null.");
            }
            if (version != null) {
                featuresService.installFeature(name, version);
            } else {
                featuresService.installFeature(name);
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "unable to install feature name=" + name + " version=" + version, null, exception)).build();
        }
        return Response.status((int)200).entity((Object)new ReplyMessage(200, 0, "Success. Installed feature name=" + name + " version=" + version, null, null)).build();
    }

    @GET
    @Path(value="/features-uninstall")
    @Produces(value={"application/xml"})
    public Response featuresUninstall(@QueryParam(value="name") String name, @QueryParam(value="version") String version) throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        try {
            if (name == null) {
                throw new RuntimeException("feature name cannot be null.");
            }
            if (version != null) {
                featuresService.uninstallFeature(name, version);
            } else {
                featuresService.uninstallFeature(name);
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to uninstall feature name=" + name + " version=" + version, null, exception)).build();
        }
        return Response.status((int)200).entity((Object)new ReplyMessage(200, 0, "Success. Uninstalled feature name=" + name + " version=" + version, null, null)).build();
    }

    @GET
    @Path(value="/features-listrepositories")
    @Produces(value={"application/xml"})
    public Response getFeaturesListRepositories() throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        Repository[] repositories = featuresService.listRepositories();
        RepositoryList repositoryList = new RepositoryList();
        for (int i = 0; i < repositories.length; ++i) {
            RepositoryWrapperJaxb wrapper = new RepositoryWrapperJaxb(repositories[i].getName(), repositories[i].getURI());
            repositoryList.getRepositoryList().add(wrapper);
        }
        return Response.status((int)200).entity((Object)repositoryList).build();
    }

    @GET
    @Path(value="/features-repositoryinfo")
    @Produces(value={"application/xml"})
    public Response getFeaturesRepositoryInfo(@QueryParam(value="name") String name, @QueryParam(value="uri") String uriStr) throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        Repository repository = null;
        RepositoryWrapperJaxb repositoryWrapper = null;
        try {
            if (name == null && uriStr == null) {
                throw new RuntimeException("you must specify either a ?uri= or ?name= parameter.");
            }
            if (name != null && uriStr != null) {
                throw new RuntimeException("you can only specify ONE of either a ?uri= or ?name= parameter.");
            }
            URI repoUri = null;
            if (uriStr != null) {
                repoUri = new URI(uriStr);
            }
            Repository[] repositories = featuresService.listRepositories();
            for (int i = 0; i < repositories.length; ++i) {
                if (name != null) {
                    if (!repositories[i].getName().equals(name)) continue;
                    repository = repositories[i];
                    continue;
                }
                if (!repositories[i].getURI().equals(repoUri)) continue;
                repository = repositories[i];
            }
            if (repository == null) {
                throw new RuntimeException("repository not found.");
            }
            FeatureList featuresList = new FeatureList();
            Feature[] features = repository.getFeatures();
            for (int i = 0; i < features.length; ++i) {
                Boolean isInstalled = featuresService.isInstalled(features[i]);
                FeatureWrapperJaxb wrapper = new FeatureWrapperJaxb(features[i].getName(), features[i].getVersion(), features[i].getDescription(), features[i].getDetails(), isInstalled);
                featuresList.getFeatureList().add(wrapper);
            }
            List<URI> repositoriesURI = Arrays.asList(repository.getRepositories());
            repositoryWrapper = new RepositoryWrapperJaxb(repository.getName(), repository.getURI(), featuresList, repositoriesURI);
        }
        catch (URISyntaxException uriException) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "unable to parse URI for feature uri=" + uriStr, null, uriException)).build();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "problem finding repository=" + name + " " + uriStr, null, exception)).build();
        }
        return Response.status((int)200).entity((Object)repositoryWrapper).build();
    }

    @GET
    @Path(value="/features-removerepository")
    @Produces(value={"application/xml"})
    public Response featuresRemoveRepository(@QueryParam(value="uri") String uriStr) throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        try {
            if (uriStr == null) {
                throw new RuntimeException("you must supply ?uri= paramater.");
            }
            URI url = new URI(uriStr);
            Repository[] repositories = featuresService.listRepositories();
            Repository repository = null;
            for (int i = 0; i < repositories.length; ++i) {
                if (!repositories[i].getURI().equals(url)) continue;
                repository = repositories[i];
            }
            if (repository == null) {
                throw new RuntimeException("repository not found.");
            }
            featuresService.removeRepository(url);
        }
        catch (URISyntaxException uriException) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "unable to parse URI for feature uri=" + uriStr, null, uriException)).build();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "problem removing repository uri=" + uriStr, null, exception)).build();
        }
        return Response.status((int)200).entity((Object)new ReplyMessage(200, 0, "Success. Removed repository uri=" + uriStr, null, null)).build();
    }

    @GET
    @Path(value="/features-addrepositoryurl")
    @Produces(value={"application/xml"})
    public Response featuresAddRepository(@QueryParam(value="uri") String uriStr) throws Exception {
        FeaturesService featuresService = ServiceLoader.getFeaturesService();
        if (featuresService == null) {
            throw new RuntimeException("ServiceLoader.getLicencePublisher() cannot be null.");
        }
        try {
            if (uriStr == null) {
                throw new RuntimeException("you must supply ?uri= paramater.");
            }
            URI url = new URI(uriStr);
            featuresService.validateRepository(url);
            featuresService.addRepository(url);
        }
        catch (URISyntaxException uriException) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "unable to parse URI for feature uri=" + uriStr, null, uriException)).build();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "problem adding repository uri=" + uriStr, null, exception)).build();
        }
        return Response.status((int)200).entity((Object)new ReplyMessage(200, 0, "Success. Added repository uri=" + uriStr, null, null)).build();
    }
}

