/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.featuremgr.rest.client.jerseyimpl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import javax.ws.rs.core.MediaType;
import org.opennms.karaf.featuremgr.jaxb.ErrorMessage;
import org.opennms.karaf.featuremgr.jaxb.FeatureList;
import org.opennms.karaf.featuremgr.jaxb.FeatureWrapperJaxb;
import org.opennms.karaf.featuremgr.jaxb.ReplyMessage;
import org.opennms.karaf.featuremgr.jaxb.RepositoryList;
import org.opennms.karaf.featuremgr.jaxb.RepositoryWrapperJaxb;
import org.opennms.karaf.featuremgr.jaxb.Util;
import org.opennms.karaf.featuremgr.rest.client.FeaturesServiceClient;

public class FeaturesServiceClientRestJerseyImpl
implements FeaturesServiceClient {
    private String baseUrl = "http://localhost:8181";
    private String basePath = "/featuremgr";
    private String userName = null;
    private String password = "";

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new RuntimeException("password must not be set to null");
        }
        this.password = password;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private Client newClient() {
        Client client = Client.create();
        if (this.userName != null) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.userName, this.password));
        }
        return client;
    }

    @Override
    public FeatureList getFeaturesList() throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(this.baseUrl + this.basePath + "/rest/features-list");
        FeatureList featurelist = (FeatureList)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(FeatureList.class);
        return featurelist;
    }

    @Override
    public FeatureWrapperJaxb getFeaturesInfo(String name, String version) throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (name == null) {
            throw new RuntimeException("?name= parameter must be set");
        }
        Client client = this.newClient();
        String getStr = this.baseUrl + this.basePath + "/rest/features-info?name=" + name;
        if (version != null) {
            getStr = getStr + "&version=" + version;
        }
        WebResource r = client.resource(getStr);
        FeatureWrapperJaxb featurewrapper = (FeatureWrapperJaxb)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(FeatureWrapperJaxb.class);
        return featurewrapper;
    }

    @Override
    public void featuresInstall(String name, String version) throws Exception {
        WebResource r;
        String replyString;
        Object replyObject;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (name == null) {
            throw new RuntimeException("?name= parameter must be set");
        }
        Client client = this.newClient();
        String getStr = this.baseUrl + this.basePath + "/rest/features-install?name=" + name;
        if (version != null) {
            getStr = getStr + "&version=" + version;
        }
        if ((replyObject = Util.fromXml(replyString = (String)((WebResource.Builder)(r = client.resource(getStr)).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class))) instanceof ErrorMessage) {
            ErrorMessage errorm = (ErrorMessage)replyObject;
            throw new RuntimeException("could not install feature. status:" + errorm.getStatus() + " message:" + errorm.getMessage() + " code:" + errorm.getCode() + " developer message:" + errorm.getDeveloperMessage());
        }
        if (!(replyObject instanceof ReplyMessage)) {
            throw new RuntimeException("received unexpected reply object: " + replyObject.getClass().getCanonicalName());
        }
    }

    @Override
    public void featuresUninstall(String name, String version) throws Exception {
        WebResource r;
        String replyString;
        Object replyObject;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (name == null) {
            throw new RuntimeException("?name= parameter must be set");
        }
        Client client = this.newClient();
        String getStr = this.baseUrl + this.basePath + "/rest/features-uninstall?name=" + name;
        if (version != null) {
            getStr = getStr + "&version=" + version;
        }
        if ((replyObject = Util.fromXml(replyString = (String)((WebResource.Builder)(r = client.resource(getStr)).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class))) instanceof ErrorMessage) {
            ErrorMessage errorm = (ErrorMessage)replyObject;
            throw new RuntimeException("could not uninstall feature. status:" + errorm.getStatus() + " message:" + errorm.getMessage() + " code:" + errorm.getCode() + " developer message:" + errorm.getDeveloperMessage());
        }
        if (!(replyObject instanceof ReplyMessage)) {
            throw new RuntimeException("received unexpected reply object: " + replyObject.getClass().getCanonicalName());
        }
    }

    @Override
    public RepositoryList getFeaturesListRepositories() throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(this.baseUrl + this.basePath + "/rest/features-listrepositories");
        RepositoryList repositoryList = (RepositoryList)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(RepositoryList.class);
        return repositoryList;
    }

    @Override
    public RepositoryWrapperJaxb getFeaturesRepositoryInfo(String name, String uriStr) throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (name == null && uriStr == null) {
            throw new RuntimeException("you must specify either a ?uri= or ?name= parameter.");
        }
        if (name != null && uriStr != null) {
            throw new RuntimeException("you can only specify ONE of either a ?uri= or ?name= parameter.");
        }
        Client client = this.newClient();
        String getStr = this.baseUrl + this.basePath + "/rest/features-repositoryinfo?" + (uriStr == null ? "name=" + name : "uri=" + uriStr);
        WebResource r = client.resource(getStr);
        RepositoryWrapperJaxb repositoryWrapper = (RepositoryWrapperJaxb)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(RepositoryWrapperJaxb.class);
        return repositoryWrapper;
    }

    @Override
    public void featuresRemoveRepository(String uriStr) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (uriStr == null) {
            throw new RuntimeException("uriStr= parameter must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/rest/features-removerepository?uri=" + uriStr);
        String replyString = (String)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class);
        Object replyObject = Util.fromXml(replyString);
        if (replyObject instanceof ErrorMessage) {
            ErrorMessage errorm = (ErrorMessage)replyObject;
            throw new RuntimeException("could not uninstall feature. status:" + errorm.getStatus() + " message:" + errorm.getMessage() + " code:" + errorm.getCode() + " developer message:" + errorm.getDeveloperMessage());
        }
        if (!(replyObject instanceof ReplyMessage)) {
            throw new RuntimeException("received unexpected reply object: " + replyObject.getClass().getCanonicalName());
        }
    }

    @Override
    public void featuresAddRepository(String uriStr) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (uriStr == null) {
            throw new RuntimeException("uriStr= parameter must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/rest/features-addrepositoryurl?uri=" + uriStr);
        String replyString = (String)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class);
        Object replyObject = Util.fromXml(replyString);
        if (replyObject instanceof ErrorMessage) {
            ErrorMessage errorm = (ErrorMessage)replyObject;
            throw new RuntimeException("could not uninstall feature. status:" + errorm.getStatus() + " message:" + errorm.getMessage() + " code:" + errorm.getCode() + " developer message:" + errorm.getDeveloperMessage());
        }
        if (!(replyObject instanceof ReplyMessage)) {
            throw new RuntimeException("received unexpected reply object: " + replyObject.getClass().getCanonicalName());
        }
    }
}

