/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.plugins.elasticsearch.rest.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public class NodeCacheImpl
implements NodeCache {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCacheImpl.class);
    private long MAX_SIZE = 10000L;
    private long MAX_TTL = 5L;
    private volatile NodeDao nodeDao;
    private volatile TransactionOperations transactionOperations;
    private static boolean archiveAssetData = true;
    private LoadingCache<Long, Map<String, String>> cache = null;

    public void init() {
        if (this.cache == null) {
            LOG.info("initializing node data cache (archiveAssetData=" + archiveAssetData + ", TTL=" + this.MAX_TTL + "m, MAX_SIZE=" + this.MAX_SIZE + ")");
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
            if (this.MAX_TTL > 0L) {
                cacheBuilder.expireAfterWrite(this.MAX_TTL, TimeUnit.MINUTES);
            }
            if (this.MAX_SIZE > 0L) {
                cacheBuilder.maximumSize(this.MAX_SIZE);
            }
            this.cache = cacheBuilder.build((CacheLoader)new CacheLoader<Long, Map<String, String>>(){

                public Map<String, String> load(Long key) throws Exception {
                    return NodeCacheImpl.this.getNodeAndCategoryInfo(key);
                }
            });
        }
    }

    @Override
    public Map<String, String> getEntry(Long key) {
        return (Map)this.cache.getUnchecked((Object)key);
    }

    @Override
    public void refreshEntry(Long key) {
        LOG.debug("refreshing node cache entry: " + key);
        this.cache.refresh((Object)key);
    }

    private Map<String, String> getNodeAndCategoryInfo(final Long nodeId) {
        final HashMap<String, String> result = new HashMap<String, String>();
        if (nodeId != null) {
            LOG.debug("Fetching node data from database into cache");
            this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    OnmsNode node = NodeCacheImpl.this.nodeDao.get(nodeId.toString());
                    if (node != null) {
                        NodeCacheImpl.populateBodyWithNodeInfo(result, node);
                    }
                }
            });
        }
        return result;
    }

    private static void populateBodyWithNodeInfo(Map<String, String> body, OnmsNode node) {
        body.put("nodelabel", node.getLabel());
        body.put("nodesysname", node.getSysName());
        body.put("nodesyslocation", node.getSysLocation());
        body.put("foreignsource", node.getForeignSource());
        body.put("foreignid", node.getForeignId());
        body.put("operatingsystem", node.getOperatingSystem());
        StringBuilder categories = new StringBuilder();
        Iterator i = node.getCategories().iterator();
        while (i.hasNext()) {
            categories.append(((OnmsCategory)i.next()).getName());
            if (!i.hasNext()) continue;
            categories.append(",");
        }
        body.put("categories", categories.toString());
        if (archiveAssetData) {
            OnmsAssetRecord assetRecord;
            OnmsNode parent = node.getParent();
            if (parent != null) {
                if (parent.getLabel() != null) {
                    body.put("parent-nodelabel", parent.getLabel());
                }
                if (parent.getNodeId() != null) {
                    body.put("parent-nodeid", parent.getNodeId());
                }
                if (parent.getForeignSource() != null) {
                    body.put("parent-foreignsource", parent.getForeignSource());
                }
                if (parent.getForeignId() != null) {
                    body.put("parent-foreignid", parent.getForeignId());
                }
            }
            if ((assetRecord = node.getAssetRecord()) != null) {
                OnmsGeolocation gl = assetRecord.getGeolocation();
                if (gl != null) {
                    if (gl.getLatitude() != null) {
                        body.put("asset-latitude", gl.getLatitude().toString());
                    }
                    if (gl.getLongitude() != null) {
                        body.put("asset-longitude", gl.getLongitude().toString());
                    }
                }
                if (assetRecord.getRegion() != null && !"".equals(assetRecord.getRegion())) {
                    body.put("asset-region", assetRecord.getRegion());
                }
                if (assetRecord.getBuilding() != null && !"".equals(assetRecord.getBuilding())) {
                    body.put("asset-building", assetRecord.getBuilding());
                }
                if (assetRecord.getFloor() != null && !"".equals(assetRecord.getFloor())) {
                    body.put("asset-floor", assetRecord.getFloor());
                }
                if (assetRecord.getRoom() != null && !"".equals(assetRecord.getRoom())) {
                    body.put("asset-room", assetRecord.getRoom());
                }
                if (assetRecord.getRack() != null && !"".equals(assetRecord.getRack())) {
                    body.put("asset-rack", assetRecord.getRack());
                }
                if (assetRecord.getSlot() != null && !"".equals(assetRecord.getSlot())) {
                    body.put("asset-slot", assetRecord.getSlot());
                }
                if (assetRecord.getPort() != null && !"".equals(assetRecord.getPort())) {
                    body.put("asset-port", assetRecord.getPort());
                }
                if (assetRecord.getCategory() != null && !"".equals(assetRecord.getCategory())) {
                    body.put("asset-category", assetRecord.getCategory());
                }
                if (assetRecord.getDisplayCategory() != null && !"".equals(assetRecord.getDisplayCategory())) {
                    body.put("asset-displaycategory", assetRecord.getDisplayCategory());
                }
                if (assetRecord.getNotifyCategory() != null && !"".equals(assetRecord.getNotifyCategory())) {
                    body.put("asset-notifycategory", assetRecord.getNotifyCategory());
                }
                if (assetRecord.getPollerCategory() != null && !"".equals(assetRecord.getPollerCategory())) {
                    body.put("asset-pollercategory", assetRecord.getPollerCategory());
                }
                if (assetRecord.getThresholdCategory() != null && !"".equals(assetRecord.getThresholdCategory())) {
                    body.put("asset-thresholdcategory", assetRecord.getThresholdCategory());
                }
                if (assetRecord.getManagedObjectType() != null && !"".equals(assetRecord.getManagedObjectType())) {
                    body.put("asset-managedobjecttype", assetRecord.getManagedObjectType());
                }
                if (assetRecord.getManagedObjectInstance() != null && !"".equals(assetRecord.getManagedObjectInstance())) {
                    body.put("asset-managedobjectinstance", assetRecord.getManagedObjectInstance());
                }
                if (assetRecord.getManufacturer() != null && !"".equals(assetRecord.getManufacturer())) {
                    body.put("asset-manufacturer", assetRecord.getManufacturer());
                }
                if (assetRecord.getVendor() != null && !"".equals(assetRecord.getVendor())) {
                    body.put("asset-vendor", assetRecord.getVendor());
                }
                if (assetRecord.getModelNumber() != null && !"".equals(assetRecord.getModelNumber())) {
                    body.put("asset-modelnumber", assetRecord.getModelNumber());
                }
            }
        }
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public TransactionOperations getTransactionOperations() {
        return this.transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    public long getMAX_SIZE() {
        return this.MAX_SIZE;
    }

    public void setMAX_SIZE(long MAX_SIZE) {
        this.MAX_SIZE = MAX_SIZE;
    }

    public long getMAX_TTL() {
        return this.MAX_TTL;
    }

    public void setMAX_TTL(long MAX_TTL) {
        this.MAX_TTL = MAX_TTL;
    }

    public boolean getArchiveAssetData() {
        return archiveAssetData;
    }

    public void setArchiveAssetData(boolean archiveAssetData) {
        NodeCacheImpl.archiveAssetData = archiveAssetData;
    }
}

