/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNameFunction {
    private static final Logger LOG = LoggerFactory.getLogger(IndexNameFunction.class);
    private SimpleDateFormat df = null;

    public IndexNameFunction() {
        this.df = new SimpleDateFormat("yyyy.MM");
    }

    public IndexNameFunction(String dateFormat) {
        this.df = new SimpleDateFormat(dateFormat == null ? "yyyy.MM" : dateFormat);
    }

    public String apply(String rootIndexName) {
        String result = null;
        result = rootIndexName.toLowerCase() + "-" + this.df.format(new Date());
        if (LOG.isDebugEnabled()) {
            LOG.debug("IndexNameFunction.apply=" + result);
        }
        return result;
    }

    public String apply(String rootIndexName, Date date) {
        String result = null;
        result = rootIndexName.toLowerCase() + "-" + this.df.format(date);
        if (LOG.isDebugEnabled()) {
            LOG.debug("IndexNameFunction.apply=" + result);
        }
        return result;
    }
}

