/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.action.DocumentTargetedAction;
import io.searchbox.client.JestClient;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import io.searchbox.core.Update;
import io.searchbox.indices.CreateIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.plugins.elasticsearch.rest.IndexNameFunction;
import org.opennms.plugins.elasticsearch.rest.NodeCache;
import org.opennms.plugins.elasticsearch.rest.OnmsJestResult;
import org.opennms.plugins.elasticsearch.rest.RestClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventToIndex
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EventToIndex.class);
    public static final EnumMap<Indices, String> INDEX_NAMES = new EnumMap<Indices, String>(Indices.class){
        {
            this.put(Indices.ALARMS, "opennms-alarms");
            this.put(Indices.ALARM_EVENTS, "opennms-events-alarmchange");
            this.put(Indices.EVENTS, "opennms-events-raw");
        }
    };
    public static final EnumMap<Indices, String> INDEX_TYPES = new EnumMap<Indices, String>(Indices.class){
        {
            this.put(Indices.ALARMS, "alarmdata");
            this.put(Indices.ALARM_EVENTS, "eventdata");
            this.put(Indices.EVENTS, "eventdata");
        }
    };
    public static final String ALARM_NOTIFICATION_UEI_STEM = "uei.opennms.org/plugin/AlarmChangeNotificationEvent";
    public static final String ALARM_DELETED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmDeleted";
    public static final String ALARM_CREATED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/NewAlarmCreated";
    public static final String ALARM_SEVERITY_CHANGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmSeverityChanged";
    public static final String ALARM_CLEARED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmCleared";
    public static final String ALARM_ACKNOWLEDGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmAcknowledged";
    public static final String ALARM_UNACKNOWLEDGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmUnAcknowledged";
    public static final String ALARM_SUPPRESSED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmSuppressed";
    public static final String ALARM_UNSUPPRESSED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmUnSuppressed";
    public static final String ALARM_TROUBLETICKET_STATE_CHANGE_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/TroubleTicketStateChange";
    public static final String ALARM_CHANGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmChanged";
    public static final String STICKY_MEMO_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/StickyMemoUpdate";
    public static final String JOURNAL_MEMO_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/JournalMemoUpdate";
    public static final String MEMO_VALUES_PARAM = "memovalues";
    public static final String MEMO_ALARMID_PARAM = "alarmid";
    public static final String MEMO_BODY_PARAM = "body";
    public static final String MEMO_AUTHOR_PARAM = "author";
    public static final String MEMO_REDUCTIONKEY_PARAM = "reductionkey";
    public static final String OLD_ALARM_VALUES_PARAM = "oldalarmvalues";
    public static final String NEW_ALARM_VALUES_PARAM = "newalarmvalues";
    public static final String NODE_LABEL_PARAM = "nodelabel";
    public static final String INITIAL_SEVERITY_PARAM = "initialseverity";
    public static final String INITIAL_SEVERITY_PARAM_TEXT = "initialseverity_text";
    public static final String SEVERITY_TEXT = "severity_text";
    public static final String SEVERITY = "severity";
    public static final String ALARM_SEVERITY_PARAM = "alarmseverity";
    public static final String FIRST_EVENT_TIME = "firsteventtime";
    public static final String EVENT_PARAMS = "eventparms";
    public static final String ALARM_ACK_TIME_PARAM = "alarmacktime";
    public static final String ALARM_ACK_USER_PARAM = "alarmackuser";
    public static final String ALARM_ACK_DURATION = "alarmackduration";
    public static final String ALARM_CLEAR_TIME = "alarmcleartime";
    public static final String ALARM_CLEAR_DURATION = "alarmclearduration";
    public static final String ALARM_DELETED_TIME = "alarmdeletedtime";
    public static final int DEFAULT_NUMBER_OF_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private boolean logEventDescription = false;
    private boolean logAllEvents = false;
    private boolean archiveRawEvents = true;
    private boolean archiveAlarms = true;
    private boolean archiveAlarmChangeEvents = true;
    private boolean archiveOldAlarmValues = true;
    private boolean archiveNewAlarmValues = true;
    private boolean groupOidParameters = false;
    private NodeCache nodeCache = null;
    private JestClient jestClient = null;
    private RestClientFactory restClientFactory = null;
    private int threads = DEFAULT_NUMBER_OF_THREADS;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(this.threads, this.threads, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), new ThreadFactory(){
        final AtomicInteger index = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, EventToIndex.class.getSimpleName() + "-Thread-" + String.valueOf(this.index.incrementAndGet()));
        }
    }, new ThreadPoolExecutor.CallerRunsPolicy());
    private IndexNameFunction indexNameFunction = new IndexNameFunction();

    public IndexNameFunction getIndexNameFunction() {
        return this.indexNameFunction;
    }

    public void setIndexNameFunction(IndexNameFunction indexNameFunction) {
        this.indexNameFunction = indexNameFunction;
    }

    public boolean isLogEventDescription() {
        return this.logEventDescription;
    }

    public void setLogEventDescription(boolean logEventDescription) {
        this.logEventDescription = logEventDescription;
    }

    public boolean isLogAllEvents() {
        return this.logAllEvents;
    }

    public void setLogAllEvents(boolean logAllEvents) {
        this.logAllEvents = logAllEvents;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        if (threads > 0) {
            this.threads = threads;
            this.executor.setCorePoolSize(threads);
            this.executor.setMaximumPoolSize(threads);
        } else {
            this.setThreads(DEFAULT_NUMBER_OF_THREADS);
        }
    }

    public NodeCache getNodeCache() {
        return this.nodeCache;
    }

    public void setNodeCache(NodeCache cache) {
        this.nodeCache = cache;
    }

    public RestClientFactory getRestClientFactory() {
        return this.restClientFactory;
    }

    public void setRestClientFactory(RestClientFactory restClientFactory) {
        this.restClientFactory = restClientFactory;
    }

    public boolean getArchiveAlarms() {
        return this.archiveAlarms;
    }

    public void setArchiveAlarms(boolean archiveAlarms) {
        this.archiveAlarms = archiveAlarms;
    }

    public boolean getArchiveAlarmChangeEvents() {
        return this.archiveAlarmChangeEvents;
    }

    public void setArchiveAlarmChangeEvents(boolean archiveAlarmChangeEvents) {
        this.archiveAlarmChangeEvents = archiveAlarmChangeEvents;
    }

    public boolean getArchiveRawEvents() {
        return this.archiveRawEvents;
    }

    public void setArchiveRawEvents(boolean archiveRawEvents) {
        this.archiveRawEvents = archiveRawEvents;
    }

    public boolean getArchiveOldAlarmValues() {
        return this.archiveOldAlarmValues;
    }

    public void setArchiveOldAlarmValues(boolean archiveOldAlarmValues) {
        this.archiveOldAlarmValues = archiveOldAlarmValues;
    }

    public boolean getArchiveNewAlarmValues() {
        return this.archiveNewAlarmValues;
    }

    public void setArchiveNewAlarmValues(boolean archiveNewAlarmValues) {
        this.archiveNewAlarmValues = archiveNewAlarmValues;
    }

    public void setGroupOidParameters(boolean groupOidParameters) {
        this.groupOidParameters = groupOidParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JestClient getJestClient() {
        if (this.jestClient == null) {
            EventToIndex eventToIndex = this;
            synchronized (eventToIndex) {
                if (this.jestClient == null) {
                    if (this.restClientFactory == null) {
                        throw new RuntimeException("JestClientFactory must be set");
                    }
                    this.jestClient = this.restClientFactory.getJestClient();
                }
            }
        }
        return this.jestClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeJestClient() {
        if (this.jestClient != null) {
            EventToIndex eventToIndex = this;
            synchronized (eventToIndex) {
                try {
                    this.jestClient.shutdownClient();
                }
                catch (Throwable e) {
                    LOG.warn("Unexpected exception while shutting down REST client", e);
                }
                this.jestClient = null;
            }
        }
    }

    @Override
    public void close() {
        this.closeJestClient();
        this.executor.shutdown();
    }

    public void forwardEvents(List<Event> events) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(events).thenApplyAsync(this::convertEventsToEsActions, (Executor)this.executor)).exceptionally(e -> {
            LOG.error("Unexpected exception during task execution: " + e.getMessage(), e);
            return null;
        })).thenAcceptAsync(this::sendEvents, (Executor)this.executor)).exceptionally(e -> {
            LOG.error("Unexpected exception during task completion: " + e.getMessage(), e);
            return null;
        });
    }

    private void sendEvents(List<BulkableAction<DocumentResult>> actions) {
        if (actions != null && actions.size() > 0) {
            for (Map.Entry<String, List<BulkableAction>> entry : actions.stream().collect(Collectors.groupingBy(DocumentTargetedAction::getIndex)).entrySet()) {
                try {
                    List<BulkableAction> actionList = entry.getValue();
                    if (entry.getValue().size() == 1) {
                        BulkableAction action = actionList.get(0);
                        EventToIndex.executeSingleAction(this.getJestClient(), (BulkableAction<DocumentResult>)action);
                        continue;
                    }
                    String type = actionList.get(0).getType();
                    Bulk.Builder builder = new Bulk.Builder().defaultIndex(entry.getKey()).defaultType(type);
                    builder.addAction(actionList);
                    Bulk bulk = builder.build();
                    BulkResult result = (BulkResult)this.getJestClient().execute((Action)bulk);
                    if (result == null || !result.isSucceeded()) {
                        if (result == null) {
                            EventToIndex.logEsError("Bulk API action", entry.getKey(), type, null, -1, null);
                        } else {
                            EventToIndex.logEsError("Bulk API action", entry.getKey(), type, result.getJsonString(), result.getResponseCode(), result.getErrorMessage());
                        }
                        for (BulkableAction action : entry.getValue()) {
                            EventToIndex.executeSingleAction(this.getJestClient(), (BulkableAction<DocumentResult>)action);
                        }
                        continue;
                    }
                    List items = result.getItems();
                    boolean all404s = true;
                    for (BulkResult.BulkResultItem item : items) {
                        if (item.status == 404) continue;
                        all404s = false;
                        break;
                    }
                    if (all404s) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("index name " + entry.getKey() + " doesn't exist, creating new index");
                        }
                        EventToIndex.createIndex(this.getJestClient(), entry.getKey(), type);
                        result = (BulkResult)this.getJestClient().execute((Action)bulk);
                    }
                    if (result == null || !result.isSucceeded()) {
                        if (result == null) {
                            EventToIndex.logEsError("Bulk API action", entry.getKey(), type, null, -1, null);
                        } else {
                            EventToIndex.logEsError("Bulk API action", entry.getKey(), type, result.getJsonString(), result.getResponseCode(), result.getErrorMessage());
                        }
                        for (BulkableAction action : entry.getValue()) {
                            EventToIndex.executeSingleAction(this.getJestClient(), (BulkableAction<DocumentResult>)action);
                        }
                        continue;
                    }
                    for (BulkResult.BulkResultItem item : result.getItems()) {
                        if (item.status >= 200 && item.status < 300) {
                            if (!LOG.isDebugEnabled()) continue;
                            EventToIndex.logEsDebug(item.operation, entry.getKey(), item.type, "none", item.status, item.error);
                            continue;
                        }
                        EventToIndex.logEsError(item.operation, entry.getKey(), item.type, "none", item.status, item.error);
                    }
                }
                catch (Throwable ex) {
                    LOG.error("Unexpected problem sending event to Elasticsearch", ex);
                    this.closeJestClient();
                }
            }
        }
    }

    private static final void logEsError(String operation, String index, String type, String result, int responseCode, String errorMessage) {
        LOG.error("Error while performing {} on Elasticsearch index: {}, type: {}\n   received result: {}\n   response code: {}\n   error message: {}", new Object[]{operation, index, type, result, responseCode, errorMessage});
    }

    private static final void logEsDebug(String operation, String index, String type, String result, int responseCode, String errorMessage) {
        LOG.debug("Performed {} on Elasticsearch index: {}, type: {}\n   received result: {}\n   response code: {}\n   error message: {}", new Object[]{operation, index, type, result, responseCode, errorMessage});
    }

    private static void executeSingleAction(JestClient client, BulkableAction<DocumentResult> action) throws IOException {
        DocumentResult result = (DocumentResult)client.execute(action);
        if (result == null || result.getResponseCode() == 404) {
            if (LOG.isDebugEnabled()) {
                if (result == null) {
                    EventToIndex.logEsDebug(action.getRestMethodName(), action.getIndex(), action.getType(), null, -1, null);
                } else {
                    EventToIndex.logEsDebug(action.getRestMethodName(), action.getIndex(), action.getType(), result.getJsonString(), result.getResponseCode(), result.getErrorMessage());
                }
                LOG.debug("index name " + action.getIndex() + " doesn't exist, creating new index");
            }
            EventToIndex.createIndex(client, action.getIndex(), action.getType());
            result = (DocumentResult)client.execute(action);
        }
        if (result == null) {
            EventToIndex.logEsError(action.getRestMethodName(), action.getIndex(), action.getType(), null, -1, null);
        } else if (!result.isSucceeded()) {
            EventToIndex.logEsError(action.getRestMethodName(), action.getIndex(), action.getType(), result.getJsonString(), result.getResponseCode(), result.getErrorMessage());
        } else if (LOG.isDebugEnabled()) {
            EventToIndex.logEsDebug(action.getRestMethodName(), action.getIndex(), action.getType(), result.getJsonString(), result.getResponseCode(), result.getErrorMessage());
        }
    }

    private List<BulkableAction<DocumentResult>> convertEventsToEsActions(List<Event> events) {
        ArrayList<BulkableAction<DocumentResult>> retval = new ArrayList<BulkableAction<DocumentResult>>();
        for (Event event : events) {
            Index eventIndex;
            this.maybeRefreshCache(event);
            String uei = event.getUei();
            if (uei.startsWith(ALARM_NOTIFICATION_UEI_STEM)) {
                if (STICKY_MEMO_EVENT.equals(uei) || JOURNAL_MEMO_EVENT.equals(uei)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending Alarm MEMO Event to ES:" + event.toString());
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        if (ALARM_CREATED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Created Event to ES:" + event.toString());
                        } else if (ALARM_DELETED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Deleted Event to ES:" + event.toString());
                        } else if (ALARM_SEVERITY_CHANGED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Changed Severity Event to ES:" + event.toString());
                        } else if (ALARM_CLEARED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Cleared Event to ES:" + event.toString());
                        } else if (ALARM_ACKNOWLEDGED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Acknowledged Event to ES:" + event.toString());
                        } else if (ALARM_UNACKNOWLEDGED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Unacknowledged Event to ES:" + event.toString());
                        } else if (ALARM_SUPPRESSED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Suppressed Event to ES:" + event.toString());
                        } else if (ALARM_UNSUPPRESSED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Unsuppressed Event to ES:" + event.toString());
                        } else if (ALARM_TROUBLETICKET_STATE_CHANGE_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm TroubleTicked state changed Event to ES:" + event.toString());
                        } else if (ALARM_CHANGED_EVENT.equals(uei)) {
                            LOG.debug("Sending Alarm Changed Event to ES:" + event.toString());
                        }
                    }
                    if (this.archiveAlarms) {
                        Update alarmUpdate = this.populateAlarmIndexBodyFromAlarmChangeEvent(event, INDEX_NAMES.get((Object)Indices.ALARMS), INDEX_TYPES.get((Object)Indices.ALARMS));
                        retval.add((BulkableAction<DocumentResult>)alarmUpdate);
                    }
                }
                if (!this.archiveAlarmChangeEvents) continue;
                eventIndex = this.populateEventIndexBodyFromEvent(event, INDEX_NAMES.get((Object)Indices.ALARM_EVENTS), INDEX_TYPES.get((Object)Indices.ALARM_EVENTS));
                retval.add((BulkableAction<DocumentResult>)eventIndex);
                continue;
            }
            if (!this.archiveRawEvents) continue;
            if (this.logAllEvents || event.getDbid() != null && event.getDbid() != 0) {
                eventIndex = this.populateEventIndexBodyFromEvent(event, INDEX_NAMES.get((Object)Indices.EVENTS), INDEX_TYPES.get((Object)Indices.EVENTS));
                retval.add((BulkableAction<DocumentResult>)eventIndex);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Not Sending Event to ES: null event.getDbid()=" + event.getDbid() + " Event=" + event.toString());
        }
        return retval;
    }

    public Index populateEventIndexBodyFromEvent(Event event, String rootIndexName, String indexType) {
        JSONObject body = new JSONObject();
        Integer id = event.getDbid() == null ? null : event.getDbid();
        body.put((Object)"id", (Object)Integer.toString(id));
        body.put((Object)"eventuei", (Object)event.getUei());
        Calendar cal = Calendar.getInstance();
        if (event.getTime() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("using local time because no event creation time for event.toString: " + event.toString());
            }
            cal.setTime(new Date());
        } else {
            cal.setTime(event.getTime());
        }
        body.put((Object)"@timestamp", (Object)DatatypeConverter.printDateTime((Calendar)cal));
        body.put((Object)"dow", (Object)Integer.toString(cal.get(7)));
        body.put((Object)"hour", (Object)Integer.toString(cal.get(11)));
        body.put((Object)"dom", (Object)Integer.toString(cal.get(5)));
        body.put((Object)"eventsource", (Object)event.getSource());
        body.put((Object)"ipaddr", event.getInterfaceAddress() != null ? event.getInterfaceAddress().toString() : null);
        body.put((Object)"servicename", (Object)event.getService());
        body.put((Object)"eventseverity_text", (Object)event.getSeverity());
        body.put((Object)"eventseverity", (Object)Integer.toString(OnmsSeverity.get((String)event.getSeverity()).getId()));
        if (this.isLogEventDescription()) {
            body.put((Object)"eventdescr", (Object)event.getDescr());
        }
        body.put((Object)"host", (Object)event.getHost());
        JSONParser jsonParser = new JSONParser();
        this.handleParameters(event, body);
        if (!this.archiveNewAlarmValues) {
            body.remove((Object)"p_oldalarmvalues");
        }
        if (!this.archiveOldAlarmValues) {
            body.remove((Object)"p_newalarmvalues");
        }
        body.put((Object)"interface", (Object)event.getInterface());
        body.put((Object)"logmsg", event.getLogmsg() != null ? event.getLogmsg().getContent() : null);
        body.put((Object)"logmsgdest", event.getLogmsg() != null ? event.getLogmsg().getDest() : null);
        if (event.getNodeid() != null) {
            body.put((Object)"nodeid", (Object)Long.toString(event.getNodeid()));
            if (body.containsKey((Object)"p_nodelabel")) {
                body.put((Object)NODE_LABEL_PARAM, body.get((Object)"p_nodelabel"));
            } else if (this.nodeCache != null) {
                Map<String, String> nodedetails = this.nodeCache.getEntry(event.getNodeid());
                Iterator<String> iterator = nodedetails.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    String keyStr = key = iterator.next();
                    String value = nodedetails.get(key);
                    body.put((Object)keyStr, (Object)value);
                }
            }
        }
        String completeIndexName = this.indexNameFunction.apply(rootIndexName, cal.getTime());
        if (LOG.isDebugEnabled()) {
            String str = "populateEventIndexBodyFromEvent - index:/" + completeIndexName + "/" + indexType + "/" + id + "\n   body: \n" + body.toJSONString();
            LOG.debug(str);
        }
        Index.Builder builder = (Index.Builder)((Index.Builder)new Index.Builder((Object)body).index(completeIndexName)).type(indexType);
        if (id > 0) {
            builder = (Index.Builder)builder.id(Integer.toString(id));
        }
        Index index = builder.build();
        return index;
    }

    private void handleParameters(Event event, JSONObject body) {
        if (this.groupOidParameters) {
            List oidParameters = event.getParmCollection().stream().filter(p -> EventToIndex.isOID(p.getParmName())).collect(Collectors.toList());
            List normalParameters = event.getParmCollection();
            normalParameters.removeAll(oidParameters);
            this.handleParameters(event, normalParameters, body);
            if (!oidParameters.isEmpty()) {
                JSONArray jsonArray = new JSONArray();
                for (Parm eachOid : oidParameters) {
                    JSONObject eachOidObject = new JSONObject();
                    eachOidObject.put((Object)"oid", (Object)eachOid.getParmName());
                    eachOidObject.put((Object)"value", (Object)eachOid.getValue().getContent());
                    jsonArray.add((Object)eachOidObject);
                }
                body.put((Object)"p_oids", (Object)jsonArray);
            }
        } else {
            this.handleParameters(event, event.getParmCollection(), body);
        }
    }

    private void handleParameters(Event event, List<Parm> parameters, JSONObject body) {
        JSONParser jsonParser = new JSONParser();
        for (Parm parm : parameters) {
            String parmName = "p_" + parm.getParmName().replaceAll("\\.", "_");
            if ("json".equalsIgnoreCase(parm.getValue().getType())) {
                try {
                    JSONObject tmpJson = (JSONObject)jsonParser.parse(parm.getValue().getContent());
                    body.put((Object)parmName, (Object)tmpJson);
                }
                catch (ParseException ex) {
                    LOG.error("Cannot parse parameter content '{}' of parameter '{}' from eventid {} to json: {}", new Object[]{parm.getValue().getContent(), parm.getParmName(), event.getDbid(), ex.getMessage(), ex});
                    body.put((Object)parmName, (Object)parm.getValue().getContent());
                }
                continue;
            }
            body.put((Object)parmName, (Object)parm.getValue().getContent());
        }
    }

    public Update populateAlarmIndexBodyFromAlarmChangeEvent(Event event, String rootIndexName, String indexType) {
        Calendar alarmCreationCal;
        String key;
        Object obj;
        Update update = null;
        HashMap<String, String> body = new HashMap<String, String>();
        HashMap<String, String> parmsMap = new HashMap<String, String>();
        for (Parm parm : event.getParmCollection()) {
            parmsMap.put(parm.getParmName(), parm.getValue().getContent());
        }
        String oldValuesStr = (String)parmsMap.get(OLD_ALARM_VALUES_PARAM);
        String newValuesStr = (String)parmsMap.get(NEW_ALARM_VALUES_PARAM);
        if (LOG.isDebugEnabled()) {
            LOG.debug("AlarmChangeEvent from eventid " + event.getDbid() + "\n  newValuesStr=" + newValuesStr + "\n  oldValuesStr=" + oldValuesStr);
        }
        JSONObject alarmValues = null;
        JSONObject newAlarmValues = null;
        JSONObject oldAlarmValues = null;
        JSONParser parser = new JSONParser();
        if (newValuesStr != null) {
            try {
                obj = parser.parse(newValuesStr);
                newAlarmValues = (JSONObject)obj;
            }
            catch (ParseException e1) {
                LOG.error("cannot parse newValuesStr from eventid " + event.getDbid() + " to json object. newValuesStr=" + newValuesStr, (Throwable)e1);
            }
        }
        if (newAlarmValues != null && !newAlarmValues.isEmpty()) {
            alarmValues = newAlarmValues;
        } else {
            if (oldValuesStr == null) {
                LOG.error("newValuesStr and oldValuesStr both empty in AlarmChangeEvent from eventid " + event.getDbid() + "\n  newValuesStr=" + newValuesStr + "\n  oldValuesStr=" + oldValuesStr);
                return null;
            }
            try {
                obj = parser.parse(oldValuesStr);
                oldAlarmValues = (JSONObject)obj;
            }
            catch (ParseException e1) {
                LOG.error("cannot parse oldValuesStr from eventid " + event.getDbid() + " to json object. oldValuesStr=" + oldValuesStr, (Throwable)e1);
                return null;
            }
            if (!oldAlarmValues.isEmpty()) {
                alarmValues = oldAlarmValues;
            } else {
                LOG.error("oldValuesStr and newValuesStr both empty in AlarmChangeEvent from eventid " + event.getDbid() + "\n  newValuesStr=" + newValuesStr + "\n  oldValuesStr=" + oldValuesStr);
                return null;
            }
        }
        for (Object x : alarmValues.keySet()) {
            String value;
            key = (String)x;
            String string = value = alarmValues.get((Object)key) == null ? null : alarmValues.get((Object)key).toString();
            if (EVENT_PARAMS.equals(key) && value != null) {
                List params = EventParameterUtils.decode((String)value);
                for (Object parm : params) {
                    body.put("p_" + parm.getParmName(), parm.getValue().getContent());
                }
                continue;
            }
            if (ALARM_SEVERITY_PARAM.equals(key) && value != null) {
                try {
                    int id = Integer.parseInt(value);
                    String label = OnmsSeverity.get((int)id).getLabel();
                    body.put(SEVERITY, value);
                    body.put(SEVERITY_TEXT, label);
                }
                catch (Exception e) {
                    LOG.error("cannot parse severity for alarm change event id" + event.getDbid());
                }
                continue;
            }
            body.put(key, value);
        }
        if (ALARM_CREATED_EVENT.equals(event.getUei())) {
            body.put(ALARM_CLEAR_TIME, null);
            body.put(ALARM_DELETED_TIME, null);
        }
        if (ALARM_CLEARED_EVENT.equals(event.getUei())) {
            Calendar alarmClearCal = Calendar.getInstance();
            alarmClearCal.setTime(event.getTime());
            body.put(ALARM_CLEAR_TIME, DatatypeConverter.printDateTime((Calendar)alarmClearCal));
            try {
                Date alarmclearDate = event.getTime();
                String alarmCreationTime = alarmValues.get((Object)FIRST_EVENT_TIME).toString();
                alarmCreationCal = DatatypeConverter.parseDateTime((String)alarmCreationTime);
                Date alarmCreationDate = alarmCreationCal.getTime();
                Long duration = alarmclearDate.getTime() - alarmCreationDate.getTime();
                body.put(ALARM_CLEAR_DURATION, duration.toString());
            }
            catch (Exception e) {
                LOG.error("problem calculating alarm clear duration for event " + event.getDbid(), (Throwable)e);
            }
        }
        if (ALARM_DELETED_EVENT.equals(event.getUei())) {
            Calendar alarmDeletionCal = Calendar.getInstance();
            alarmDeletionCal.setTime(event.getTime());
            body.put(ALARM_DELETED_TIME, DatatypeConverter.printDateTime((Calendar)alarmDeletionCal));
        }
        if (ALARM_ACKNOWLEDGED_EVENT.equals(event.getUei())) {
            try {
                Date alarmAckDate = event.getTime();
                String alarmCreationTime = alarmValues.get((Object)FIRST_EVENT_TIME).toString();
                Calendar alarmCreationCal2 = DatatypeConverter.parseDateTime((String)alarmCreationTime);
                Date alarmCreationDate = alarmCreationCal2.getTime();
                Long duration = alarmAckDate.getTime() - alarmCreationDate.getTime();
                body.put(ALARM_ACK_DURATION, duration.toString());
            }
            catch (Exception e) {
                LOG.error("problem calculating alarm acknowledge duration for event " + event.getDbid(), (Throwable)e);
            }
        }
        if (parmsMap.get(ALARM_ACK_TIME_PARAM) == null || "".equals(parmsMap.get(ALARM_ACK_TIME_PARAM))) {
            body.put(ALARM_ACK_TIME_PARAM, null);
            body.put(ALARM_ACK_USER_PARAM, null);
        }
        if (parmsMap.get(INITIAL_SEVERITY_PARAM) != null) {
            try {
                String severityId = (String)parmsMap.get(INITIAL_SEVERITY_PARAM);
                int id = Integer.parseInt(severityId);
                String label = OnmsSeverity.get((int)id).getLabel();
                body.put(INITIAL_SEVERITY_PARAM, severityId);
                body.put(INITIAL_SEVERITY_PARAM_TEXT, label);
            }
            catch (Exception e) {
                LOG.error("cannot parse initial severity for alarm change event id" + event.getDbid());
            }
        }
        if (parmsMap.get(NODE_LABEL_PARAM) != null) {
            body.put(NODE_LABEL_PARAM, (String)parmsMap.get(NODE_LABEL_PARAM));
        } else if (this.nodeCache != null && event.getNodeid() != null) {
            Map<String, String> nodedetails = this.nodeCache.getEntry(event.getNodeid());
            Iterator<String> id = nodedetails.keySet().iterator();
            while (id.hasNext()) {
                String keyStr = key = id.next();
                String value = nodedetails.get(key);
                body.put(keyStr, value);
            }
        }
        if (alarmValues.get((Object)MEMO_ALARMID_PARAM) == null) {
            LOG.error("No alarmid param - cannot create alarm Elasticsearch record from event content:" + event.toString());
        } else {
            String id = alarmValues.get((Object)MEMO_ALARMID_PARAM).toString();
            body.put("p_alarmid", id);
            String alarmCreationTime = null;
            Date alarmCreationDate = null;
            alarmCreationCal = null;
            try {
                alarmCreationTime = alarmValues.get((Object)FIRST_EVENT_TIME).toString();
                alarmCreationCal = DatatypeConverter.parseDateTime((String)alarmCreationTime);
            }
            catch (Exception e) {
                LOG.error("using current Date() for @timestamp because problem creating date from alarmchange event " + event.getDbid() + " from firsteventtime=" + alarmCreationTime, (Throwable)e);
            }
            if (alarmCreationCal == null) {
                alarmCreationCal = Calendar.getInstance();
                alarmCreationCal.setTime(new Date());
            }
            body.put("@timestamp", DatatypeConverter.printDateTime((Calendar)alarmCreationCal));
            body.put("dow", Integer.toString(alarmCreationCal.get(7)));
            body.put("hour", Integer.toString(alarmCreationCal.get(11)));
            body.put("dom", Integer.toString(alarmCreationCal.get(5)));
            alarmCreationDate = alarmCreationCal.getTime();
            String completeIndexName = this.indexNameFunction.apply(rootIndexName, alarmCreationDate);
            if (LOG.isDebugEnabled()) {
                String str = "populateAlarmIndexBodyFromAlarmChangeEvent - index:/" + completeIndexName + "/" + indexType + "/" + id + "\n   body: ";
                for (String key2 : body.keySet()) {
                    str = str + "[" + key2 + " : " + (String)body.get(key2) + "]";
                }
                LOG.debug(str);
            }
            JSONObject doc = new JSONObject(body);
            JSONObject updateQuery = new JSONObject();
            updateQuery.put((Object)"doc", (Object)doc);
            updateQuery.put((Object)"doc_as_upsert", (Object)true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("update query sent:" + updateQuery.toJSONString());
            }
            update = ((Update.Builder)((Update.Builder)((Update.Builder)new Update.Builder((Object)updateQuery.toJSONString()).index(completeIndexName)).type(indexType)).id(id)).build();
        }
        return update;
    }

    private void maybeRefreshCache(Event event) {
        String uei = event.getUei();
        if (uei != null && uei.startsWith("uei.opennms.org/nodes/") && (uei.endsWith("Added") || uei.endsWith("Deleted") || uei.endsWith("Updated") || uei.endsWith("Changed"))) {
            this.nodeCache.refreshEntry(event.getNodeid());
        }
    }

    private static void createIndex(JestClient client, String name, String type) throws IOException {
        CreateIndex createIndex = new CreateIndex.Builder(name).build();
        OnmsJestResult result = new OnmsJestResult(client.execute((Action)createIndex));
        if (LOG.isDebugEnabled()) {
            LOG.debug("created new alarm index: {} type: {}\n   received search result: {}\n   response code: {}\n   error message: {}", new Object[]{name, type, result.getJsonString(), result.getResponseCode(), result.getErrorMessage()});
        }
    }

    public static boolean isOID(String input) {
        return input.matches("^(\\.[0-9]+)+$");
    }

    public static enum Indices {
        ALARMS,
        ALARM_EVENTS,
        EVENTS;

    }
}

