/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import com.google.common.base.Strings;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.config.HttpClientConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpHost;
import org.opennms.core.utils.TimeoutTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientFactory.class);
    private final JestClientFactory factory;
    private final HttpClientConfig.Builder configBuilder;
    private AtomicInteger m_socketTimeout = new AtomicInteger(0);
    private AtomicInteger m_timeout = new AtomicInteger(0);
    private AtomicInteger m_retries = new AtomicInteger(0);

    public RestClientFactory(String elasticSearchURL, String esusername, String espassword) throws MalformedURLException {
        List<String> targetHosts = Arrays.asList(elasticSearchURL.split(","));
        this.configBuilder = (HttpClientConfig.Builder)new HttpClientConfig.Builder(targetHosts).multiThreaded(true);
        if (!Strings.isNullOrEmpty((String)esusername) && !Strings.isNullOrEmpty((String)espassword)) {
            URL targetUrl = new URL(targetHosts.get(0));
            if (targetHosts.size() > 1) {
                LOG.warn("Credentials have been defined, but multiple target hosts were found. Each host will use the same credentials. Preemptive auth is only enabled for host {}", (Object)targetHosts.get(0));
            }
            this.configBuilder.defaultCredentials(esusername, espassword);
            this.configBuilder.setPreemptiveAuth(new HttpHost(targetUrl.getHost(), targetUrl.getPort(), targetUrl.getProtocol()));
        }
        this.factory = new JestClientFactory();
        this.factory.setHttpClientConfig(this.configBuilder.build());
    }

    public int getRetries() {
        return this.m_retries.get();
    }

    public void setRetries(int retries) {
        this.m_retries.set(retries);
    }

    public int getSocketTimeout() {
        return this.m_socketTimeout.get();
    }

    public void setSocketTimeout(int timeout) {
        this.m_socketTimeout.set(timeout);
        this.factory.setHttpClientConfig(((HttpClientConfig.Builder)this.configBuilder.readTimeout(timeout)).build());
    }

    public int getTimeout() {
        return this.m_timeout.get();
    }

    public void setTimeout(int timeout) {
        this.m_timeout.set(timeout);
        this.factory.setHttpClientConfig(((HttpClientConfig.Builder)this.configBuilder.connTimeout(timeout)).build());
    }

    public JestClient getJestClient() {
        return new OnmsJestClient(this.factory.getObject(), this.getTimeout(), this.getRetries());
    }

    private static class OnmsJestClient
    implements JestClient {
        private static final Logger LOG = LoggerFactory.getLogger(OnmsJestClient.class);
        private final JestClient m_delegate;
        private final int m_retries;
        private final int m_timeout;

        public OnmsJestClient(JestClient delegate, int timeout, int retries) {
            this.m_delegate = delegate;
            this.m_timeout = timeout;
            this.m_retries = retries;
        }

        public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("strict-timeout", Boolean.TRUE);
            TimeoutTracker timeoutTracker = new TimeoutTracker(params, this.m_retries, this.m_timeout);
            timeoutTracker.reset();
            while (timeoutTracker.shouldRetry()) {
                timeoutTracker.startAttempt();
                try {
                    return (T)this.m_delegate.execute(clientRequest);
                }
                catch (Exception e) {
                    LOG.warn("Exception while trying to execute REST operation (attempt {})", (Object)(timeoutTracker.getAttempt() + 1), (Object)e);
                    timeoutTracker.nextAttempt();
                }
            }
            return null;
        }

        public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> jestResultHandler) {
            this.m_delegate.executeAsync(clientRequest, jestResultHandler);
        }

        public void shutdownClient() {
            this.m_delegate.shutdownClient();
        }

        public void setServers(Set<String> servers) {
            this.m_delegate.setServers(servers);
        }
    }
}

