/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.archive.cmd;

import java.net.URL;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.plugins.elasticsearch.rest.archive.OpenNMSHistoricEventsToEs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="elasticsearch", name="send-historic-events", description="Sends events in selected OpenNMS to Elasticsearch")
@org.apache.karaf.shell.commands.Command(scope="elasticsearch", name="send-historic-events", description="Sends events in selected OpenNMS to Elasticsearch")
@Service
public class SendEventsToEsCommand
extends OsgiCommandSupport
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(SendEventsToEsCommand.class);
    @Reference
    private OpenNMSHistoricEventsToEs openNMSHistoricEventsToEs;
    @Argument(index=0, name="limit", description="Limit number of events to send", required=true, multiValued=false)
    String limit = null;
    @Argument(index=1, name="offset", description="Offset for starting events", required=true, multiValued=false)
    String offset = null;
    @Argument(index=2, name="onms-username", description="rest password for opennms", required=false, multiValued=false)
    String onmsUserName = null;
    @Argument(index=3, name="onms-password", description="rest username for opennms", required=false, multiValued=false)
    String onmsPassWord = null;
    @Argument(index=4, name="onms-url", description="URL of OpenNMS ReST interface to retrieve events to send", required=false, multiValued=false)
    String onmsUrl = null;
    @Argument(index=5, name="use-node-label", description="If false local node cache will get nodelabel for nodeid. If true will use remote nodelabel", required=false, multiValued=false)
    String useNodelabel = "false";

    public Object execute() throws Exception {
        try {
            if (this.offset != null) {
                this.openNMSHistoricEventsToEs.setOffset(Integer.valueOf(this.offset));
            }
            if (this.limit != null) {
                this.openNMSHistoricEventsToEs.setLimit(Integer.valueOf(this.limit));
            }
            if (this.onmsPassWord != null) {
                this.openNMSHistoricEventsToEs.setOnmsPassWord(this.onmsPassWord);
            }
            if (this.onmsUserName != null) {
                this.openNMSHistoricEventsToEs.setOnmsUserName(this.onmsUserName);
            }
            if (this.onmsUrl != null) {
                URL url = new URL(this.onmsUrl);
                this.openNMSHistoricEventsToEs.setOnmsUrl(this.onmsUrl);
            }
            if (this.useNodelabel != null) {
                this.openNMSHistoricEventsToEs.setUseNodeLabel(Boolean.valueOf(this.useNodelabel));
            }
            String msg = "Sending events to Elasticsearch. \n Limit =" + this.openNMSHistoricEventsToEs.getLimit() + "\n Offset =" + this.openNMSHistoricEventsToEs.getOffset() + "\n Retreiving events from OpenNMS URL=" + this.openNMSHistoricEventsToEs.getOnmsUrl() + "\n OpenNMS Username=" + this.openNMSHistoricEventsToEs.getOnmsUserName() + "\n OpenNMS Password=" + this.openNMSHistoricEventsToEs.getOnmsPassWord() + "\n Use Node Label=" + this.openNMSHistoricEventsToEs.getUseNodeLabel();
            LOG.info(msg);
            System.out.println(msg);
            msg = this.openNMSHistoricEventsToEs.sendEventsToEs();
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("Error Sending Historical Events to ES (see karaf log) " + ExceptionUtils.getStackTrace((Throwable)e));
            LOG.error("Error Sending Historical Events to ES ", (Throwable)e);
        }
        return null;
    }

    @Deprecated
    protected Object doExecute() throws Exception {
        return this.execute();
    }

    @Deprecated
    public void setOpenNMSHistoricEventsToEs(OpenNMSHistoricEventsToEs openNMSHistoricEventsToEs) {
        this.openNMSHistoricEventsToEs = openNMSHistoricEventsToEs;
    }
}

