/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opennms.core.ipc.sink.aggregation.AggregatingMessageProducer;
import org.opennms.core.ipc.sink.aggregation.ArrayListAggregationPolicy;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.plugins.elasticsearch.rest.ElasticSearchInitialiser;
import org.opennms.plugins.elasticsearch.rest.EventToIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventForwarderQueueImpl
implements EventForwarder,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EventForwarderQueueImpl.class);
    private AggregatingMessageProducer<Event, List<Event>> producer;
    private EventToIndex eventToIndex = null;
    private ElasticSearchInitialiser elasticSearchInitialiser = null;
    private int batchSize = 1;
    private int batchInterval = 0;

    public EventToIndex getEventToIndex() {
        return this.eventToIndex;
    }

    public void setEventToIndex(EventToIndex eventToIndex) {
        this.eventToIndex = eventToIndex;
    }

    public void sendNow(Event event) {
        if (this.elasticSearchInitialiser != null && this.elasticSearchInitialiser.isInitialised()) {
            this.producer.send((Object)event);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not sending event received: Elasticsearch is not initialised\n   event:" + event.toString());
        }
    }

    public void sendNow(Log eventLog) {
        if (eventLog != null && eventLog.getEvents() != null) {
            for (Event event : eventLog.getEvents().getEvent()) {
                this.sendNow(event);
            }
        }
    }

    public void sendNowSync(Event event) {
        this.producer.dispatch(Collections.singletonList(event));
    }

    public void sendNowSync(Log eventLog) {
        if (eventLog != null && eventLog.getEvents() != null) {
            this.producer.dispatch(Arrays.asList(eventLog.getEvents().getEvent()));
        }
    }

    public void init() {
        this.producer = new EventIndexProducer(this.batchSize, this.batchInterval);
    }

    @Override
    public void close() throws Exception {
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchInterval() {
        return this.batchInterval;
    }

    public void setBatchInterval(int batchInterval) {
        this.batchInterval = batchInterval;
    }

    public ElasticSearchInitialiser getElasticSearchInitialiser() {
        return this.elasticSearchInitialiser;
    }

    public void setElasticSearchInitialiser(ElasticSearchInitialiser elasticSearchInitialiser) {
        this.elasticSearchInitialiser = elasticSearchInitialiser;
    }

    private class EventIndexProducer
    extends AggregatingMessageProducer<Event, List<Event>> {
        public EventIndexProducer(int batchSize, int batchInterval) {
            super(EventIndexProducer.class.getName(), (AggregationPolicy)new ArrayListAggregationPolicy(batchSize, batchInterval, e -> "event"));
        }

        public void dispatch(List<Event> events) {
            if (EventForwarderQueueImpl.this.eventToIndex != null) {
                EventForwarderQueueImpl.this.eventToIndex.forwardEvents(events);
            } else {
                LOG.error("cannot send event, eventToIndex is null");
            }
        }
    }
}

