/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import java.util.Collections;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.plugins.elasticsearch.rest.EventToIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventForwarderImpl
implements EventForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(EventForwarderImpl.class);
    private EventToIndex eventToIndex = null;

    public EventToIndex getEventToIndex() {
        return this.eventToIndex;
    }

    public void setEventToIndex(EventToIndex eventToIndex) {
        this.eventToIndex = eventToIndex;
    }

    public void sendNow(Event event) {
        LOG.debug("Event to send received: " + event.toString());
        if (this.eventToIndex != null) {
            this.eventToIndex.forwardEvents(Collections.singletonList(event));
        }
    }

    public void sendNow(Log eventLog) {
        if (eventLog != null && eventLog.getEvents() != null) {
            for (Event event : eventLog.getEvents().getEvent()) {
                this.sendNow(event);
            }
        }
    }

    public void sendNowSync(Event event) {
        this.sendNow(event);
    }

    public void sendNowSync(Log eventLog) {
        this.sendNow(eventLog);
    }
}

