/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.config.HttpClientConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.utils.TimeoutTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientFactory {
    private final JestClientFactory factory;
    private HttpClientConfig config;
    private AtomicInteger m_socketTimeout = new AtomicInteger(0);
    private AtomicInteger m_timeout = new AtomicInteger(0);
    private AtomicInteger m_retries = new AtomicInteger(0);

    public RestClientFactory(String elasticSearchURL, String esusername, String espassword) {
        this.config = ((HttpClientConfig.Builder)new HttpClientConfig.Builder(Arrays.asList(elasticSearchURL.split(","))).multiThreaded(true)).defaultCredentials(esusername, espassword).build();
        this.factory = new JestClientFactory();
        this.factory.setHttpClientConfig(this.config);
    }

    public int getRetries() {
        return this.m_retries.get();
    }

    public void setRetries(int retries) {
        this.m_retries.set(retries);
    }

    public int getSocketTimeout() {
        return this.m_socketTimeout.get();
    }

    public void setSocketTimeout(int timeout) {
        this.m_socketTimeout.set(timeout);
        this.config = ((HttpClientConfig.Builder)new HttpClientConfig.Builder(this.config).readTimeout(timeout)).build();
        this.factory.setHttpClientConfig(this.config);
    }

    public int getTimeout() {
        return this.m_timeout.get();
    }

    public void setTimeout(int timeout) {
        this.m_timeout.set(timeout);
        this.config = ((HttpClientConfig.Builder)new HttpClientConfig.Builder(this.config).connTimeout(timeout)).build();
        this.factory.setHttpClientConfig(this.config);
    }

    public JestClient getJestClient() {
        return new OnmsJestClient(this.factory.getObject(), this.getTimeout(), this.getRetries());
    }

    private static class OnmsJestClient
    implements JestClient {
        private static final Logger LOG = LoggerFactory.getLogger(OnmsJestClient.class);
        private final JestClient m_delegate;
        private final int m_retries;
        private final int m_timeout;

        public OnmsJestClient(JestClient delegate, int timeout, int retries) {
            this.m_delegate = delegate;
            this.m_timeout = timeout;
            this.m_retries = retries;
        }

        public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("strict-timeout", Boolean.TRUE);
            TimeoutTracker timeoutTracker = new TimeoutTracker(params, this.m_retries, this.m_timeout);
            timeoutTracker.reset();
            while (timeoutTracker.shouldRetry()) {
                timeoutTracker.startAttempt();
                try {
                    return (T)this.m_delegate.execute(clientRequest);
                }
                catch (Exception e) {
                    LOG.warn("Exception while trying to execute REST operation (attempt {})", (Object)(timeoutTracker.getAttempt() + 1), (Object)e);
                    timeoutTracker.nextAttempt();
                }
            }
            return null;
        }

        public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> jestResultHandler) {
            this.m_delegate.executeAsync(clientRequest, jestResultHandler);
        }

        public void shutdownClient() {
            this.m_delegate.shutdownClient();
        }

        public void setServers(Set<String> servers) {
            this.m_delegate.setServers(servers);
        }
    }
}

