/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import io.searchbox.core.Update;
import io.searchbox.indices.CreateIndex;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.plugins.elasticsearch.rest.IndexNameFunction;
import org.opennms.plugins.elasticsearch.rest.NodeCache;
import org.opennms.plugins.elasticsearch.rest.RestClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventToIndex {
    private static final Logger LOG = LoggerFactory.getLogger(EventToIndex.class);
    public static final String ALARM_INDEX_NAME = "opennms-alarms";
    public static final String ALARM_EVENT_INDEX_NAME = "opennms-events-alarmchange";
    public static final String EVENT_INDEX_NAME = "opennms-events-raw";
    public static final String ALARM_INDEX_TYPE = "alarmdata";
    public static final String EVENT_INDEX_TYPE = "eventdata";
    public static final String ALARM_NOTIFICATION_UEI_STEM = "uei.opennms.org/plugin/AlarmChangeNotificationEvent";
    public static final String ALARM_DELETED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmDeleted";
    public static final String ALARM_CREATED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/NewAlarmCreated";
    public static final String ALARM_SEVERITY_CHANGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmSeverityChanged";
    public static final String ALARM_CLEARED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmCleared";
    public static final String ALARM_ACKNOWLEDGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmAcknowledged";
    public static final String ALARM_UNACKNOWLEDGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmUnAcknowledged";
    public static final String ALARM_SUPPRESSED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmSuppressed";
    public static final String ALARM_UNSUPPRESSED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmUnSuppressed";
    public static final String ALARM_TROUBLETICKET_STATE_CHANGE_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/TroubleTicketStateChange";
    public static final String ALARM_CHANGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmChanged";
    public static final String OLD_ALARM_VALUES = "oldalarmvalues";
    public static final String NEW_ALARM_VALUES = "newalarmvalues";
    public static final String NODE_LABEL = "nodelabel";
    public static final String INITIAL_SEVERITY = "initialseverity";
    public static final String INITIAL_SEVERITY_TEXT = "initialseverity_text";
    public static final String SEVERITY_TEXT = "severity_text";
    public static final String SEVERITY = "severity";
    public static final String EVENT_PARAMS = "eventparms";
    public static final String ALARM_ACK_TIME = "alarmacktime";
    public static final String ALARM_ACK_USER = "alarmackuser";
    public static final String ALARM_CLEAR_TIME = "alarmcleartime";
    public static final String ALARM_DELETED_TIME = "alarmdeletedtime";
    public static final String STICKY_MEMO_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/StickyMemoUpdate";
    public static final String JOURNAL_MEMO_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/JournalMemoUpdate";
    public static final String MEMO_VALUES_PARAM = "memovalues";
    public static final String MEMO_ALARMID_PARAM = "alarmid";
    public static final String MEMO_BODY_PARAM = "body";
    public static final String MEMO_AUTHOR_PARAM = "author";
    public static final String MEMO_REDUCTIONKEY_PARAM = "reductionkey";
    private boolean logEventDescription = false;
    private boolean archiveRawEvents = true;
    private boolean archiveAlarms = true;
    private boolean archiveAlarmChangeEvents = true;
    private boolean archiveOldAlarmValues = true;
    private boolean archiveNewAlarmValues = true;
    private NodeCache nodeCache = null;
    private JestClient jestClient = null;
    private RestClientFactory restClientFactory = null;
    IndexNameFunction indexNameFunction = new IndexNameFunction();

    public IndexNameFunction getIndexNameFunction() {
        return this.indexNameFunction;
    }

    public void setIndexNameFunction(IndexNameFunction indexNameFunction) {
        this.indexNameFunction = indexNameFunction;
    }

    public boolean isLogEventDescription() {
        return this.logEventDescription;
    }

    public void setLogEventDescription(boolean logEventDescription) {
        this.logEventDescription = logEventDescription;
    }

    public NodeCache getNodeCache() {
        return this.nodeCache;
    }

    public void setNodeCache(NodeCache cache) {
        this.nodeCache = cache;
    }

    public RestClientFactory getRestClientFactory() {
        return this.restClientFactory;
    }

    public void setRestClientFactory(RestClientFactory restClientFactory) {
        this.restClientFactory = restClientFactory;
    }

    public boolean getArchiveAlarms() {
        return this.archiveAlarms;
    }

    public void setArchiveAlarms(boolean archiveAlarms) {
        this.archiveAlarms = archiveAlarms;
    }

    public boolean getArchiveAlarmChangeEvents() {
        return this.archiveAlarmChangeEvents;
    }

    public void setArchiveAlarmChangeEvents(boolean archiveAlarmChangeEvents) {
        this.archiveAlarmChangeEvents = archiveAlarmChangeEvents;
    }

    public boolean getArchiveRawEvents() {
        return this.archiveRawEvents;
    }

    public void setArchiveRawEvents(boolean archiveRawEvents) {
        this.archiveRawEvents = archiveRawEvents;
    }

    public boolean getArchiveOldAlarmValues() {
        return this.archiveOldAlarmValues;
    }

    public void setArchiveOldAlarmValues(boolean archiveOldAlarmValues) {
        this.archiveOldAlarmValues = archiveOldAlarmValues;
    }

    public boolean getArchiveNewAlarmValues() {
        return this.archiveNewAlarmValues;
    }

    public void setArchiveNewAlarmValues(boolean archiveNewAlarmValues) {
        this.archiveNewAlarmValues = archiveNewAlarmValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JestClient getJestClient() {
        if (this.jestClient == null) {
            EventToIndex eventToIndex = this;
            synchronized (eventToIndex) {
                if (this.jestClient == null) {
                    if (this.restClientFactory == null) {
                        throw new RuntimeException("JestClientFactory must be set");
                    }
                    this.jestClient = this.restClientFactory.getJestClient();
                }
            }
        }
        return this.jestClient;
    }

    public void destroy() {
        if (this.jestClient != null) {
            try {
                this.jestClient.shutdownClient();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jestClient = null;
    }

    public void forwardEvent(Event event) {
        try {
            this.maybeRefreshCache(event);
            String uei = event.getUei();
            Update alarmUpdate = null;
            Index eventIndex = null;
            DocumentResult alarmIndexresult = null;
            DocumentResult eventIndexresult = null;
            if (uei.startsWith(ALARM_NOTIFICATION_UEI_STEM)) {
                JestResult result;
                CreateIndex createIndex;
                if (STICKY_MEMO_EVENT.equals(uei) || JOURNAL_MEMO_EVENT.equals(uei)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending Alarm MEMO Event to ES:" + event.toString());
                    }
                } else {
                    if (ALARM_CREATED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Created Event to ES:" + event.toString());
                        }
                    } else if (ALARM_DELETED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Deleted Event to ES:" + event.toString());
                        }
                    } else if (ALARM_SEVERITY_CHANGED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Changed Severity Event to ES:" + event.toString());
                        }
                    } else if (ALARM_CLEARED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Cleared Event to ES:" + event.toString());
                        }
                    } else if (ALARM_ACKNOWLEDGED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Acknowledged Event to ES:" + event.toString());
                        }
                    } else if (ALARM_UNACKNOWLEDGED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Unacknowledged Event to ES:" + event.toString());
                        }
                    } else if (ALARM_SUPPRESSED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Suppressed Event to ES:" + event.toString());
                        }
                    } else if (ALARM_UNSUPPRESSED_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm Unsuppressed Event to ES:" + event.toString());
                        }
                    } else if (ALARM_TROUBLETICKET_STATE_CHANGE_EVENT.equals(uei)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending Alarm TroubleTicked state changed Event to ES:" + event.toString());
                        }
                    } else if (ALARM_CHANGED_EVENT.equals(uei) && LOG.isDebugEnabled()) {
                        LOG.debug("Sending Alarm Changed Event to ES:" + event.toString());
                    }
                    if (this.archiveAlarms) {
                        alarmUpdate = this.populateAlarmIndexBodyFromAlarmChangeEvent(event, ALARM_INDEX_NAME, ALARM_INDEX_TYPE);
                        String alarmindexname = alarmUpdate.getIndex();
                        alarmIndexresult = (DocumentResult)this.getJestClient().execute((Action)alarmUpdate);
                        if (alarmIndexresult.getResponseCode() == 404) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("trying to update alarm\n   received search result: " + alarmIndexresult.getJsonString() + "\n   response code:" + alarmIndexresult.getResponseCode() + "\n   error message: " + alarmIndexresult.getErrorMessage());
                                LOG.debug("index name " + alarmindexname + " doesnt exist creating new index");
                            }
                            createIndex = new CreateIndex.Builder(alarmindexname).build();
                            result = this.getJestClient().execute((Action)createIndex);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("created new alarm index:" + alarmindexname + " type:" + ALARM_INDEX_TYPE + "\n   received search result: " + result.getJsonString() + "\n   response code:" + result.getResponseCode() + "\n   error message: " + result.getErrorMessage());
                            }
                            alarmIndexresult = (DocumentResult)this.getJestClient().execute((Action)alarmUpdate);
                        }
                        if (alarmIndexresult.getResponseCode() != 200) {
                            LOG.error("Problem sending alarm to es index:" + alarmindexname + " type:" + ALARM_INDEX_TYPE + "\n   received search result: " + alarmIndexresult.getJsonString() + "\n   response code:" + alarmIndexresult.getResponseCode() + "\n   error message: " + alarmIndexresult.getErrorMessage());
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Alarm sent to es index:" + alarmindexname + " type:" + ALARM_INDEX_TYPE + "\n   received search result: " + alarmIndexresult.getJsonString() + "\n   response code:" + alarmIndexresult.getResponseCode() + "\n   error message: " + alarmIndexresult.getErrorMessage());
                        }
                    }
                }
                if (this.archiveAlarmChangeEvents) {
                    eventIndex = this.populateEventIndexBodyFromEvent(event, ALARM_EVENT_INDEX_NAME, EVENT_INDEX_TYPE);
                    String alarmeventindexname = eventIndex.getIndex();
                    eventIndexresult = (DocumentResult)this.getJestClient().execute((Action)eventIndex);
                    if (eventIndexresult.getResponseCode() == 404) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("trying to update alarm event index\n   received search result: " + eventIndexresult.getJsonString() + "\n   response code:" + eventIndexresult.getResponseCode() + "\n   error message: " + eventIndexresult.getErrorMessage());
                            LOG.debug("index name " + alarmeventindexname + " doesnt exist creating new index");
                        }
                        createIndex = new CreateIndex.Builder(alarmeventindexname).build();
                        result = this.getJestClient().execute((Action)createIndex);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("created new alarm change event index:" + alarmeventindexname + " type:" + EVENT_INDEX_TYPE + "\n   received search result: " + result.getJsonString() + "\n   response code:" + result.getResponseCode() + "\n   error message: " + result.getErrorMessage());
                        }
                        eventIndexresult = (DocumentResult)this.getJestClient().execute((Action)eventIndex);
                    }
                    if (eventIndexresult.getResponseCode() != 200) {
                        LOG.error("Problem sending Alarm Event to es index:" + alarmeventindexname + " type:" + EVENT_INDEX_TYPE + "\n   received search result: " + alarmIndexresult.getJsonString() + "\n   response code:" + alarmIndexresult.getResponseCode() + "\n   error message: " + alarmIndexresult.getErrorMessage());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Alarm Event sent to es index:" + alarmeventindexname + " type:" + EVENT_INDEX_TYPE + "\n   received search result: " + eventIndexresult.getJsonString() + "\n   response code:" + eventIndexresult.getResponseCode() + "\n   error message: " + eventIndexresult.getErrorMessage());
                    }
                }
            } else if (this.archiveRawEvents) {
                if (event.getDbid() != null && event.getDbid() != 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending Event to ES:" + event.toString());
                    }
                    eventIndex = this.populateEventIndexBodyFromEvent(event, EVENT_INDEX_NAME, EVENT_INDEX_TYPE);
                    String eventindexname = eventIndex.getIndex();
                    eventIndexresult = (DocumentResult)this.getJestClient().execute((Action)eventIndex);
                    if (eventIndexresult.getResponseCode() == 404) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("trying to update event index\n   received search result: " + eventIndexresult.getJsonString() + "\n   response code:" + eventIndexresult.getResponseCode() + "\n   error message: " + eventIndexresult.getErrorMessage());
                            LOG.debug("index name " + eventindexname + " doesnt exist creating new index");
                        }
                        CreateIndex createIndex = new CreateIndex.Builder(eventindexname).build();
                        JestResult result = this.getJestClient().execute((Action)createIndex);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("created new event index:" + eventindexname + " type:" + EVENT_INDEX_TYPE + "\n   received search result: " + result.getJsonString() + "\n   response code:" + result.getResponseCode() + "\n   error message: " + result.getErrorMessage());
                        }
                        eventIndexresult = (DocumentResult)this.getJestClient().execute((Action)eventIndex);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Event sent to es index:" + eventindexname + " type:" + EVENT_INDEX_TYPE + "\n   received search result: " + eventIndexresult.getJsonString() + "\n   response code:" + eventIndexresult.getResponseCode() + "\n   error message: " + eventIndexresult.getErrorMessage());
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Not Sending Event to ES: null event.getDbid()=" + event.getDbid() + " Event=" + event.toString());
            }
        }
        catch (Exception ex) {
            LOG.error("problem sending event to Elastic Search", (Throwable)ex);
        }
    }

    public Index populateEventIndexBodyFromEvent(Event event, String rootIndexName, String indexType) {
        HashMap<String, String> body = new HashMap<String, String>();
        String id = event.getDbid() == null ? null : Integer.toString(event.getDbid());
        body.put("id", id);
        body.put("eventuei", event.getUei());
        Calendar cal = Calendar.getInstance();
        if (event.getTime() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("using local time because no event creation time for event.toString: " + event.toString());
            }
            cal.setTime(new Date());
        } else {
            cal.setTime(event.getTime());
        }
        body.put("@timestamp", DatatypeConverter.printDateTime((Calendar)cal));
        body.put("dow", Integer.toString(cal.get(7)));
        body.put("hour", Integer.toString(cal.get(11)));
        body.put("dom", Integer.toString(cal.get(5)));
        body.put("eventsource", event.getSource());
        body.put("ipaddr", event.getInterfaceAddress() != null ? event.getInterfaceAddress().toString() : null);
        body.put("servicename", event.getService());
        body.put("eventseverity_text", event.getSeverity());
        body.put("eventseverity", Integer.toString(OnmsSeverity.get((String)event.getSeverity()).getId()));
        if (this.isLogEventDescription()) {
            body.put("eventdescr", event.getDescr());
        }
        body.put("host", event.getHost());
        for (Object parm : event.getParmCollection()) {
            body.put("p_" + parm.getParmName(), parm.getValue().getContent());
        }
        if (!this.archiveNewAlarmValues) {
            body.remove("p_oldalarmvalues");
        }
        if (!this.archiveOldAlarmValues) {
            body.remove("p_newalarmvalues");
        }
        body.put("interface", event.getInterface());
        body.put("logmsg", event.getLogmsg() != null ? event.getLogmsg().getContent() : null);
        body.put("logmsgdest", event.getLogmsg() != null ? event.getLogmsg().getDest() : null);
        if (event.getNodeid() != null) {
            body.put("nodeid", Long.toString(event.getNodeid()));
            if (body.containsKey("p_nodelabel")) {
                body.put(NODE_LABEL, (String)body.get("p_nodelabel"));
            } else if (this.nodeCache != null) {
                Map nodedetails = this.nodeCache.getEntry(event.getNodeid());
                for (Object key : nodedetails.keySet()) {
                    String keyStr = (String)key;
                    String value = (String)nodedetails.get(key);
                    body.put(keyStr, value);
                }
            }
        }
        String completeIndexName = this.indexNameFunction.apply(rootIndexName, cal.getTime());
        if (LOG.isDebugEnabled()) {
            String str = "populateEventIndexBodyFromEvent - index:/" + completeIndexName + "/" + indexType + "/" + id + "\n   body: ";
            for (String key : body.keySet()) {
                str = str + "[" + key + " : " + (String)body.get(key) + "]";
            }
            LOG.debug(str);
        }
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(body).index(completeIndexName)).type(indexType)).id(id)).build();
        return index;
    }

    public Update populateAlarmIndexBodyFromAlarmChangeEvent(Event event, String rootIndexName, String indexType) {
        String key;
        Object obj;
        Update update = null;
        HashMap<String, String> body = new HashMap<String, String>();
        HashMap<String, String> parmsMap = new HashMap<String, String>();
        for (Parm parm : event.getParmCollection()) {
            parmsMap.put(parm.getParmName(), parm.getValue().getContent());
        }
        String oldValuesStr = (String)parmsMap.get(OLD_ALARM_VALUES);
        String newValuesStr = (String)parmsMap.get(NEW_ALARM_VALUES);
        if (LOG.isDebugEnabled()) {
            LOG.debug("AlarmChangeEvent from eventid " + event.getDbid() + "\n  newValuesStr=" + newValuesStr + "\n  oldValuesStr=" + oldValuesStr);
        }
        JSONObject alarmValues = null;
        JSONObject newAlarmValues = null;
        JSONObject oldAlarmValues = null;
        JSONParser parser = new JSONParser();
        if (newValuesStr != null) {
            try {
                obj = parser.parse(newValuesStr);
                newAlarmValues = (JSONObject)obj;
            }
            catch (ParseException e1) {
                LOG.error("cannot parse newValuesStr from eventid " + event.getDbid() + " to json object. newValuesStr=" + newValuesStr, (Throwable)e1);
            }
        }
        if (newAlarmValues != null && !newAlarmValues.isEmpty()) {
            alarmValues = newAlarmValues;
        } else {
            if (oldValuesStr == null) {
                LOG.error("newValuesStr and oldValuesStr both empty in AlarmChangeEvent from eventid " + event.getDbid() + "\n  newValuesStr=" + newValuesStr + "\n  oldValuesStr=" + oldValuesStr);
                return null;
            }
            try {
                obj = parser.parse(oldValuesStr);
                oldAlarmValues = (JSONObject)obj;
            }
            catch (ParseException e1) {
                LOG.error("cannot parse oldValuesStr from eventid " + event.getDbid() + " to json object. oldValuesStr=" + oldValuesStr, (Throwable)e1);
                return null;
            }
            if (!oldAlarmValues.isEmpty()) {
                alarmValues = oldAlarmValues;
            } else {
                LOG.error("oldValuesStr and newValuesStr both empty in AlarmChangeEvent from eventid " + event.getDbid() + "\n  newValuesStr=" + newValuesStr + "\n  oldValuesStr=" + oldValuesStr);
                return null;
            }
        }
        for (Object x : alarmValues.keySet()) {
            String value;
            key = (String)x;
            String string = value = alarmValues.get((Object)key) == null ? null : alarmValues.get((Object)key).toString();
            if (EVENT_PARAMS.equals(key) && value != null) {
                List params = EventParameterUtils.decode((String)value);
                for (Object parm : params) {
                    body.put("p_" + parm.getParmName(), parm.getValue().getContent());
                }
                continue;
            }
            if (SEVERITY.equals(key) && value != null) {
                try {
                    int id = Integer.parseInt(value);
                    String label = OnmsSeverity.get((int)id).getLabel();
                    body.put(SEVERITY_TEXT, label);
                }
                catch (Exception e) {
                    LOG.error("cannot parse severity for alarm change event id" + event.getDbid());
                }
                continue;
            }
            body.put(key, value);
        }
        if (ALARM_CREATED_EVENT.equals(event.getUei())) {
            body.put(ALARM_CLEAR_TIME, null);
            body.put(ALARM_DELETED_TIME, null);
        }
        if (ALARM_CLEARED_EVENT.equals(event.getUei())) {
            Calendar alarmClearCal = Calendar.getInstance();
            alarmClearCal.setTime(event.getTime());
            body.put(ALARM_CLEAR_TIME, DatatypeConverter.printDateTime((Calendar)alarmClearCal));
        }
        if (ALARM_DELETED_EVENT.equals(event.getUei())) {
            Calendar alarmDeletionCal = Calendar.getInstance();
            alarmDeletionCal.setTime(event.getTime());
            body.put(ALARM_DELETED_TIME, DatatypeConverter.printDateTime((Calendar)alarmDeletionCal));
        }
        if (parmsMap.get(ALARM_ACK_TIME) == null || "".equals(parmsMap.get(ALARM_ACK_TIME))) {
            body.put(ALARM_ACK_TIME, null);
            body.put(ALARM_ACK_USER, null);
        }
        if (parmsMap.get(INITIAL_SEVERITY) != null) {
            String severityId = (String)parmsMap.get(INITIAL_SEVERITY);
            body.put(INITIAL_SEVERITY, severityId);
            try {
                int id = Integer.parseInt(severityId);
                String label = OnmsSeverity.get((int)id).getLabel();
                body.put(INITIAL_SEVERITY_TEXT, label);
            }
            catch (Exception e) {
                LOG.error("cannot parse initial severity for alarm change event id" + event.getDbid());
            }
        }
        if (parmsMap.get(NODE_LABEL) != null) {
            body.put(NODE_LABEL, (String)parmsMap.get(NODE_LABEL));
        } else if (this.nodeCache != null && event.getNodeid() != null) {
            Map nodedetails = this.nodeCache.getEntry(event.getNodeid());
            Iterator e = nodedetails.keySet().iterator();
            while (e.hasNext()) {
                String keyStr = key = e.next();
                String value = (String)nodedetails.get(key);
                body.put(keyStr, value);
            }
        }
        if (alarmValues.get((Object)MEMO_ALARMID_PARAM) == null) {
            LOG.error("No alarmid param - cannot create alarm elastic search record from event content:" + event.toString());
        } else {
            String id = alarmValues.get((Object)MEMO_ALARMID_PARAM).toString();
            body.put("p_alarmid", id);
            String alarmCreationTime = null;
            Date alarmCreationDate = null;
            Calendar alarmCreationCal = null;
            try {
                alarmCreationTime = alarmValues.get((Object)"firsteventtime").toString();
                alarmCreationCal = DatatypeConverter.parseDateTime((String)alarmCreationTime);
            }
            catch (Exception e) {
                LOG.error("using current Date() for @timestamp because problem creating date from alarmchange event " + event.getDbid() + " from firsteventtime=" + alarmCreationTime, (Throwable)e);
            }
            if (alarmCreationCal == null) {
                alarmCreationCal = Calendar.getInstance();
                alarmCreationCal.setTime(new Date());
            }
            body.put("@timestamp", DatatypeConverter.printDateTime((Calendar)alarmCreationCal));
            body.put("dow", Integer.toString(alarmCreationCal.get(7)));
            body.put("hour", Integer.toString(alarmCreationCal.get(11)));
            body.put("dom", Integer.toString(alarmCreationCal.get(5)));
            alarmCreationDate = alarmCreationCal.getTime();
            String completeIndexName = this.indexNameFunction.apply(rootIndexName, alarmCreationDate);
            if (LOG.isDebugEnabled()) {
                String str = "populateAlarmIndexBodyFromAlarmChangeEvent - index:/" + completeIndexName + "/" + indexType + "/" + id + "\n   body: ";
                for (String key2 : body.keySet()) {
                    str = str + "[" + key2 + " : " + (String)body.get(key2) + "]";
                }
                LOG.debug(str);
            }
            JSONObject doc = new JSONObject(body);
            JSONObject updateQuery = new JSONObject();
            updateQuery.put((Object)"doc", (Object)doc);
            updateQuery.put((Object)"doc_as_upsert", (Object)true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("update query sent:" + updateQuery.toJSONString());
            }
            update = ((Update.Builder)((Update.Builder)((Update.Builder)new Update.Builder((Object)updateQuery.toJSONString()).index(completeIndexName)).type(indexType)).id(id)).build();
        }
        return update;
    }

    private void maybeRefreshCache(Event event) {
        String uei = event.getUei();
        if (uei != null && uei.startsWith("uei.opennms.org/nodes/") && (uei.endsWith("Added") || uei.endsWith("Deleted") || uei.endsWith("Updated") || uei.endsWith("Changed"))) {
            this.nodeCache.refreshEntry(event.getNodeid());
        }
    }
}

