/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.archive.cmd;

import java.net.URL;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.plugins.elasticsearch.rest.archive.OpenNMSHistoricEventsToEs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="elastic-search", name="send-historic-events", description="Sends events in selected OpenNMS to Elastic Search")
public class SendEventsToEsCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SendEventsToEsCommand.class);
    private OpenNMSHistoricEventsToEs openNMSHistoricEventsToEs;
    @Argument(index=0, name="limit", description="Limit number of events to send", required=true, multiValued=false)
    String limit = null;
    @Argument(index=1, name="offset", description="Offset for starting events", required=true, multiValued=false)
    String offset = null;
    @Argument(index=2, name="onms-username", description="rest password for opennms", required=false, multiValued=false)
    String onmsUserName = null;
    @Argument(index=3, name="onms-password", description="rest username for opennms", required=false, multiValued=false)
    String onmsPassWord = null;
    @Argument(index=4, name="onms-url", description="URL of OpenNMS ReST interface to retrieve events to send", required=false, multiValued=false)
    String onmsUrl = null;
    @Argument(index=5, name="use-node-label", description="If false local node cache will get nodelabel for nodeid. If true will use remote nodelabel", required=false, multiValued=false)
    String useNodelabel = "false";

    public OpenNMSHistoricEventsToEs getOpenNMSHistoricEventsToEs() {
        return this.openNMSHistoricEventsToEs;
    }

    public void setOpenNMSHistoricEventsToEs(OpenNMSHistoricEventsToEs openNMSHistoricEventsToEs) {
        this.openNMSHistoricEventsToEs = openNMSHistoricEventsToEs;
    }

    protected Object doExecute() throws Exception {
        try {
            if (this.offset != null) {
                this.getOpenNMSHistoricEventsToEs().setOffset(Integer.valueOf(this.offset));
            }
            if (this.limit != null) {
                this.getOpenNMSHistoricEventsToEs().setLimit(Integer.valueOf(this.limit));
            }
            if (this.onmsPassWord != null) {
                this.getOpenNMSHistoricEventsToEs().setOnmsPassWord(this.onmsPassWord);
            }
            if (this.onmsUserName != null) {
                this.getOpenNMSHistoricEventsToEs().setOnmsUserName(this.onmsUserName);
            }
            if (this.onmsUrl != null) {
                URL url = new URL(this.onmsUrl);
                this.getOpenNMSHistoricEventsToEs().setOnmsUrl(this.onmsUrl);
            }
            if (this.useNodelabel != null) {
                this.getOpenNMSHistoricEventsToEs().setUseNodeLabel(Boolean.valueOf(this.useNodelabel));
            }
            String msg = "Sending events to Elastic Search. \n Limit =" + this.getOpenNMSHistoricEventsToEs().getLimit() + "\n Offset =" + this.getOpenNMSHistoricEventsToEs().getOffset() + "\n Retreiving events from OpenNMS URL=" + this.getOpenNMSHistoricEventsToEs().getOnmsUrl() + "\n OpenNMS Username=" + this.getOpenNMSHistoricEventsToEs().getOnmsUserName() + "\n OpenNMS Password=" + this.getOpenNMSHistoricEventsToEs().getOnmsPassWord() + "\n Use Node Label=" + this.getOpenNMSHistoricEventsToEs().getUseNodeLabel();
            LOG.info(msg);
            System.out.println(msg);
            msg = this.getOpenNMSHistoricEventsToEs().sendEventsToEs();
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("Error Sending Historical Events to ES (see karaf log) " + ExceptionUtils.getStackTrace((Throwable)e));
            LOG.error("Error Sending Historical Events to ES ", (Throwable)e);
        }
        return null;
    }
}

