/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.archive;

import java.util.List;
import java.util.ListIterator;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.plugins.elasticsearch.rest.archive.OnmsRestEventsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNMSHistoricEventsToEs {
    private static final Logger LOG = LoggerFactory.getLogger(OpenNMSHistoricEventsToEs.class);
    private static final int EVENT_RETREIVAL_LIMIT = 10;
    private String onmsUrl = "http://localhost:8980";
    private String onmsUserName = "admin";
    private String onmsPassWord = "admin";
    private Integer limit = 10;
    private Integer offset = 0;
    private EventForwarder eventForwarder = null;
    private boolean useNodeLabel = true;

    public String getOnmsUrl() {
        return this.onmsUrl;
    }

    public void setOnmsUrl(String onmsUrl) {
        this.onmsUrl = onmsUrl;
    }

    public String getOnmsUserName() {
        return this.onmsUserName;
    }

    public void setOnmsUserName(String onmsUserName) {
        this.onmsUserName = onmsUserName;
    }

    public String getOnmsPassWord() {
        return this.onmsPassWord;
    }

    public void setOnmsPassWord(String onmsPassWord) {
        this.onmsPassWord = onmsPassWord;
    }

    public EventForwarder getEventForwarder() {
        return this.eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public boolean getUseNodeLabel() {
        return this.useNodeLabel;
    }

    public void setUseNodeLabel(boolean useCache) {
        this.useNodeLabel = useCache;
    }

    public String sendEventsToEs() {
        OnmsRestEventsClient onmsRestEventsClient = new OnmsRestEventsClient();
        onmsRestEventsClient.setOnmsUrl(this.onmsUrl);
        onmsRestEventsClient.setOnmsPassWord(this.onmsPassWord);
        onmsRestEventsClient.setOnmsUserName(this.onmsUserName);
        Event firstEvent = null;
        Event lastEvent = null;
        boolean endofEvents = false;
        int eventsSent = 0;
        int eventOffset = this.offset;
        while (!endofEvents && eventsSent <= this.limit) {
            List<Event> events = onmsRestEventsClient.getEvents(10, eventOffset);
            endofEvents = events.isEmpty();
            for (Event event : events) {
                if (firstEvent == null) {
                    firstEvent = event;
                }
                lastEvent = event;
                ++eventsSent;
                if (!this.useNodeLabel) {
                    List parmCollection = event.getParmCollection();
                    ListIterator iter = parmCollection.listIterator();
                    while (iter.hasNext()) {
                        if (!"nodelabel".equals(((Parm)iter.next()).getParmName())) continue;
                        iter.remove();
                    }
                }
                LOG.debug("sending event to es: eventid=" + event.getDbid());
                this.getEventForwarder().sendNow(event);
            }
            eventOffset += 10;
        }
        return "Sent " + eventsSent + " events to Elastic Search. First event " + "id=" + (firstEvent != null ? firstEvent.getDbid() : "firstEvent null") + " last event id=" + (lastEvent != null ? lastEvent.getDbid() : "lastEvent null");
    }
}

