/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.indices.template.PutTemplate;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opennms.plugins.elasticsearch.rest.RestClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchInitialiser {
    Logger LOG = LoggerFactory.getLogger(ElasticSearchInitialiser.class);
    public static final long DEFAULT_RETRY_TIMER_MS = 20000L;
    private long retryTimer = 20000L;
    private ESInitialiser esInitialiser = new ESInitialiser();
    private Thread esInitialiserThread = new Thread(this.esInitialiser);
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private AtomicBoolean initialiserIsRunning = new AtomicBoolean(false);
    private Map<String, String> templateFilesMap = new LinkedHashMap<String, String>();
    private Map<String, StringBuffer> loadedFiles = new HashMap<String, StringBuffer>();
    private RestClientFactory restClientFactory = null;
    private JestClient jestClient = null;

    public long getRetryTimer() {
        return this.retryTimer;
    }

    public void setRetryTimer(long retryTimer) {
        this.retryTimer = retryTimer;
    }

    public Map<String, String> getTemplateFiles() {
        return this.templateFilesMap;
    }

    public void setTemplateFiles(Map<String, String> templateFiles) {
        this.templateFilesMap.clear();
        this.templateFilesMap.putAll(templateFiles);
    }

    public RestClientFactory getRestClientFactory() {
        return this.restClientFactory;
    }

    public void setRestClientFactory(RestClientFactory restClientFactory) {
        this.restClientFactory = restClientFactory;
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    public void init() {
        if (this.getTemplateFiles().isEmpty()) {
            this.LOG.info("ElasticSearcInitialiser started with no default template files");
            this.initialised.set(true);
            return;
        }
        for (String templateName : this.getTemplateFiles().keySet()) {
            String fileName = this.getTemplateFiles().get(templateName);
            this.LOG.info("   elasticsearch intialiser loading index template '" + templateName + "' from file " + fileName);
            try {
                String l;
                StringBuffer body = new StringBuffer();
                BufferedReader is = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName)));
                while ((l = is.readLine()) != null) {
                    body.append(l);
                }
                JSONParser parser = new JSONParser();
                JSONObject jsonObject = null;
                try {
                    Object obj = parser.parse(body.toString());
                    jsonObject = (JSONObject)obj;
                    this.loadedFiles.put(templateName, body);
                    this.LOG.debug("Loaded Template File\n     fileName: '" + fileName + "'\n     templateName: '" + templateName + "'\n     contents: " + jsonObject.toJSONString());
                }
                catch (ParseException e1) {
                    throw new RuntimeException("cannot parse json Elastic Search template mapping from file " + fileName, e1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problem reading Elastic Search template mapping fileName=" + fileName, e);
            }
        }
        this.LOG.debug("ElasticSearcInitialiser loaded template files. Trying to send templates to to ES");
        this.initialiserIsRunning.set(true);
        this.esInitialiserThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JestClient getJestClient() {
        if (this.jestClient == null) {
            ElasticSearchInitialiser elasticSearchInitialiser = this;
            synchronized (elasticSearchInitialiser) {
                if (this.jestClient == null) {
                    if (this.restClientFactory == null) {
                        throw new RuntimeException("JestClientFactory must be set");
                    }
                    this.jestClient = this.restClientFactory.getJestClient();
                }
            }
        }
        return this.jestClient;
    }

    public void destroy() {
        this.initialiserIsRunning.set(false);
        this.esInitialiserThread.interrupt();
        if (this.jestClient != null) {
            try {
                this.jestClient.shutdownClient();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jestClient = null;
    }

    private class ESInitialiser
    implements Runnable {
        private ESInitialiser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ElasticSearchInitialiser.this.LOG.debug("starting ESInitialiser thread");
            while (!ElasticSearchInitialiser.this.initialised.get() && ElasticSearchInitialiser.this.initialiserIsRunning.get()) {
                String templateName = null;
                try {
                    Iterator entries = ElasticSearchInitialiser.this.loadedFiles.entrySet().iterator();
                    while (entries.hasNext() && ElasticSearchInitialiser.this.initialiserIsRunning.get()) {
                        Map.Entry entry = entries.next();
                        templateName = (String)entry.getKey();
                        String body = ((StringBuffer)entry.getValue()).toString();
                        PutTemplate putTemplate = new PutTemplate.Builder(templateName, (Object)body).build();
                        JestResult jestResult = ElasticSearchInitialiser.this.getJestClient().execute((Action)putTemplate);
                        if (!jestResult.isSucceeded()) {
                            ElasticSearchInitialiser.this.LOG.error("Error sending template '" + templateName + "' to Elastic Search received result: " + jestResult.getJsonString() + "\n   response code:" + jestResult.getResponseCode() + "\n   error message: " + jestResult.getErrorMessage());
                            continue;
                        }
                        ElasticSearchInitialiser.this.LOG.info("Sent template '" + templateName + "' to Elastic Search received result: " + jestResult.getJsonString() + "\n   response code:" + jestResult.getResponseCode() + "\n   error message: " + jestResult.getErrorMessage());
                    }
                    ElasticSearchInitialiser.this.initialised.set(true);
                }
                catch (Exception ex) {
                    ElasticSearchInitialiser.this.LOG.error("could not send template '" + templateName + "' to Elastic Search", (Throwable)ex);
                }
                if (!ElasticSearchInitialiser.this.initialiserIsRunning.get() || ElasticSearchInitialiser.this.initialised.get()) continue;
                try {
                    ElasticSearchInitialiser.this.LOG.error("waiting " + ElasticSearchInitialiser.this.retryTimer + " ms before retrying to sending all templates again to Elastic Search");
                    ESInitialiser eSInitialiser = this;
                    synchronized (eSInitialiser) {
                        this.wait(ElasticSearchInitialiser.this.retryTimer);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (ElasticSearchInitialiser.this.initialised.get()) {
                ElasticSearchInitialiser.this.LOG.info("ElasticSearcInitialiser initialisation complete");
            } else {
                ElasticSearchInitialiser.this.LOG.error("ElasticSearcInitialiser initialisation not complete. Initialiser shutting down.");
            }
        }
    }
}

