/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.dbnotifier.alarmnotifier;

import java.sql.Timestamp;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.plugins.com.impossibl.postgres.jdbc.TimestampUtils;
import org.opennms.plugins.dbnotifier.DbNotification;
import org.opennms.plugins.dbnotifier.NotificationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemosChangeNotificationClient
implements NotificationClient {
    private static final Logger LOG = LoggerFactory.getLogger(MemosChangeNotificationClient.class);
    public static final String EVENT_SOURCE_NAME = "AlarmChangeNotifier";
    EventProxy eventProxy = null;

    public EventProxy getEventProxy() {
        return this.eventProxy;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.eventProxy = eventProxy;
    }

    @Override
    public void sendDbNotification(DbNotification dbNotification) {
        try {
            String payload = dbNotification.getPayload();
            JSONObject memoJsonObject = null;
            JSONObject alarmIdJsonObject = null;
            String alarmId = null;
            String body = null;
            String author = null;
            String reductionkey = null;
            try {
                JSONParser parser = new JSONParser();
                Object obj = parser.parse(payload);
                JSONArray jsonArray = (JSONArray)obj;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("payload memo jsonArray.toString():" + jsonArray.toString());
                }
                memoJsonObject = (JSONObject)jsonArray.get(0);
                memoJsonObject = this.jsonMemoTimeNormaliser(memoJsonObject);
                alarmIdJsonObject = (JSONObject)jsonArray.get(1);
                alarmId = alarmIdJsonObject.get((Object)"alarmid") == null ? null : alarmIdJsonObject.get((Object)"alarmid").toString();
                body = memoJsonObject.get((Object)"body") == null ? null : memoJsonObject.get((Object)"body").toString();
                author = memoJsonObject.get((Object)"author") == null ? null : memoJsonObject.get((Object)"author").toString();
                reductionkey = memoJsonObject.get((Object)"reductionkey") == null ? null : memoJsonObject.get((Object)"reductionkey").toString();
            }
            catch (ParseException e1) {
                throw new RuntimeException("cannot parse notification payload to json object. payload=" + payload, e1);
            }
            if (!memoJsonObject.isEmpty()) {
                EventBuilder eb;
                if ("Memo".equals(memoJsonObject.get((Object)"type").toString())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("sticky memo updated=" + memoJsonObject.get((Object)"id"));
                    }
                    eb = new EventBuilder("uei.opennms.org/plugin/AlarmChangeNotificationEvent/StickyMemoUpdate", EVENT_SOURCE_NAME);
                    eb.addParam("memovalues", memoJsonObject.toString(), "json", "text");
                    eb.addParam("alarmid", alarmId);
                    eb.addParam("body", body);
                    eb.addParam("author", author);
                    this.sendEvent(eb.getEvent());
                } else if ("ReductionKeyMemo".equals(memoJsonObject.get((Object)"type").toString())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("reduction key memo updated=" + memoJsonObject.get((Object)"id"));
                    }
                    eb = new EventBuilder("uei.opennms.org/plugin/AlarmChangeNotificationEvent/JournalMemoUpdate", EVENT_SOURCE_NAME);
                    eb.addParam("memovalues", memoJsonObject.toString(), "json", "text");
                    eb.addParam("alarmid", alarmId);
                    eb.addParam("body", body);
                    eb.addParam("author", author);
                    eb.addParam("reductionkey", reductionkey);
                    this.sendEvent(eb.getEvent());
                }
            }
        }
        catch (Exception e) {
            LOG.error("problem creating opennms alarm change event from database notification", (Throwable)e);
        }
    }

    private void sendEvent(Event e) {
        LOG.debug("sending event to opennms. event.tostring():" + e.toString());
        try {
            if (this.eventProxy != null) {
                this.eventProxy.send(e);
            } else {
                LOG.error("OpenNMS event proxy not set - cannot send events to opennms");
            }
        }
        catch (EventProxyException ex) {
            throw new RuntimeException("event proxy problem sending Memo Change Event to OpenNMS:", ex);
        }
    }

    public JSONObject jsonMemoTimeNormaliser(JSONObject jsonObject) {
        String updated;
        String created;
        if (jsonObject.isEmpty()) {
            return jsonObject;
        }
        String string = created = jsonObject.get((Object)"created") == null ? null : this.timeNormaliser(jsonObject.get((Object)"created").toString());
        if (created != null) {
            jsonObject.put((Object)"created", (Object)created);
        }
        String string2 = updated = jsonObject.get((Object)"updated") == null ? null : this.timeNormaliser(jsonObject.get((Object)"updated").toString());
        if (updated != null) {
            jsonObject.put((Object)"suppresseduntil", (Object)updated);
        }
        return jsonObject;
    }

    public String timeNormaliser(String dbTimeStr) {
        String normalisedTimeStr = null;
        Calendar alarmCreationCal = null;
        TimestampUtils timestampUtils = new TimestampUtils();
        try {
            Timestamp timestamp = timestampUtils.toTimestamp(null, dbTimeStr);
            alarmCreationCal = Calendar.getInstance();
            alarmCreationCal.setTime(timestamp);
            normalisedTimeStr = DatatypeConverter.printDateTime((Calendar)alarmCreationCal);
        }
        catch (Exception e) {
            LOG.error("cannot parse database json time string dbTimeStr" + dbTimeStr, (Throwable)e);
        }
        return normalisedTimeStr;
    }

    @Override
    public void init() {
        LOG.debug("initialising MemosChangeNotificationClient");
        if (this.eventProxy == null) {
            LOG.debug("OpenNMS event proxy not set - cannot send events to opennms");
        }
    }

    @Override
    public void destroy() {
    }
}

