/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.dbnotifier;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import com.impossibl.postgres.jdbc.PGDataSource;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opennms.plugins.dbnotifier.DbNotification;
import org.opennms.plugins.dbnotifier.DbNotificationClient;
import org.opennms.plugins.dbnotifier.DbNotifierDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseChangeNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseChangeNotifier.class);
    public static final String NOTIFY_ALARM_CHANGES = "NOTIFY_ALARM_CHANGES";
    public static final String NOTIFY_EVENT_CHANGES = "NOTIFY_EVENT_CHANGES";
    public static final String NOTIFY_MEMOS_CHANGES = "NOTIFY_MEMOS_CHANGES";
    private boolean listenForEvents = false;
    private boolean listenForAlarms = false;
    private boolean listenForMemos = false;
    private String disConnectionStatementEvents = "";
    private String connectionStatementEvents = "";
    private String disConnectionStatementAlarms = "";
    private String connectionStatementAlarms = "";
    private String disConnectionStatementMemos = "";
    private String connectionStatementMemos = "";
    private PGConnection pgConnection;
    private PGNotificationListener pgListener;
    private Set<DbNotificationClient> dbNotificationClientList = Collections.synchronizedSet(new HashSet());

    public void addDbNotificationClient(DbNotificationClient dbNotificationClient) {
        LOG.debug("adding dbNotificationClient:" + dbNotificationClient.toString());
        this.dbNotificationClientList.add(dbNotificationClient);
    }

    public void removeDbNotificationClient(DbNotificationClient dbNotificationClient) {
        LOG.debug("removing dbNotificationClient:" + dbNotificationClient.toString());
        this.dbNotificationClientList.remove(dbNotificationClient);
    }

    public String getConnectionStatementEvents() {
        return this.connectionStatementEvents;
    }

    public void setConnectionStatementEvents(String connectionStatementEvents) {
        this.connectionStatementEvents = connectionStatementEvents;
    }

    public String getDisConnectionStatementEvents() {
        return this.disConnectionStatementEvents;
    }

    public void setDisConnectionStatementEvents(String disConnectionStatementEvents) {
        this.disConnectionStatementEvents = disConnectionStatementEvents;
    }

    public String getConnectionStatementAlarms() {
        return this.connectionStatementAlarms;
    }

    public void setConnectionStatementAlarms(String connectionStatementAlarms) {
        this.connectionStatementAlarms = connectionStatementAlarms;
    }

    public String getDisConnectionStatementAlarms() {
        return this.disConnectionStatementAlarms;
    }

    public void setDisConnectionStatementAlarms(String disConnectionStatementAlarms) {
        this.disConnectionStatementAlarms = disConnectionStatementAlarms;
    }

    public String getDisConnectionStatementMemos() {
        return this.disConnectionStatementMemos;
    }

    public void setDisConnectionStatementMemos(String disConnectionStatementMemos) {
        this.disConnectionStatementMemos = disConnectionStatementMemos;
    }

    public String getConnectionStatementMemos() {
        return this.connectionStatementMemos;
    }

    public void setConnectionStatementMemos(String connectionStatementMemos) {
        this.connectionStatementMemos = connectionStatementMemos;
    }

    public DatabaseChangeNotifier(DbNotifierDataSourceFactory dsFactory, List<String> paramList) throws Throwable {
        PGDataSource dataSource = dsFactory.getPGDataSource();
        if (LOG.isDebugEnabled()) {
            String s = "DatabaseChangeNotifier Paramaters: ";
            for (String param : paramList) {
                s = s + param + " ";
            }
            LOG.debug(s);
            LOG.debug("setting up connection - be patient this is quite slow");
        }
        if (paramList.contains(NOTIFY_ALARM_CHANGES)) {
            this.listenForAlarms = true;
        }
        if (paramList.contains(NOTIFY_EVENT_CHANGES)) {
            this.listenForEvents = true;
        }
        if (paramList.contains(NOTIFY_MEMOS_CHANGES)) {
            this.listenForMemos = true;
        }
        this.pgConnection = (PGConnection)dataSource.getConnection();
        LOG.debug("setting up connection listener");
        this.pgListener = new PGNotificationListener(){
            Logger LOG = LoggerFactory.getLogger(DatabaseChangeNotifier.class);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notification(int processId, String channelName, String payload) {
                DbNotification dbn = new DbNotification(processId, channelName, payload);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("notification received from database - sending to registered clients :\n processId:" + processId + "\n channelName:" + channelName + "\n payload:" + payload);
                }
                Set set = DatabaseChangeNotifier.this.dbNotificationClientList;
                synchronized (set) {
                    Iterator i = DatabaseChangeNotifier.this.dbNotificationClientList.iterator();
                    while (i.hasNext()) {
                        ((DbNotificationClient)i.next()).sendDbNotification(dbn);
                    }
                }
            }
        };
        this.pgConnection.addNotificationListener(this.pgListener);
    }

    public void init() throws Throwable {
        LOG.debug("initialising DatabaseChangeNotifier");
        Statement statement = this.pgConnection.createStatement();
        if (this.listenForEvents) {
            LOG.debug("Executing connectionStatementEvents=" + this.connectionStatementEvents);
            statement.execute(this.connectionStatementEvents);
            LOG.debug("Executing 'LISTEN opennms_event_changes'");
            statement.execute("LISTEN opennms_event_changes");
        }
        if (this.listenForAlarms) {
            LOG.debug("Executing connectionStatementAlarms=" + this.connectionStatementAlarms);
            statement.execute(this.connectionStatementAlarms);
            LOG.debug("Executing 'LISTEN opennms_alarm_changes'");
            statement.execute("LISTEN opennms_alarm_changes");
        }
        if (this.listenForMemos) {
            LOG.debug("Executing connectionStatementMemos=" + this.connectionStatementMemos);
            statement.execute(this.connectionStatementMemos);
            LOG.debug("Executing 'LISTEN opennms_memos_changes'");
            statement.execute("LISTEN opennms_memos_changes");
        }
        statement.close();
    }

    public void destroy() throws Throwable {
        LOG.debug("stopping DatabaseChangeNotifier");
        LOG.debug("clearing dbNotificationClientList");
        this.dbNotificationClientList.clear();
        Statement statement = this.pgConnection.createStatement();
        if (this.listenForEvents) {
            LOG.debug("Executing 'UNLISTEN opennms_event_changes'");
            statement.execute("UNLISTEN opennms_event_changes");
            LOG.debug("Executing disConnectionStatementEvents=" + this.disConnectionStatementEvents);
            statement.execute(this.disConnectionStatementEvents);
        }
        if (this.listenForAlarms) {
            LOG.debug("Executing 'UNLISTEN opennms_alarm_changes'");
            statement.execute("UNLISTEN opennms_alarm_changes");
            LOG.debug("Executing disConnectionStatementAlarms=" + this.disConnectionStatementAlarms);
            statement.execute(this.disConnectionStatementAlarms);
        }
        if (this.listenForMemos) {
            LOG.debug("Executing 'UNLISTEN opennms_memos_changes'");
            statement.execute("UNLISTEN opennms_memos_changes");
            LOG.debug("Executing disConnectionStatementMemos=" + this.disConnectionStatementMemos);
            statement.execute(this.disConnectionStatementMemos);
        }
        statement.close();
    }
}

