/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.dbnotifier.alarmnotifier;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opennms.core.network.IPAddress;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.plugins.com.impossibl.postgres.jdbc.TimestampUtils;
import org.opennms.plugins.dbnotifier.DbNotification;
import org.opennms.plugins.dbnotifier.NotificationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmChangeNotificationClient
implements NotificationClient {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmChangeNotificationClient.class);
    public static final String EVENT_SOURCE_NAME = "AlarmChangeNotifier";
    public static final String ALARM_DELETED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmDeleted";
    public static final String ALARM_CREATED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/NewAlarmCreated";
    public static final String ALARM_SEVERITY_CHANGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmSeverityChanged";
    public static final String ALARM_CLEARED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmCleared";
    public static final String ALARM_ACKNOWLEDGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmAcknowledged";
    public static final String ALARM_UNACKNOWLEDGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmUnAcknowledged";
    public static final String ALARM_SUPPRESSED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmSuppressed";
    public static final String ALARM_UNSUPPRESSED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmUnSuppressed";
    public static final String ALARM_TROUBLETICKET_STATE_CHANGE_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/TroubleTicketStateChange";
    public static final String ALARM_CHANGED_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/AlarmChanged";
    public static final String ALARM_STICKYMEMO_ADD_EVENT = "uei.opennms.org/plugin/AlarmChangeNotificationEvent/StickyMemoAdded";
    public static final String OLD_ALARM_VALUES = "oldalarmvalues";
    public static final String NEW_ALARM_VALUES = "newalarmvalues";
    public static final String INITIAL_SEVERITY = "initialseverity";
    EventProxy eventProxy = null;

    public EventProxy getEventProxy() {
        return this.eventProxy;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.eventProxy = eventProxy;
    }

    @Override
    public void sendDbNotification(DbNotification dbNotification) {
        block34: {
            try {
                EventBuilder eb;
                String payload = dbNotification.getPayload();
                JSONObject newJsonObject = null;
                JSONObject oldJsonObject = null;
                try {
                    JSONParser parser = new JSONParser();
                    Object obj = parser.parse(payload);
                    JSONArray jsonArray = (JSONArray)obj;
                    LOG.debug("payload jsonArray.toString():" + jsonArray.toString());
                    newJsonObject = (JSONObject)jsonArray.get(0);
                    oldJsonObject = (JSONObject)jsonArray.get(1);
                    newJsonObject = this.jsonAlarmTimeNormaliser(newJsonObject);
                    oldJsonObject = this.jsonAlarmTimeNormaliser(oldJsonObject);
                }
                catch (ParseException e1) {
                    throw new RuntimeException("cannot parse notification payload to json object. payload=" + payload, e1);
                }
                if (newJsonObject.isEmpty() && !oldJsonObject.isEmpty()) {
                    if (!"2".equals(oldJsonObject.get((Object)"alarmtype").toString())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("alarm deleted alarmid=" + oldJsonObject.get((Object)"alarmid"));
                        }
                        eb = this.jsonAlarmToEventBuilder(oldJsonObject, new EventBuilder(ALARM_DELETED_EVENT, EVENT_SOURCE_NAME));
                        eb.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                        eb.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                        this.sendEvent(eb.getEvent());
                    }
                    break block34;
                }
                if (!newJsonObject.isEmpty() && oldJsonObject.isEmpty()) {
                    if ("2".equals(newJsonObject.get((Object)"alarmtype").toString())) break block34;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("alarm created alarmid=" + newJsonObject.get((Object)"alarmid"));
                    }
                    eb = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_CREATED_EVENT, EVENT_SOURCE_NAME));
                    eb.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                    eb.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                    if (newJsonObject.get((Object)"severity") != null) {
                        try {
                            String newseverity = newJsonObject.get((Object)"severity").toString();
                            Integer newsvty = Integer.valueOf(newseverity);
                            eb.addParam(INITIAL_SEVERITY, newsvty.toString());
                        }
                        catch (Exception e) {
                            LOG.error("problem parsing initial severity for new alarm event newJsonObject=" + newJsonObject, (Throwable)e);
                        }
                    }
                    this.sendEvent(eb.getEvent());
                    break block34;
                }
                if (!"2".equals(newJsonObject.get((Object)"alarmtype").toString())) {
                    JSONObject newobj = new JSONObject((Map)newJsonObject);
                    JSONObject oldobj = new JSONObject((Map)oldJsonObject);
                    newobj.remove((Object)"lasteventtime");
                    oldobj.remove((Object)"lasteventtime");
                    newobj.remove((Object)"lasteventid");
                    oldobj.remove((Object)"lasteventid");
                    newobj.remove((Object)"counter");
                    oldobj.remove((Object)"counter");
                    newobj.remove((Object)"firstautomationtime");
                    oldobj.remove((Object)"firstautomationtime");
                    newobj.remove((Object)"lastautomationtime");
                    oldobj.remove((Object)"lastautomationtime");
                    if (!newobj.toString().equals(oldobj.toString())) {
                        EventBuilder eb2;
                        String newstickymemo;
                        String newtticketstate;
                        EventBuilder eb3;
                        String oldsuppresseduntil;
                        EventBuilder eb4;
                        String newalarmacktime;
                        String newseverity;
                        String oldseverity = oldJsonObject.get((Object)"severity") == null ? null : oldJsonObject.get((Object)"severity").toString();
                        String string = newseverity = newJsonObject.get((Object)"severity") == null ? null : newJsonObject.get((Object)"severity").toString();
                        if (newseverity != null && !newseverity.equals(oldseverity)) {
                            EventBuilder eb5 = null;
                            if ("2".equals(newseverity)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("alarm cleared alarmid=" + oldJsonObject.get((Object)"alarmid") + " old severity=" + oldseverity + " new severity=" + newseverity);
                                }
                                eb5 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_CLEARED_EVENT, EVENT_SOURCE_NAME));
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("alarm severity changed alarmid=" + oldJsonObject.get((Object)"alarmid") + " old severity=" + oldseverity + " new severity=" + newseverity);
                                }
                                eb5 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_SEVERITY_CHANGED_EVENT, EVENT_SOURCE_NAME));
                            }
                            eb5.addParam("oldseverity", oldseverity);
                            eb5.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb5.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb5.getEvent());
                        }
                        String oldalarmacktime = oldJsonObject.get((Object)"alarmacktime") == null ? null : oldJsonObject.get((Object)"alarmacktime").toString();
                        String string2 = newalarmacktime = newJsonObject.get((Object)"alarmacktime") == null ? null : newJsonObject.get((Object)"alarmacktime").toString();
                        if (oldalarmacktime == null && newalarmacktime != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("alarm acknowleged alarmid=" + newJsonObject.get((Object)"alarmid"));
                            }
                            eb4 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_ACKNOWLEDGED_EVENT, EVENT_SOURCE_NAME));
                            eb4.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb4.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb4.getEvent());
                        } else if (oldalarmacktime != null && newalarmacktime == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("alarm unacknowleged alarmid=" + newJsonObject.get((Object)"alarmid"));
                            }
                            eb4 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_UNACKNOWLEDGED_EVENT, EVENT_SOURCE_NAME));
                            eb4.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb4.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb4.getEvent());
                        }
                        String newsuppresseduntil = newJsonObject.get((Object)"suppresseduntil") == null ? null : newJsonObject.get((Object)"suppresseduntil").toString();
                        String string3 = oldsuppresseduntil = oldJsonObject.get((Object)"suppresseduntil") == null ? null : oldJsonObject.get((Object)"suppresseduntil").toString();
                        if (newsuppresseduntil != null && !newsuppresseduntil.equals(oldsuppresseduntil)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("alarm suppressed alarmid=" + newJsonObject.get((Object)"alarmid"));
                            }
                            eb3 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_SUPPRESSED_EVENT, EVENT_SOURCE_NAME));
                            eb3.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb3.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb3.getEvent());
                        } else if (oldsuppresseduntil != null && newsuppresseduntil == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("alarm unsuppressed alarmid=" + newJsonObject.get((Object)"alarmid"));
                            }
                            eb3 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_UNSUPPRESSED_EVENT, EVENT_SOURCE_NAME));
                            eb3.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb3.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb3.getEvent());
                        }
                        String oldtticketid = oldJsonObject.get((Object)"tticketid") == null ? null : oldJsonObject.get((Object)"tticketid").toString();
                        String newtticketid = newJsonObject.get((Object)"tticketid") == null ? null : newJsonObject.get((Object)"tticketid").toString();
                        String oldtticketstate = oldJsonObject.get((Object)"tticketstate") == null ? null : oldJsonObject.get((Object)"tticketstate").toString();
                        String string4 = newtticketstate = newJsonObject.get((Object)"tticketstate") == null ? null : newJsonObject.get((Object)"tticketstate").toString();
                        if (oldtticketid == null && newtticketid != null || oldtticketid != null && !newtticketid.equals(oldtticketid) || oldtticketstate == null && newtticketstate != null || oldtticketstate != null && !newtticketstate.equals(oldtticketstate)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("trouble ticket state changed for alarmid=" + oldJsonObject.get((Object)"alarmid") + " oldtticketid=" + oldtticketid + " newtticketid=" + newtticketid + " oldtticketstate=" + oldtticketstate + " newtticketstate=" + newtticketstate);
                            }
                            EventBuilder eb6 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_TROUBLETICKET_STATE_CHANGE_EVENT, EVENT_SOURCE_NAME));
                            eb6.addParam("oldtticketid", oldtticketid);
                            eb6.addParam("tticketid", newtticketid);
                            eb6.addParam("oldtticketstate", oldtticketstate);
                            eb6.addParam("tticketstate", newtticketstate);
                            eb6.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb6.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb6.getEvent());
                        }
                        String oldstickymemo = oldJsonObject.get((Object)"stickymemo") == null ? null : oldJsonObject.get((Object)"stickymemo").toString();
                        String string5 = newstickymemo = newJsonObject.get((Object)"stickymemo") == null ? null : newJsonObject.get((Object)"stickymemo").toString();
                        if (newstickymemo != null && !newstickymemo.equals(oldstickymemo)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Sticky memo added for alarmid=" + oldJsonObject.get((Object)"alarmid") + " newstickymemo=" + newstickymemo);
                            }
                            eb2 = this.jsonAlarmToEventBuilder(newJsonObject, new EventBuilder(ALARM_STICKYMEMO_ADD_EVENT, EVENT_SOURCE_NAME));
                            eb2.addParam("stickymemo", newstickymemo);
                            eb2.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb2.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb2.getEvent());
                        }
                        newobj.remove((Object)"severity");
                        oldobj.remove((Object)"severity");
                        newobj.remove((Object)"alarmacktime");
                        oldobj.remove((Object)"alarmacktime");
                        newobj.remove((Object)"alarmackuser");
                        oldobj.remove((Object)"alarmackuser");
                        newobj.remove((Object)"suppresseduntil");
                        oldobj.remove((Object)"suppresseduntil");
                        newobj.remove((Object)"suppresseduser");
                        oldobj.remove((Object)"suppresseduser");
                        newobj.remove((Object)"tticketid");
                        oldobj.remove((Object)"tticketid");
                        newobj.remove((Object)"tticketstate");
                        oldobj.remove((Object)"tticketstate");
                        newobj.remove((Object)"stickymemo");
                        oldobj.remove((Object)"stickymemo");
                        if (!newobj.toString().equals(oldobj.toString())) {
                            eb2 = this.jsonAlarmToEventBuilder(oldJsonObject, new EventBuilder(ALARM_CHANGED_EVENT, EVENT_SOURCE_NAME));
                            eb2.addParam(OLD_ALARM_VALUES, oldJsonObject.toString());
                            eb2.addParam(NEW_ALARM_VALUES, newJsonObject.toString());
                            this.sendEvent(eb2.getEvent());
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("problem creating opennms alarm change event from database notification", (Throwable)e);
            }
        }
    }

    private EventBuilder jsonAlarmToEventBuilder(JSONObject jsonObject, EventBuilder eb) {
        String alarmId = jsonObject.get((Object)"alarmid") == null ? null : jsonObject.get((Object)"alarmid").toString();
        String severity = jsonObject.get((Object)"severity") == null ? null : jsonObject.get((Object)"severity").toString();
        String logmsg = jsonObject.get((Object)"logmsg") == null ? null : jsonObject.get((Object)"logmsg").toString();
        String eventuei = jsonObject.get((Object)"eventuei") == null ? null : jsonObject.get((Object)"eventuei").toString();
        String reductionkey = jsonObject.get((Object)"reductionkey") == null ? null : jsonObject.get((Object)"reductionkey").toString();
        String clearkey = jsonObject.get((Object)"clearkey") == null ? null : jsonObject.get((Object)"clearkey").toString();
        String alarmtype = jsonObject.get((Object)"alarmtype") == null ? null : jsonObject.get((Object)"alarmtype").toString();
        String alarmacktime = jsonObject.get((Object)"alarmacktime") == null ? null : jsonObject.get((Object)"alarmacktime").toString();
        String alarmackuser = jsonObject.get((Object)"alarmackuser") == null ? null : jsonObject.get((Object)"alarmackuser").toString();
        String suppressedtime = jsonObject.get((Object)"suppressedtime") == null ? null : jsonObject.get((Object)"suppressedtime").toString();
        String suppresseduntil = jsonObject.get((Object)"suppresseduntil") == null ? null : jsonObject.get((Object)"suppresseduntil").toString();
        String suppresseduser = jsonObject.get((Object)"suppresseduser") == null ? null : jsonObject.get((Object)"suppresseduser").toString();
        String nodeid = jsonObject.get((Object)"nodeid") == null ? null : jsonObject.get((Object)"nodeid").toString();
        String ipaddr = jsonObject.get((Object)"ipaddr") == null ? null : jsonObject.get((Object)"ipaddr").toString();
        String ifindex = jsonObject.get((Object)"ifindex") == null ? null : jsonObject.get((Object)"ifindex").toString();
        String applicationdn = jsonObject.get((Object)"applicationdn") == null ? null : jsonObject.get((Object)"applicationdn").toString();
        String serviceid = jsonObject.get((Object)"serviceid") == null ? null : jsonObject.get((Object)"serviceid").toString();
        String systemid = jsonObject.get((Object)"systemid") == null ? null : jsonObject.get((Object)"systemid").toString();
        eb.addParam("alarmid", alarmId);
        eb.addParam("severity", severity);
        eb.addParam("logmsg", logmsg);
        eb.addParam("clearkey", clearkey);
        eb.addParam("alarmtype", alarmtype);
        eb.addParam("alarmacktime", alarmacktime);
        eb.addParam("alarmackuser", alarmackuser);
        eb.addParam("suppressedtime", suppressedtime);
        eb.addParam("suppresseduntil", suppresseduntil);
        eb.addParam("suppresseduser", suppresseduser);
        eb.addParam("eventuei", eventuei);
        eb.addParam("reductionkey", reductionkey);
        if (nodeid != null) {
            eb.setNodeid(Long.parseLong(nodeid));
        }
        if (ipaddr != null) {
            try {
                IPAddress ipaddress = new IPAddress(ipaddr);
                eb.setInterface(ipaddress.toInetAddress());
            }
            catch (Exception e) {
                LOG.error("cannot parse json object ipaddr=" + ipaddr, (Throwable)e);
            }
        }
        if (ifindex != null) {
            eb.setIfIndex(Integer.parseInt(ifindex));
        }
        eb.addParam("applicationdn", applicationdn);
        eb.addParam("serviceid", serviceid);
        eb.addParam("systemid", systemid);
        return eb;
    }

    private void sendEvent(Event e) {
        LOG.debug("sending event to opennms. event.tostring():" + e.toString());
        try {
            if (this.eventProxy != null) {
                this.eventProxy.send(e);
            } else {
                LOG.error("OpenNMS event proxy not set - cannot send events to opennms");
            }
        }
        catch (EventProxyException ex) {
            throw new RuntimeException("event proxy problem sending AlarmChangeNotificationEvent to OpenNMS:", ex);
        }
    }

    public JSONObject jsonAlarmTimeNormaliser(JSONObject jsonObject) {
        String lastautomationtime;
        String firstautomationtime;
        String firsteventtime;
        String alarmacktime;
        String lasteventtime;
        String suppresseduntil;
        String suppressedtime;
        if (jsonObject.isEmpty()) {
            return jsonObject;
        }
        String string = suppressedtime = jsonObject.get((Object)"suppressedtime") == null ? null : this.timeNormaliser(jsonObject.get((Object)"suppressedtime").toString());
        if (suppressedtime != null) {
            jsonObject.put((Object)"suppressedtime", (Object)suppressedtime);
        }
        String string2 = suppresseduntil = jsonObject.get((Object)"suppresseduntil") == null ? null : this.timeNormaliser(jsonObject.get((Object)"suppresseduntil").toString());
        if (suppresseduntil != null) {
            jsonObject.put((Object)"suppresseduntil", (Object)suppresseduntil);
        }
        String string3 = lasteventtime = jsonObject.get((Object)"lasteventtime") == null ? null : this.timeNormaliser(jsonObject.get((Object)"lasteventtime").toString());
        if (lasteventtime != null) {
            jsonObject.put((Object)"lasteventtime", (Object)lasteventtime);
        }
        String string4 = alarmacktime = jsonObject.get((Object)"alarmacktime") == null ? null : this.timeNormaliser(jsonObject.get((Object)"alarmacktime").toString());
        if (alarmacktime != null) {
            jsonObject.put((Object)"alarmacktime", (Object)alarmacktime);
        }
        String string5 = firsteventtime = jsonObject.get((Object)"firsteventtime") == null ? null : this.timeNormaliser(jsonObject.get((Object)"firsteventtime").toString());
        if (firsteventtime != null) {
            jsonObject.put((Object)"firsteventtime", (Object)firsteventtime);
        }
        String string6 = firstautomationtime = jsonObject.get((Object)"firstautomationtime") == null ? null : this.timeNormaliser(jsonObject.get((Object)"firstautomationtime").toString());
        if (firstautomationtime != null) {
            jsonObject.put((Object)"firstautomationtime", (Object)firstautomationtime);
        }
        String string7 = lastautomationtime = jsonObject.get((Object)"lastautomationtime") == null ? null : this.timeNormaliser(jsonObject.get((Object)"lastautomationtime").toString());
        if (lastautomationtime != null) {
            jsonObject.put((Object)"lastautomationtime", (Object)lastautomationtime);
        }
        return jsonObject;
    }

    public String timeNormaliser(String dbTimeStr) {
        String normalisedTimeStr = null;
        Calendar alarmCreationCal = null;
        TimestampUtils timestampUtils = new TimestampUtils();
        try {
            Timestamp timestamp = timestampUtils.toTimestamp(null, dbTimeStr);
            alarmCreationCal = Calendar.getInstance();
            alarmCreationCal.setTime(timestamp);
            normalisedTimeStr = DatatypeConverter.printDateTime((Calendar)alarmCreationCal);
        }
        catch (Exception e) {
            LOG.error("cannot parse database json time string dbTimeStr" + dbTimeStr, (Throwable)e);
        }
        return normalisedTimeStr;
    }

    @Override
    public void init() {
        LOG.debug("initialising AlarmChangeNotificationClient");
        if (this.eventProxy == null) {
            LOG.debug("OpenNMS event proxy not set - cannot send events to opennms");
        }
    }

    @Override
    public void destroy() {
    }
}

